/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.multiple;

import com.complexible.memory.structure.BaseIterator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.LongAddressableTapeIterator;
import com.complexible.memory.structure.search.BinarySearcher;
import com.complexible.memory.structure.search.SearchUtils;
import com.complexible.memory.util.Utilities;

abstract class BaseMultipleLongSkippingTapeIterator<I extends LongAddressableTapeIterator, S extends BinarySearcher>
extends BaseIterator {
    protected boolean mIsOpen;
    protected long mCurrentSlotNumber;
    protected final BinaryIndex mBinaryIndex;
    protected final S mBinarySearcher;
    protected final I mAddressableTapeIterator;

    BaseMultipleLongSkippingTapeIterator(I theAddressableTapeIterator, S theBinarySearcher, BinaryIndex theBinaryIndex) {
        this.mBinaryIndex = theBinaryIndex;
        this.mBinarySearcher = theBinarySearcher;
        this.mAddressableTapeIterator = theAddressableTapeIterator;
    }

    @Override
    public boolean hasNext0() {
        if (this.mCurrentSlotNumber == (long)Utilities.DUMMY_INDEX || !this.mIsOpen) {
            return false;
        }
        if (this.mAddressableTapeIterator.hasNext()) {
            return true;
        }
        this.mCurrentSlotNumber = Utilities.DUMMY_INDEX;
        this.mAddressableTapeIterator.gotoAddress(-1L);
        return false;
    }

    @Override
    public void reset0() {
        this.checkOpen();
        this.mCurrentSlotNumber = 0L;
        this.mAddressableTapeIterator.gotoAddress(0L);
        this.mAddressableTapeIterator.reset();
    }

    @Override
    protected void close0() {
        this.closeIterator();
        this.mAddressableTapeIterator.close();
    }

    public long next() {
        this.iterateNext();
        ++this.mCurrentSlotNumber;
        if (this.mCurrentSlotNumber == this.mBinaryIndex.slotsCount()) {
            this.mCurrentSlotNumber = Utilities.DUMMY_INDEX;
        }
        return this.mAddressableTapeIterator.next();
    }

    @Override
    public void dispose0() {
        this.closeIterator();
        this.mAddressableTapeIterator.dispose();
    }

    protected abstract long getAddressBySlotNumber(long var1);

    protected void checkOpen() {
        if (!this.mIsOpen) {
            this.mIsOpen = true;
            this.mBinarySearcher.init(this.mBinaryIndex);
        }
    }

    private void closeIterator() {
        this.mIsOpen = false;
        this.mBinaryIndex.close();
        this.mCurrentSlotNumber = Utilities.DUMMY_INDEX;
    }

    protected final boolean handleSlot(long theSlotNumber) {
        if (theSlotNumber == (long)SearchUtils.SEARCH_RESULT_NOT_FOUND) {
            this.mCurrentSlotNumber = Utilities.DUMMY_INDEX;
            return this.hasNext();
        }
        if (theSlotNumber == (long)SearchUtils.SEARCH_RESULT_ELEMENT_IN_LEFT_RANGE) {
            this.initAddressableIterator();
            return this.hasNext();
        }
        this.mCurrentSlotNumber = theSlotNumber;
        this.initAddressableIterator();
        return this.mAddressableTapeIterator.hasNext();
    }

    private void initAddressableIterator() {
        this.mAddressableTapeIterator.reset();
        this.mAddressableTapeIterator.gotoAddress(this.getAddressBySlotNumber(this.mCurrentSlotNumber));
    }
}

