/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple;

import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.QuadLongAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.TripleLongMemoryAddressableTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public class QuadLongMemoryAddressableTapeIterator
extends TripleLongMemoryAddressableTapeIterator
implements QuadLongAddressableTapeIterator {
    private long mLongValue4;

    public QuadLongMemoryAddressableTapeIterator(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier) {
        super(theMemoryContext, theMemoryBlockChainObjectSupplier);
    }

    @Override
    protected int getSlotSize() {
        return 32;
    }

    @Override
    protected long calculateAddress(long theElementsCount) {
        return Utilities.multiplyLongPowerOfTwoAsLong(theElementsCount, 5);
    }

    @Override
    protected void readNext() {
        super.readNext();
        try {
            this.mLongValue4 = this.mAddressAccessor.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long current4() {
        return this.mLongValue4;
    }
}

