/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple;

import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseIterator;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.iterator.AddressableTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public abstract class BaseLongMemoryAddressableTapeIterator
extends BaseIterator
implements AddressableTapeIterator {
    private long mLastAddress;
    private long mCurrentAddress;
    private final int mSlotSize;
    private final Supplier<MemoryBlockChain> mMemoryBlockChainHolder;
    protected final MemoryBlockChainByteReaderWriter mAddressAccessor;

    public BaseLongMemoryAddressableTapeIterator(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier) {
        this.mMemoryBlockChainHolder = theMemoryBlockChainObjectSupplier;
        this.mAddressAccessor = new MemoryBlockChainByteReaderWriterImpl(theMemoryBlockChainObjectSupplier, theMemoryContext);
        this.mSlotSize = this.getSlotSize();
    }

    @Override
    protected boolean hasNext0() {
        if (this.mCurrentAddress == -1L) {
            return false;
        }
        try {
            this.mAddressAccessor.setPosition(this.mCurrentAddress);
            this.readNext();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.setNextAddress();
        return true;
    }

    @Override
    public void gotoAddress(long theAddress) {
        this.mCurrentAddress = theAddress;
        this.mLastAddress = this.calculateAddress(this.mMemoryBlockChainHolder.get().getTotalElementsCount());
    }

    @Override
    protected void reset0() {
        this.mCurrentAddress = 0L;
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        this.reset0();
    }

    protected abstract void readNext();

    protected abstract int getSlotSize();

    protected abstract long calculateAddress(long var1);

    private void setNextAddress() {
        this.mCurrentAddress += (long)this.mSlotSize;
        if (this.mCurrentAddress == this.mLastAddress) {
            this.mCurrentAddress = -1L;
        }
    }
}

