/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable;

import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class ConventionalMemoryAddressableTapeIterator
extends BaseConventionalTapeIterator<TapeElementInput>
implements ConventionalAddressableTapeIterator<TapeElementInput> {
    private final int mSlotSize;
    private long mLastAddress;
    private long mCurrentAddress;
    private final int mSlotSizeBitPosition;
    private final MemoryBlockChainByteReaderWriter mAddressAccessor;
    private final TapeElementInputFactory mTapeElementInputFactory;
    private final Supplier<MemoryBlockChain> mMemoryBlockChainHolder;

    public ConventionalMemoryAddressableTapeIterator(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theAddressObjectSupplier, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier, int theSlotSize, int theSlotSizeBitPosition) {
        this.mSlotSize = theSlotSize;
        this.mSlotSizeBitPosition = theSlotSizeBitPosition;
        this.mMemoryBlockChainHolder = theMemoryBlockChainObjectSupplier;
        this.mAddressAccessor = new MemoryBlockChainByteReaderWriterImpl(theAddressObjectSupplier, theMemoryContext);
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
        this.reset();
    }

    @Override
    public boolean hasNext0() {
        int aOffset;
        int aIndex;
        if (this.mCurrentAddress == -1L) {
            return false;
        }
        try {
            this.mAddressAccessor.setPosition(this.mCurrentAddress);
            aIndex = this.mAddressAccessor.readInt();
            aOffset = this.mAddressAccessor.readInt();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        MemoryBlockChain aMemoryBlockChain = this.mMemoryBlockChainHolder.get();
        this.mTapeElementInput = this.mTapeElementInputFactory.createMemoryInput(aMemoryBlockChain, aOffset, aIndex);
        this.setNextAddress();
        return true;
    }

    @Override
    public TapeElementInput next0() {
        return this.mTapeElementInput;
    }

    @Override
    public void gotoAddress(long theAddress) {
        this.mCurrentAddress = theAddress;
        this.mLastAddress = Utilities.multiplyLongPowerOfTwoAsLong(this.mMemoryBlockChainHolder.get().getTotalElementsCount(), this.mSlotSizeBitPosition);
    }

    @Override
    public void reset0() {
        this.mCurrentAddress = 0L;
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        this.reset0();
        this.mTapeElementInputFactory.dispose();
    }

    private void setNextAddress() {
        this.mCurrentAddress += (long)this.mSlotSize;
        if (this.mCurrentAddress == this.mLastAddress) {
            this.mCurrentAddress = -1L;
        }
    }
}

