/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectReader;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.BaseConventionalSkippingTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.SorterSkippingIterator;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;
import com.complexible.memory.structure.search.SortedArrayBinarySearcher;
import com.complexible.memory.util.Utilities;
import java.util.Comparator;

public final class ConventionalSkippingTapeIterator
extends BaseConventionalSkippingTapeIterator<SortedArrayBinarySearcher>
implements SorterSkippingIterator {
    public ConventionalSkippingTapeIterator(ConventionalAddressableTapeIterator theAddressableTapeIterator, SortedArrayBinarySearcher theSortedArrayBinarySearcher, BinaryIndex theBinaryIndex) {
        super(theAddressableTapeIterator, theSortedArrayBinarySearcher, theBinaryIndex);
    }

    @Override
    public boolean skipTo(ByteReader theByteReader) {
        this.checkOpen();
        if (this.mCurrentSlotNumber == (long)Utilities.DUMMY_INDEX) {
            return false;
        }
        long aSlotNumber = ((SortedArrayBinarySearcher)this.mBinarySearcher).search(this.mCurrentSlotNumber, theByteReader, this.mBinaryIndex.slotsCount(), false);
        return this.handleSlot(aSlotNumber);
    }

    @Override
    public <T> boolean skipTo(T theElement, Comparator<T> theComparator, ObjectReader theObjectReader) {
        this.checkOpen();
        if (this.mCurrentSlotNumber == (long)Utilities.DUMMY_INDEX) {
            return false;
        }
        long aSlotNumber = ((SortedArrayBinarySearcher)this.mBinarySearcher).search(this.mCurrentSlotNumber, theElement, theComparator, theObjectReader, this.mBinaryIndex.slotsCount(), false);
        return this.handleSlot(aSlotNumber);
    }

    @Override
    protected long getAddressBySlotNumber(long theSlotNumber) {
        return Utilities.multiplyLongPowerOfTwoAsLong(theSlotNumber, 3);
    }
}

