/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.input.impl.DefaultTapeElementInputFactory;
import com.complexible.memory.structure.sort.iterator.ConventionalLongOptimizedMultiInputIterator;
import com.complexible.memory.structure.sort.iterator.GenericMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class ByteReaderIterator
implements GenericMultiInputIterator,
ConventionalLongOptimizedMultiInputIterator {
    private boolean mRecordMatching;
    private long mCompareLongIndex;
    private TapeElementInput mTapeElementInput;
    private final ObjectSupplier<ByteReader> mReaderObjectSupplier;
    private final DefaultTapeElementInputFactory mTapeElementInputFactory;

    public ByteReaderIterator(MemoryContext theMemoryContext, ObjectSupplier<ByteReader> theReaderObjectSupplier) {
        this.mReaderObjectSupplier = theReaderObjectSupplier;
        this.mTapeElementInputFactory = new DefaultTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public boolean next(int theInputId) {
        if (this.mRecordMatching) {
            return false;
        }
        this.mRecordMatching = true;
        return true;
    }

    @Override
    public TapeElementInput getInput(int theInputId) {
        TapeElementInput aTapeElementInput = this.mTapeElementInput;
        if (aTapeElementInput == null) {
            return this.createInput(theInputId, this.mTapeElementInputFactory);
        }
        aTapeElementInput.reset();
        return aTapeElementInput;
    }

    @Override
    public TapeElementInput createInput(int theInputId, TapeElementInputFactory theATapeElementInputFactory) {
        Object aTapeElementInput = theATapeElementInputFactory.createByteReaderInput(this.mReaderObjectSupplier.get());
        this.mTapeElementInput = aTapeElementInput;
        return aTapeElementInput;
    }

    @Override
    public long longValue(int theInputId, int theOffset) {
        ByteReader aByteReader = this.mReaderObjectSupplier.get();
        try {
            aByteReader.setPosition(this.mCompareLongIndex);
            return aByteReader.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void setComparableLongOffset(long theOffset) {
        this.mCompareLongIndex = theOffset;
    }

    @Override
    public void reset() {
        this.mRecordMatching = false;
        this.mTapeElementInput = null;
        this.mReaderObjectSupplier.set(null);
    }

    @Override
    public void dispose() {
        this.reset();
        this.mTapeElementInputFactory.dispose();
    }
}

