/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.CollectionIterator;
import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.Sorter;
import com.complexible.memory.util.SpillingUtil;
import java.util.function.Supplier;

public final class AssemblingSortedArrayIterator<I extends MultiInputIterator, O extends OutputCollector, H extends Sorter<I, O>>
implements CollectionIterator {
    private boolean isActive;
    private final H mHeapSorter;
    private final I mDualIterator;
    private final O mOutputCollector;
    private final FileReader mDiskReader;
    private final Supplier<MemoryBlockChain> mMemoryBlockChainSupplier;

    public AssemblingSortedArrayIterator(I theDualIterator, H theHeapSorter, O theOutputCollector, FileReader theDiskReader, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier) {
        this.mHeapSorter = theHeapSorter;
        this.mDiskReader = theDiskReader;
        this.mDualIterator = theDualIterator;
        this.mOutputCollector = theOutputCollector;
        this.mMemoryBlockChainSupplier = theMemoryBlockChainObjectSupplier;
    }

    @Override
    public boolean hasNext() {
        if (!this.isActive) {
            this.activate();
        }
        if (this.mHeapSorter.assemble()) {
            this.reset();
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.isActive = false;
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskReader});
        this.mDualIterator.reset();
    }

    @Override
    public void dispose() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[4];
        autoCloseableArray[0] = this::reset;
        autoCloseableArray[1] = () -> this.mHeapSorter.dispose();
        autoCloseableArray[2] = this.mDiskReader;
        autoCloseableArray[3] = () -> this.mDualIterator.dispose();
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    @Override
    public void close() {
        this.reset();
    }

    private void activate() {
        SpillingUtil.openDiskReader(this.mDiskReader, this.mMemoryBlockChainSupplier.get());
        this.isActive = true;
        this.mHeapSorter.setChunkSize(1);
        this.mHeapSorter.resetTo(this.mDualIterator, this.mOutputCollector);
    }
}

