/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.index;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class DiskIndex
implements BinaryIndex {
    private final DataArea mAddressingArea;
    private final FileReader mFileReader;
    private final Supplier<MemoryBlockChain> mBlockChainObjectSupplier;

    public DiskIndex(FileReader theIndexFileReader, DataArea theAddressingArea, Supplier<MemoryBlockChain> theBlockChainObjectSupplier) {
        this.mFileReader = theIndexFileReader;
        this.mAddressingArea = theAddressingArea;
        this.mBlockChainObjectSupplier = theBlockChainObjectSupplier;
    }

    @Override
    public void open() {
        if (this.mAddressingArea.get().getSpilledFile() == null) {
            return;
        }
        try {
            this.mFileReader.setInput(this.mAddressingArea.get().getSpilledFile());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public long slotsCount() {
        return this.mBlockChainObjectSupplier.get().getTotalElementsCount();
    }

    @Override
    public ByteReader getSource() {
        return this.mFileReader;
    }

    @Override
    public void close() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mFileReader});
    }
}

