/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.iterator;

import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.input.TapeElementInput;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultBufferTapeIterator
extends BaseConventionalTapeIterator {
    private boolean mDiskDone;
    private final TapeIterator mDiskIterator;
    private AtomicInteger mIteratorCounter;
    private final TapeIterator mMemoryIterator;

    public DefaultBufferTapeIterator(TapeIterator theDiskIterator, TapeIterator theMemoryIterator, AtomicInteger mIteratorCounter) {
        this.mIteratorCounter = mIteratorCounter;
        this.mDiskDone = false;
        this.mDiskIterator = theDiskIterator;
        this.mMemoryIterator = theMemoryIterator;
        mIteratorCounter.incrementAndGet();
    }

    @Override
    public boolean hasNext0() {
        if (!this.mDiskDone) {
            if (this.mDiskIterator.hasNext()) {
                this.mTapeElementInput = this.mDiskIterator.next();
                return true;
            }
            this.mDiskDone = true;
        }
        if (this.mMemoryIterator.hasNext()) {
            this.mTapeElementInput = this.mMemoryIterator.next();
            return true;
        }
        return false;
    }

    public TapeElementInput next0() {
        return this.mTapeElementInput;
    }

    @Override
    public void reset0() {
        this.mDiskDone = false;
        this.mDiskIterator.reset();
        this.mMemoryIterator.reset();
    }

    @Override
    protected void close0() {
        this.mDiskDone = false;
        this.mDiskIterator.close();
        this.mMemoryIterator.close();
    }

    @Override
    public void dispose0() {
        this.mDiskDone = false;
        this.mDiskIterator.dispose();
        this.mMemoryIterator.dispose();
        this.mIteratorCounter.decrementAndGet();
    }
}

