/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.ObjectWriter;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Array;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.array.iterator.DefaultBufferTapeIterator;
import com.complexible.memory.structure.impl.array.iterator.DiskTapeIterator;
import com.complexible.memory.structure.impl.array.iterator.MemoryTapeIterator;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedTape;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultArrayImpl
extends ConventionalSpillingSupportedTape<Array>
implements Array {
    private volatile boolean mBarrier = true;
    private final int mSpillingBufferSize;
    private final TapeIterator mTapeIterator;
    private final TapeIterator mMemoryTapeIterator;
    private final AtomicInteger mIteratorCounter = new AtomicInteger(0);

    public DefaultArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, (CollectionFactory<Array>)null, theOperationTracker);
    }

    DefaultArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<Array> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        this.mSpillingBufferSize = theSpillingBufferSize;
        this.mMemoryTapeIterator = new MemoryTapeIterator(theMemoryContext, this.mDataAreaAccessor, this.mIteratorCounter);
        this.mTapeIterator = this.createTapeIterator(this.mMemoryTapeIterator, theMemoryContext, this.mDiskDataBlocksReader);
    }

    @Override
    public void createArray() {
        try {
            super.createTape();
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
        finally {
            this.mBarrier = true;
        }
    }

    @Override
    public void append(ByteReader theReader) throws IOException {
        super.append(theReader);
        this.mBarrier = true;
    }

    @Override
    public <TT> void append(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        super.append(theObject, theFactory);
        this.mBarrier = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <TT> void spillBlob(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.logBlobSpilling();
            this.openDiskWriter();
            try {
                ObjectWriter aObjectWriter = theFactory.writer((ByteWriter)this.mDiskDataBlocksWriter);
                this.mDiskDataBlocksWriter.setPosition(8L);
                aObjectWriter.write(theObject);
                long aSize = this.mDiskDataBlocksWriter.getPosition() - 8L;
                this.mDiskDataBlocksWriter.setPosition(0L);
                this.mDiskDataBlocksWriter.writeLong(aSize);
                long aWrittenBytes = aSize + 8L;
                this.mDataMemoryBlockChain.incrementTotalSpilledBytes(aWrittenBytes);
                this.mOperationTracker.onSpilling(aWrittenBytes);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
                throw throwable;
            }
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void spillBlob(ByteReader theDataReader) throws IOException {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.logBlobSpilling();
            this.openDiskWriter();
            try {
                theDataReader.setPosition(0L);
                this.mDiskDataBlocksWriter.writeLong(theDataReader.length());
                this.mDiskDataBlocksWriter.writeByteReader(theDataReader);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
                long aWrittenBytes = theDataReader.length() + 8L;
                this.mDataMemoryBlockChain.incrementTotalSpilledBytes(aWrittenBytes);
                this.mOperationTracker.onSpilling(aWrittenBytes);
                throw throwable;
            }
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksWriter});
            long aWrittenBytes = theDataReader.length() + 8L;
            this.mDataMemoryBlockChain.incrementTotalSpilledBytes(aWrittenBytes);
            this.mOperationTracker.onSpilling(aWrittenBytes);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    public TapeIterator getTapeIterator() {
        TapeIterator aTapeIterator = this.mBarrier && this.mDataMemoryBlockChain.getTotalSpilledBytes() > 0L ? this.mTapeIterator : this.mMemoryTapeIterator;
        aTapeIterator.reset();
        return aTapeIterator;
    }

    @Override
    public TapeIterator createTapeIterator() {
        MemoryTapeIterator aTapeIterator = this.mBarrier && this.mDataMemoryBlockChain.getTotalSpilledBytes() > 0L ? this.createTapeIterator(this.createMemoryTapeIterator(), this.mMemoryContext, new DefaultFileReader(this.mSpillingBufferSize)) : this.createMemoryTapeIterator();
        aTapeIterator.reset();
        return aTapeIterator;
    }

    @Override
    public void dispose() {
        try {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
            autoCloseableArray[0] = this.mTapeIterator::dispose;
            autoCloseableArray[1] = () -> super.dispose();
            AutoCloser.close((AutoCloseable[])autoCloseableArray);
        }
        finally {
            this.mBarrier = true;
        }
        if (this.mIteratorCounter.get() > 0) {
            throw new IllegalStateException("Collection was disposed while it has active open iterators");
        }
    }

    @Override
    protected Array getCollection() {
        return this;
    }

    private MemoryTapeIterator createMemoryTapeIterator() {
        return new MemoryTapeIterator(this.mMemoryContext, this.mDataAreaAccessor, this.mIteratorCounter);
    }

    private TapeIterator createTapeIterator(TapeIterator theMemoryTapeIterator, MemoryContext theMemoryContext, FileReader theFileReader) {
        return new DefaultBufferTapeIterator(new DiskTapeIterator(theFileReader, this.mMemoryBlockChainFactory, this.mDataAreaAccessor, theMemoryContext, this.mIteratorCounter), theMemoryTapeIterator, this.mIteratorCounter);
    }
}

