/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator.secondary;

import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ConventionalAggregator;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.aggregator.AggregationPolicy;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.SingleSKResultTapeIterator;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;

public final class SingleSKDiskResultTapeIterator
extends SingleSKResultTapeIterator {
    private boolean mIsReaderOpened;
    private final DefaultFileReader mDiskDataBlocksReader;
    private final Supplier<MemoryBlockChain> mMemoryDataObjectSupplier;

    public SingleSKDiskResultTapeIterator(MemoryContext theMemoryContext, AggregatorAssembler theAssembler, ConventionalAggregator theAggregator, DefaultFileReader theDiskDataBlocksReader, ConventionalSegmentedTapeIterator theAggregatorMainIterator, Supplier<MemoryBlockChain> theDataObjectSupplier, ObjectSupplier<AggregationPolicy> thePolicyObjectSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(theMemoryContext, theAssembler, theAggregator, theAggregatorMainIterator, thePolicyObjectSupplier, new DefaultHashTableTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory));
        this.mDiskDataBlocksReader = theDiskDataBlocksReader;
        this.mMemoryDataObjectSupplier = theDataObjectSupplier;
    }

    @Override
    public boolean hasNext0() {
        this.checkFileOpened();
        if (super.hasNext0()) {
            return true;
        }
        this.mDiskDataBlocksReader.close();
        return false;
    }

    @Override
    public void reset0() {
        super.reset0();
        this.closeReader();
    }

    private void closeReader() {
        this.mIsReaderOpened = false;
        this.mDiskDataBlocksReader.close();
    }

    @Override
    protected void close0() {
        super.close0();
        this.closeReader();
    }

    @Override
    public void dispose0() {
        super.dispose0();
        this.closeReader();
    }

    private void checkFileOpened() {
        if (!this.mIsReaderOpened) {
            this.openFileReader();
            this.mIsReaderOpened = true;
        }
    }

    private void openFileReader() {
        File aFile = this.mMemoryDataObjectSupplier.get().getSpilledFile();
        if (aFile != null) {
            try {
                this.mDiskDataBlocksReader.setInput(aFile);
            }
            catch (IOException theE) {
                throw new RuntimeException(theE);
            }
        }
    }
}

