/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator.secondary;

import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ConventionalAggregator;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.aggregator.AggregationPolicy;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.BaseSKResultTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.SecondaryKeyDelimiter;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;

public final class MultiSKResultTapeIterator
extends BaseSKResultTapeIterator
implements ConventionalHashTableTapeIterator {
    private boolean mActiveSegment;
    private boolean mActiveStrategy;
    private boolean mStrategyProcessed;
    private int mAggregationStrategyIndex;

    public MultiSKResultTapeIterator(MemoryContext theMemoryContext, ConventionalAggregator theAggregator, ConventionalSegmentedTapeIterator theAggregatorMainIterator, ObjectSupplier<AggregationPolicy> thePolicyObjectSupplier, MemoryBlockChainFactory theMemoryBlockChainFactory) {
        super(theMemoryContext, theAggregator, theAggregatorMainIterator, thePolicyObjectSupplier, new DefaultHashTableTapeElementInputFactory(theMemoryContext, theMemoryBlockChainFactory));
    }

    @Override
    protected boolean checkNext() {
        if (this.check()) {
            return true;
        }
        this.mActiveStrategy = false;
        this.mStrategyProcessed = false;
        return this.check();
    }

    @Override
    protected boolean nextPKInput() {
        if (this.mStrategyProcessed) {
            return false;
        }
        if (this.mAggregatorMainIterator.hasNext()) {
            this.mTapeElementInput = this.mAggregatorMainIterator.next();
        } else {
            this.mTapeElementInput = SecondaryKeyDelimiter.INSTANCE;
            this.mStrategyProcessed = true;
        }
        return true;
    }

    @Override
    protected boolean nextAggregatedInput() {
        if (this.mStrategyProcessed) {
            return false;
        }
        if (!this.processAggregatedInput()) {
            this.mStrategyProcessed = true;
        }
        return true;
    }

    @Override
    protected boolean checkAggregated() {
        return this.mStrategyProcessed;
    }

    @Override
    protected boolean isSegmentAggregated() {
        return !this.nextSegmentElement();
    }

    @Override
    protected boolean nextSegmentElement() {
        if (this.mAggregatorMainIterator.hasNext()) {
            this.mNextElement = (HashTableTapeElementInput)this.mAggregatorMainIterator.next();
            return true;
        }
        return false;
    }

    @Override
    protected void aggregateNext() {
        this.putToAggregator((TapeElementInput)this.mAggregatorMainIterator.current());
    }

    @Override
    protected void aggregateSegment() {
        super.aggregateSegment();
        this.mStrategyProcessed = true;
        this.initIterator();
    }

    @Override
    public void reset0() {
        super.reset0();
        this.mActiveSegment = false;
        this.mActiveStrategy = false;
        this.mStrategyProcessed = false;
        this.mAggregationStrategyIndex = 0;
        this.mAggregatorMainIterator.reset();
    }

    private boolean checkSegment() {
        if (this.mActiveSegment) {
            return true;
        }
        if (this.nextSegment()) {
            this.mActiveSegment = true;
            return true;
        }
        return false;
    }

    private boolean checkStrategy() {
        if (this.mActiveStrategy) {
            return true;
        }
        if (this.nextStrategy()) {
            this.mAggregatorMainIterator.resetSegment();
            return true;
        }
        this.mActiveSegment = false;
        this.mAggregationStrategyIndex = 0;
        return this.checkSegment() && this.nextStrategy() || this.finish();
    }

    private boolean nextSegment() {
        if (this.mAggregatorMainIterator.nextSegment()) {
            this.mActiveSegment = true;
            return true;
        }
        return false;
    }

    private boolean nextStrategy() {
        if (this.mAggregationStrategyIndex >= this.getStrategiesCount()) {
            return false;
        }
        this.setAggregationStrategy(this.mAggregationStrategyIndex);
        this.mActiveStrategy = true;
        ++this.mAggregationStrategyIndex;
        return true;
    }

    private boolean check() {
        return this.checkSegment() && this.checkStrategy() && super.checkNext();
    }

    private int getStrategiesCount() {
        return ((AggregationPolicy)this.mPolicyObjectSupplier.get()).aggregationStrategiesCount();
    }

    private boolean finish() {
        this.mIterationDone = true;
        this.mActiveSegment = false;
        this.mActiveStrategy = false;
        return false;
    }
}

