/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator.secondary;

import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.ConventionalAggregator;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.aggregator.AggregationPolicy;
import com.complexible.memory.structure.impl.aggregator.AggregationStrategy;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.SecondaryKeyDelimiter;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

abstract class BaseSKResultTapeIterator
extends BaseConventionalTapeIterator<HashTableTapeElementInput> {
    protected boolean mIterationDone;
    protected final ConventionalAggregator mAggregator;
    protected final MemoryContext mMemoryContext;
    private AggregationPolicy mAggregationPolicy;
    protected HashTableTapeElementInput mNextElement;
    protected AggregationStrategy mAggregationStrategy;
    protected ConventionalHashTableTapeIterator mSKTapeIterator;
    protected final ConventionalSegmentedTapeIterator mAggregatorMainIterator;
    private final HashTableTapeElementInputFactory mTapeElementInputFactory;
    protected final ObjectSupplier<AggregationPolicy> mPolicyObjectSupplier;

    protected BaseSKResultTapeIterator(MemoryContext theMemoryContext, ConventionalAggregator theAggregator, ConventionalSegmentedTapeIterator theAggregatorMainIterator, ObjectSupplier<AggregationPolicy> thePolicyObjectSupplier, HashTableTapeElementInputFactory theTapeElementInputFactory) {
        this.mAggregator = theAggregator;
        this.mMemoryContext = theMemoryContext;
        this.mPolicyObjectSupplier = thePolicyObjectSupplier;
        this.mAggregatorMainIterator = theAggregatorMainIterator;
        this.mTapeElementInputFactory = theTapeElementInputFactory;
    }

    @Override
    public boolean hasNext0() {
        return !this.mIterationDone && this.checkNext();
    }

    @Override
    public HashTableTapeElementInput next0() {
        return (HashTableTapeElementInput)this.mTapeElementInput;
    }

    @Override
    public void reset0() {
        this.resetFields();
        this.mTapeElementInputFactory.reset();
        this.mAggregationPolicy = this.mPolicyObjectSupplier.get();
        this.setAggregationStrategy(0);
    }

    @Override
    protected void close0() {
        if (this.mSKTapeIterator != null) {
            this.mSKTapeIterator.close();
        }
        this.mAggregatorMainIterator.close();
        this.reset0();
    }

    @Override
    public void dispose0() {
        this.resetFields();
        this.mSKTapeIterator = null;
        this.mNextElement = null;
        this.mAggregationPolicy = null;
        this.mTapeElementInputFactory.dispose();
    }

    protected boolean checkNext() {
        boolean aComparatorCondition;
        boolean bl = aComparatorCondition = this.mAggregationStrategy.getComparator() != null;
        if (aComparatorCondition) {
            return this.mAggregationStrategy.isInputAggregated() ? this.nextAggregatedInput() : this.nextSimpleInput();
        }
        return this.nextPKInput();
    }

    protected abstract boolean nextPKInput();

    private boolean nextSimpleInput() {
        if (this.checkIterator()) {
            return true;
        }
        if (this.checkAggregated()) {
            return false;
        }
        this.aggregateSegment();
        if (this.checkIterator()) {
            return true;
        }
        this.resetFields();
        this.resetAggregator();
        return false;
    }

    protected void resetFields() {
        this.mIterationDone = false;
        this.mTapeElementInput = null;
        this.mAggregationStrategy = null;
    }

    protected void aggregateSegment() {
        while (!this.isSegmentAggregated()) {
            this.aggregateNext();
        }
    }

    protected void initIterator() {
        this.mSKTapeIterator = this.mAggregator.getTapeIterator();
    }

    private void resetAggregator() {
        this.mAggregator.reset();
    }

    protected void setAggregationStrategy(int theIndex) {
        this.mAggregationStrategy = this.mAggregationPolicy.get(theIndex);
        this.mAggregator.setComparator(this.mAggregationStrategy.getComparator());
        this.mAggregator.setFunctor(this.mAggregationStrategy.getFunctor(), this.mAggregationStrategy.getValuePosition());
        this.mAggregator.aggregateUniqueKeys(this.mAggregationStrategy.isKeyUnique());
    }

    protected void putToAggregator(TapeElementInput theTapeElementInput) {
        try {
            this.mAggregator.put(theTapeElementInput);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    protected boolean checkIterator() {
        if (this.mSKTapeIterator != null) {
            if (this.mSKTapeIterator.hasNext()) {
                this.mTapeElementInput = this.mSKTapeIterator.next();
                return true;
            }
            this.resetAggregator();
            this.mSKTapeIterator = null;
            this.mTapeElementInput = SecondaryKeyDelimiter.INSTANCE;
            return true;
        }
        return false;
    }

    protected boolean processAggregatedInput() {
        while (this.nextSegmentElement()) {
            if (this.mTapeElementInput == null || ((HashTableTapeElementInput)this.mTapeElementInput).getElementLength() == 0L) {
                this.mTapeElementInput = this.mNextElement.cloneInput(this.mTapeElementInputFactory);
                return true;
            }
            if (this.mAggregationStrategy.getComparator().equal(this.mTapeElementInput, this.mNextElement)) continue;
            this.mTapeElementInput = this.mNextElement.cloneInput(this.mTapeElementInputFactory);
            return true;
        }
        this.mTapeElementInput = SecondaryKeyDelimiter.INSTANCE;
        return false;
    }

    protected abstract void aggregateNext();

    protected abstract boolean checkAggregated();

    protected abstract boolean nextSegmentElement();

    protected abstract boolean nextAggregatedInput();

    protected abstract boolean isSegmentAggregated();
}

