/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator.memory;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.aggregator.iterator.BaseAggregatorSegmentedTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.PartitionsIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.PartitionsIteratorImpl;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingIterator;
import com.complexible.memory.util.Utilities;
import java.util.function.Supplier;

public abstract class BaseAggregatorMemoryTapeIterator
extends BaseAggregatorSegmentedTapeIterator {
    protected boolean mIsHeader;
    protected boolean isKeyUnique;
    protected long mElementAddress;
    protected final PartitionsArea mPartitionsArea;
    protected MemoryBlock mPartitionMemoryBlock;
    protected final MemoryContext mMemoryContext;
    private final PartitionsIterator mPartitionsIterator;
    protected OpenAddressingIterator mOpenAddressingIterator;
    protected final HashTableTapeElementInputFactory mTapeElementInputFactory;
    protected final Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder;
    protected final ConventionalOpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public BaseAggregatorMemoryTapeIterator(ConventionalOpenAddressingTable<MemoryBlock> theOpenAddressingTable, PartitionsArea theAddressPartitions, MemoryBlockAddressArea theOverFlowPartitionsArea, Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, ConventionalHashTableContext theHashTableContext, MemoryContext theMemoryContext) {
        this.mMemoryContext = theMemoryContext;
        this.mPartitionsArea = theAddressPartitions;
        this.mOpenAddressingTable = theOpenAddressingTable;
        this.theDataMemoryBlockChainHolder = theDataMemoryBlockChainHolder;
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mPartitionsIterator = new PartitionsIteratorImpl(theAddressPartitions, theOverFlowPartitionsArea, theOpenAddressingTable, theHashTableContext);
    }

    @Override
    public boolean hasNext0() {
        if (this.mElementAddress == -1L) {
            return false;
        }
        int theDataBlockOffset = Utilities.maskLongPowerOfTwoAsInt(this.mElementAddress, this.mMemoryContext.getBlockSizeMask());
        int theDataBlockIndex = Utilities.divideLongPowerOfTwoAsInt(this.mElementAddress, this.mMemoryContext.getBlockSizeBitPosition());
        this.mTapeElementInput = this.createElement(theDataBlockOffset, theDataBlockIndex, this.mIsHeader);
        return true;
    }

    protected abstract HashTableTapeElementInput createElement(int var1, int var2, boolean var3);

    @Override
    public boolean nextSegment0() {
        return this.checkOpenAddressingIterator() || this.checkPartition();
    }

    @Override
    public HashTableTapeElementInput next0() {
        return (HashTableTapeElementInput)this.mTapeElementInput;
    }

    @Override
    public void reset0() {
        this.mTapeElementInput = null;
        this.mPartitionsIterator.reset();
        this.mPartitionMemoryBlock = null;
        this.mOpenAddressingIterator = null;
        this.mRecordsCount = 0L;
        this.mHashCode = Utilities.DUMMY_INDEX;
        this.mPartitionHashCode = Utilities.DUMMY_INDEX;
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        super.dispose0();
        this.mPartitionsIterator.dispose();
        this.mOpenAddressingTable.setMemoryAccessor(null);
        this.mTapeElementInputFactory.dispose();
    }

    private boolean checkPartition() {
        if (!this.mPartitionsIterator.hasNext()) {
            this.reset0();
            return false;
        }
        this.mPartitionMemoryBlock = this.mPartitionsIterator.partitionMemoryBlock();
        this.mOpenAddressingTable.setMemoryAccessor(this.mPartitionMemoryBlock);
        this.mOpenAddressingIterator = this.mOpenAddressingTable.iterator();
        return this.checkOpenAddressingIterator();
    }

    protected boolean checkOpenAddressingIterator() {
        if (this.mPartitionMemoryBlock == null || this.mOpenAddressingIterator == null) {
            return false;
        }
        while (this.mOpenAddressingIterator.hasNext()) {
            long aSegmentCellAddress = this.mOpenAddressingIterator.slotAddress();
            long aSegmentAddress = this.mPartitionMemoryBlock.getLong(aSegmentCellAddress);
            if (aSegmentAddress < 0L) continue;
            this.mIsHeader = true;
            this.mElementAddress = aSegmentAddress;
            if (!this.isKeyUnique) {
                this.mTapeElementInputFactory.setUniquenessMode(false);
                this.mTapeElementInputFactory.setElementHeader(true);
                this.mRecordsCount = ((HashTableTapeElementInput)this.mTapeElementInputFactory.createMemoryInput(this.mMemoryContext, this.theDataMemoryBlockChainHolder.get(), aSegmentAddress)).getSegmentElementsCount();
            } else {
                this.mRecordsCount = 1L;
            }
            this.mHashCode = this.mPartitionMemoryBlock.getInt(aSegmentCellAddress + 8L);
            this.mPartitionHashCode = this.mPartitionMemoryBlock.getInt(aSegmentCellAddress + 12L);
            HashTableUtil.markPartitionSlot(this.mPartitionMemoryBlock, aSegmentCellAddress, aSegmentAddress);
            this.mOpenAddressingTable.decrementSlotCount();
            return true;
        }
        return false;
    }
}

