/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.aggregator.iterator.BaseAggregatorSegmentedTapeIterator;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class AggregatorByteReaderTapeIterator
extends BaseAggregatorSegmentedTapeIterator {
    private boolean mElementFetched;
    private final MutableBoolean mBlobFetchingMarker;
    private HashTableTapeElementInput mSourceTapeElementInput;
    private final HashTableTapeElementInputFactory mTapeElementInputFactory;

    public AggregatorByteReaderTapeIterator(MemoryContext theMemoryContext, MutableBoolean theBlobFetchingMarker) {
        this.mBlobFetchingMarker = theBlobFetchingMarker;
        this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public long recordsCount() {
        return 1L;
    }

    @Override
    public boolean nextSegment0() {
        if (this.mBlobFetchingMarker.booleanValue()) {
            return false;
        }
        this.mBlobFetchingMarker.setValue(true);
        return true;
    }

    @Override
    public boolean hasNext0() {
        if (this.mElementFetched) {
            return false;
        }
        this.mElementFetched = true;
        return true;
    }

    @Override
    public HashTableTapeElementInput next0() {
        return this.mSourceTapeElementInput;
    }

    @Override
    public void reset0() {
        this.mElementFetched = false;
        this.resetInput();
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        this.mSourceTapeElementInput = null;
        this.mTapeElementInputFactory.dispose();
    }

    private void resetInput() {
        try {
            if (this.mSourceTapeElementInput != null) {
                this.mSourceTapeElementInput.setPosition(0L);
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    public void setByteReader(ByteReader theByteReader, int theCachedHashCode, int thePartitionCachedHashCode) {
        this.mPartitionHashCode = thePartitionCachedHashCode;
        this.mHashCode = theCachedHashCode;
        this.mSourceTapeElementInput = (HashTableTapeElementInput)this.mTapeElementInputFactory.createByteReaderInput(theByteReader);
    }
}

