/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.impl.aggregator.iterator.BaseAggregatorSegmentedTapeIterator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class AggregatorByteReaderAssemblingTapeIterator
extends BaseAggregatorSegmentedTapeIterator {
    private int mCachedHashCode;
    private boolean mRecordMatching;
    private final MutableBoolean mBlobFetchingMarker;
    private HashTableTapeElementInput mSourceTapeElementInput;
    private final ConventionalHashTableContext mHashTableContext;
    private final Supplier<Comparator> mDefaultComparatorHolder;
    private final HashTableTapeElementInputFactory mLeftTapeElementInputFactory;
    private final HashTableTapeElementInputFactory mRightTapeElementInputFactory;

    public AggregatorByteReaderAssemblingTapeIterator(Supplier<Comparator> theComparatorHolder, ConventionalHashTableContext theHashTableContext, MemoryContext theMemoryContext, MutableBoolean theBlobFetchingMarker) {
        this.mHashTableContext = theHashTableContext;
        this.mBlobFetchingMarker = theBlobFetchingMarker;
        this.mDefaultComparatorHolder = theComparatorHolder;
        this.mLeftTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mRightTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
    }

    @Override
    public int partitionHashCode() {
        return this.mHashTableContext.getCachedPartitionHashCode();
    }

    @Override
    public int currentHashCode() {
        return this.mHashTableContext.getCachedHashCode();
    }

    @Override
    public long recordsCount() {
        return this.mRecordMatching ? 1L : 0L;
    }

    @Override
    public boolean nextSegment0() {
        this.setInitialState();
        if (this.mBlobFetchingMarker.booleanValue()) {
            return false;
        }
        this.compare();
        this.mBlobFetchingMarker.setValue(this.mRecordMatching);
        return this.mRecordMatching;
    }

    @Override
    public boolean hasNext0() {
        if (this.mRecordMatching) {
            this.mRecordMatching = false;
            return true;
        }
        return false;
    }

    @Override
    public HashTableTapeElementInput next0() {
        return this.mSourceTapeElementInput;
    }

    @Override
    public void reset0() {
        this.mRecordMatching = false;
        this.resetInput();
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    public void dispose0() {
        this.mRecordMatching = false;
        this.mSourceTapeElementInput = null;
        this.mLeftTapeElementInputFactory.dispose();
        this.mRightTapeElementInputFactory.dispose();
    }

    private void compare() {
        if (this.mHashTableContext.getCachedHashCode() == this.mCachedHashCode) {
            this.resetInput();
            this.mRecordMatching = this.mDefaultComparatorHolder.get().equal(this.mSourceTapeElementInput, (TapeElementInput)this.mRightTapeElementInputFactory.createByteReaderInput(this.mHashTableContext.getKeyReader()));
        }
    }

    private void resetInput() {
        try {
            if (this.mSourceTapeElementInput != null) {
                this.mSourceTapeElementInput.setPosition(0L);
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    public void setByteReader(ByteReader theByteReader, int theCachedHashCode) {
        this.mRecordMatching = false;
        this.mCachedHashCode = theCachedHashCode;
        this.mSourceTapeElementInput = (HashTableTapeElementInput)this.mLeftTapeElementInputFactory.createByteReaderInput(theByteReader);
    }
}

