/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.collector;

import com.complexible.memory.file.FileWriter;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.aggregator.collector.BaseDiskOutputCollector;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableLong;

public class SpillingDiskOutputCollector
extends BaseDiskOutputCollector {
    static final int SEGMENT_SIZE = 16;

    public SpillingDiskOutputCollector(FileWriter theDiskDataBlocksWriter, MutableLong theSpilledBytesCount, OperationTracker theOperationTracker) {
        super(theDiskDataBlocksWriter, theSpilledBytesCount, theOperationTracker);
    }

    @Override
    public void collectSegment(int theHashCode, int thePartitionHashCode, long theRecordsCount) {
        this.writeSegmentHeader(theHashCode, thePartitionHashCode, theRecordsCount);
    }

    void writeSegmentHeader(int theHashCode, int thePartitionHashCode, long theRecordsCount) {
        try {
            this.mDiskDataBlocksWriter.writeInt(theHashCode);
            this.mDiskDataBlocksWriter.writeInt(thePartitionHashCode);
            this.mDiskDataBlocksWriter.writeLong(theRecordsCount);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mSpilledBytesCount.add(16L);
        this.mOperationTracker.onSpilling(16L);
    }
}

