/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.assembler;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.aggregator.assembler.BaseConventionalAggregatorAssembler;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public abstract class BaseDoubleIteratorAggregatorAssembler
extends BaseConventionalAggregatorAssembler {
    private final PartitionsArea mPartitionsArea;
    protected final ConventionalHashTableContext mHashTableContext;
    final ConventionalSegmentedTapeIterator mDependentIterator;

    public BaseDoubleIteratorAggregatorAssembler(ConventionalHashTableContext theHashTableContext, PartitionsArea thePartitions, MemoryContext theMemoryContext, ConventionalSegmentedTapeIterator theDependentIterator, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier) {
        super(theMemoryContext, theMemoryBlockChainObjectSupplier);
        this.mPartitionsArea = thePartitions;
        this.mDependentIterator = theDependentIterator;
        this.mHashTableContext = theHashTableContext;
    }

    @Override
    protected void calculate() {
        boolean aHasMoreElements = this.mDependentIterator.hasNext();
        try {
            if (this.calculateMainIterator(!aHasMoreElements)) {
                return;
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        if (!aHasMoreElements) {
            this.mOutputCollector.collect((HashTableTapeElementInput)this.mMainAggregationIterator.current());
            return;
        }
        this.calculateElementIterator();
    }

    @Override
    protected void emitSegment(TapeElementInput aMainTapeElementInput) {
        this.initContext(aMainTapeElementInput);
        this.mDependentIterator.nextSegment();
        super.emitSegment(aMainTapeElementInput);
    }

    @Override
    protected long iteratorElementCount() {
        return super.iteratorElementCount() + this.mDependentIterator.recordsCount();
    }

    @Override
    protected boolean hasNextIterator() {
        this.mPendingTapeIterator = this.mDependentIterator;
        return true;
    }

    @Override
    protected HashTableTapeElementInput nextMainIterator() {
        this.mDependentIterator.reset();
        return super.nextMainIterator();
    }

    @Override
    public void aggregateUniqueKeys(boolean theKeysUniqueness) {
        super.aggregateUniqueKeys0(theKeysUniqueness);
        this.mDependentIterator.setUniquenessMode(theKeysUniqueness);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mDependentIterator.dispose();
    }

    private void calculateElementIterator() {
        long aContainerAddress = ((HashTableTapeElementInput)this.mDependentIterator.next()).address();
        try {
            this.mMemoryContainer.setPosition(aContainerAddress);
            this.mTargetElementWrapper.mLength = this.mMemoryContainer.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.accept((ByteReader)this.mMainAggregationIterator.current(), 0L, (ByteReader)this.mDependentIterator.current(), 0L, this.mTargetElementWrapper, aContainerAddress + 8L);
        while (this.mDependentIterator.hasNext()) {
            try {
                this.mMemoryContainer.setPosition(aContainerAddress);
                this.mCurrentElementWrapper.mLength = this.mTargetElementWrapper.mLength = this.mMemoryContainer.readLong();
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
            this.accept(this.mCurrentElementWrapper, aContainerAddress + 8L, (ByteReader)this.mDependentIterator.next(), 0L, this.mTargetElementWrapper, aContainerAddress + 8L);
        }
        this.collect(aContainerAddress, true);
    }

    private void initContext(TapeElementInput aTapeElementInput) {
        int aPartitionHashCode = this.mMainAggregationIterator.partitionHashCode();
        this.mHashTableContext.setKeyReader(aTapeElementInput);
        this.mHashTableContext.setPartitionHashCode(aPartitionHashCode);
        this.mHashTableContext.setCachedHashCode(this.mMainAggregationIterator.currentHashCode());
        if (this.mPartitionsArea.getPartitionsCount() > 0) {
            int aPartitionId = HashTableUtil.calculateIntPartition(aPartitionHashCode, this.mPartitionsArea.getPartitionsCount());
            this.mHashTableContext.setPartitionId(aPartitionId);
            this.mHashTableContext.setPartition(this.mPartitionsArea.getPartition(aPartitionId));
        } else {
            this.mHashTableContext.setPartition(null);
            this.mHashTableContext.setPartitionId(0);
        }
    }
}

