/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.assembler;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.aggregator.AggregationPolicy;
import com.complexible.memory.structure.impl.aggregator.accessor.ElementWrapper;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.aggregator.functor.Functor;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

abstract class BaseConventionalAggregatorAssembler
implements AggregatorAssembler {
    static final int ZERO_OFFSET = 0;
    private boolean mDone;
    Functor mFunctor;
    long mValuePosition;
    protected boolean mKeysUniqueness;
    protected final MemoryContext mMemoryContext;
    private final ElementWrapper mNextElementWrapper;
    AggregatorOutputCollector mOutputCollector;
    final ElementWrapper mTargetElementWrapper;
    final ElementWrapper mCurrentElementWrapper;
    final MemoryBlockChainByteReaderWriter mMemoryContainer;
    ConventionalHashTableTapeIterator mPendingTapeIterator;
    ConventionalSegmentedTapeIterator mMainAggregationIterator;
    private final Supplier<MemoryBlockChain> mMemoryBlockChainObjectSupplier;
    protected final HashTableTapeElementInputFactory mHashTableTapeElementInputFactory;

    BaseConventionalAggregatorAssembler(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier) {
        this.mMemoryContext = theMemoryContext;
        this.mMemoryBlockChainObjectSupplier = theMemoryBlockChainObjectSupplier;
        this.mHashTableTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(theMemoryContext);
        this.mMemoryContainer = new MemoryBlockChainByteReaderWriterImpl(theMemoryBlockChainObjectSupplier, theMemoryContext);
        this.mCurrentElementWrapper = new ElementWrapper(this.mMemoryContainer);
        this.mNextElementWrapper = new ElementWrapper(this.mMemoryContainer);
        this.mTargetElementWrapper = new ElementWrapper(this.mMemoryContainer);
    }

    @Override
    public boolean assemble() {
        return this.mDone || this.checkElement() && this.checkSegment() && this.finish();
    }

    private boolean checkElement() {
        if (this.mPendingTapeIterator == null) {
            return true;
        }
        if (this.mPendingTapeIterator.hasNext()) {
            this.mOutputCollector.collect((HashTableTapeElementInput)this.mPendingTapeIterator.next());
            return false;
        }
        if (this.mPendingTapeIterator == this.mMainAggregationIterator && this.hasNextIterator()) {
            return this.checkElement();
        }
        this.mPendingTapeIterator = null;
        return true;
    }

    protected abstract boolean hasNextIterator();

    protected boolean finish() {
        this.mDone = true;
        return true;
    }

    @Override
    public void setFunctor(Functor theFunctor, long theValuePosition) {
        this.mFunctor = theFunctor;
        this.mValuePosition = theValuePosition;
        this.mHashTableTapeElementInputFactory.setUniquenessMode(theFunctor != null && theFunctor.isAssociative());
    }

    @Override
    public void resetTo(ConventionalSegmentedTapeIterator theMainAggInput, AggregatorOutputCollector theOutputCollector) {
        this.mDone = false;
        this.mPendingTapeIterator = null;
        this.mOutputCollector = theOutputCollector;
        this.mMainAggregationIterator = theMainAggInput;
        this.mMainAggregationIterator.reset();
        this.mHashTableTapeElementInputFactory.reset();
    }

    @Override
    public void setAggregationPolicy(AggregationPolicy theAggregationPolicy) {
        this.setFunctor(theAggregationPolicy.get(0).getFunctor(), theAggregationPolicy.get(0).getValuePosition());
    }

    @Override
    public void aggregateUniqueKeys(boolean theKeysUniqueness) {
        this.aggregateUniqueKeys0(theKeysUniqueness);
    }

    void aggregateUniqueKeys0(boolean theKeysUniqueness) {
        this.mKeysUniqueness = theKeysUniqueness;
        this.mHashTableTapeElementInputFactory.setUniquenessMode(theKeysUniqueness);
    }

    public void dispose() {
        this.mFunctor = null;
        this.mOutputCollector = null;
        this.mPendingTapeIterator = null;
        this.mMainAggregationIterator = null;
        this.mHashTableTapeElementInputFactory.dispose();
    }

    protected void accept(ByteReader theOld, long theOldAddress, ByteReader theNew, long theNewAddress, ByteWriter theContainer, long theContainerAddress) {
        try {
            this.mFunctor.accept(theOld, theOldAddress + this.mValuePosition, theNew, theNewAddress + this.mValuePosition, theContainer, theContainerAddress + this.mValuePosition);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    private boolean checkSegment() {
        if (this.mMainAggregationIterator.nextSegment()) {
            HashTableTapeElementInput aMainTapeElementInput = this.nextMainIterator();
            if (this.mFunctor != null) {
                this.handleFunctor(aMainTapeElementInput);
                return false;
            }
            this.emitSegment(aMainTapeElementInput);
            this.mPendingTapeIterator = !this.mKeysUniqueness ? this.mMainAggregationIterator : null;
            aMainTapeElementInput.reset();
            this.mOutputCollector.collect(aMainTapeElementInput);
            return false;
        }
        this.mPendingTapeIterator = null;
        return true;
    }

    protected void emitSegment(TapeElementInput aMainTapeElementInput) {
        aMainTapeElementInput.reset();
        this.collectSegmentElement();
    }

    protected long iteratorElementCount() {
        return this.mMainAggregationIterator.recordsCount();
    }

    protected void calculate() {
        try {
            if (this.calculateMainIterator(true)) {
                return;
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mOutputCollector.collect((HashTableTapeElementInput)this.mMainAggregationIterator.current());
    }

    protected HashTableTapeElementInput nextMainIterator() {
        return (HashTableTapeElementInput)this.mMainAggregationIterator.next();
    }

    private void collectSegmentElement() {
        this.mOutputCollector.collectSegment(this.mMainAggregationIterator.currentHashCode(), this.mMainAggregationIterator.partitionHashCode(), this.segmentElementCount());
    }

    private long segmentElementCount() {
        return this.mKeysUniqueness || this.mFunctor != null ? 1L : this.iteratorElementCount();
    }

    private void handleFunctor(TapeElementInput theMainTapeElementInput) {
        this.mPendingTapeIterator = null;
        this.emitSegment(theMainTapeElementInput);
        this.calculate();
    }

    boolean calculateMainIterator(boolean theCollectResult) throws IOException {
        long aContainerAddress = ((HashTableTapeElementInput)this.mMainAggregationIterator.current()).address();
        if (this.mMainAggregationIterator.hasNext()) {
            do {
                long aNextAddress = ((HashTableTapeElementInput)this.mMainAggregationIterator.next()).address();
                this.mMemoryContainer.setPosition(aContainerAddress);
                this.mCurrentElementWrapper.mLength = this.mMemoryContainer.readLong();
                this.mMemoryContainer.setPosition(aNextAddress);
                this.mNextElementWrapper.mLength = this.mMemoryContainer.readLong();
                this.mMemoryContainer.setPosition(aContainerAddress);
                this.mTargetElementWrapper.mLength = this.mMemoryContainer.readLong();
                this.accept(this.mCurrentElementWrapper, aContainerAddress + 8L, this.mNextElementWrapper, aNextAddress + 8L, this.mTargetElementWrapper, aContainerAddress + 8L);
            } while (this.mMainAggregationIterator.hasNext());
            if (theCollectResult) {
                this.collect(aContainerAddress, true);
                return true;
            }
        }
        return false;
    }

    protected void collect(long theContainerAddress, boolean theIsHeader) {
        this.mHashTableTapeElementInputFactory.setUniquenessMode(this.mKeysUniqueness);
        this.mHashTableTapeElementInputFactory.setElementHeader(theIsHeader);
        this.mOutputCollector.collect((HashTableTapeElementInput)this.mHashTableTapeElementInputFactory.createMemoryInput(this.mMemoryBlockChainObjectSupplier.get(), Utilities.maskLongPowerOfTwoAsInt(theContainerAddress, this.mMemoryContext.getBlockSizeMask()), Utilities.divideLongPowerOfTwoAsInt(theContainerAddress, this.mMemoryContext.getBlockSizeBitPosition())));
    }
}

