/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Aggregator;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.ConventionalAggregator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.impl.aggregator.accessor.ElementWrapper;
import com.complexible.memory.structure.impl.aggregator.accessor.MemoryBlockChainByteReaderWriterImpl;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.assembler.BlobAggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.assembler.DoubleIteratorAggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.BlobFunctorSpillingDiskOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.SpillingDiskOutputCollector;
import com.complexible.memory.structure.impl.aggregator.functor.Functor;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorByteReaderAssemblingTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorByteReaderTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorDiskTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorMemoryAssemblingTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorResultTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.DefaultAggregatorTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.AggregatorMemoryTapeIterator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableDiskMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.openaddressing.DefaultOpenAddressingTable;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedAddressingHashTape;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;

abstract class BaseConventionalAggregator
extends ConventionalSpillingSupportedAddressingHashTape<Aggregator>
implements ConventionalAggregator {
    Functor mFunctor;
    private long mValuePosition;
    boolean mPrimaryKeysUniqueness;
    private final MutableLong mSpilledBytesCount;
    private final ElementWrapper mElementWrapper;
    private final MemoryBlockChainByteReaderWriter mMemoryByteWriter;
    private final AggregatorByteReaderTapeIterator mMainBlobByteReaderIterator;
    private final MutableBoolean mBlobFetchingMarker = new MutableBoolean();
    private Comparator mPrimaryComparator;
    final AggregatorAssembler mAssembler;
    final AggregatorAssembler mBlobAssembler;
    final ConventionalSegmentedTapeIterator mAggregatorMainIterator;
    private final ConventionalSegmentedTapeIterator mAggregatorMainBlobIterator;
    private final ConventionalHashTableTapeIterator mPKResultAggregatorTapeIterator;
    private final AggregatorOutputCollector mSpillingOutputCollector;
    private final AggregatorOutputCollector mBlobFunctorSpillingOutputCollector;
    private final AggregatorByteReaderAssemblingTapeIterator mBlobAssemblingMemoryIterator;

    BaseConventionalAggregator(int theSpillingBufferSize, MemoryContext theMemoryContext, int thePartitionCount, Comparator mDefaultComparator, CollectionFactory<Aggregator> theCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, thePartitionCount, mDefaultComparator, theCollectionFactory, theOperationTracker);
        try {
            this.mSpilledBytesCount = new MutableLong(0L);
            this.mMainBlobByteReaderIterator = this.createByteReaderIterator(theMemoryContext);
            this.mMemoryByteWriter = this.createMemoryBlockChainAccessor(this.mDataAreaAccessor, theMemoryContext);
            this.mAssembler = this.createDoubleIteratorAssembler(theMemoryContext, this.createMemoryIterator(theMemoryContext));
            this.mBlobAssemblingMemoryIterator = this.createByteReaderAssemblingIterator(theMemoryContext);
            this.mBlobAssembler = this.createBlobAssembler(theMemoryContext);
            AggregatorDiskTapeIterator aAggregatorDiskIterator = this.createDiskAggregatorIterator(new HashTableDiskMultiInputIterator(this.mMemoryBlockChainFactory, this.mDiskDataBlocksReader, theMemoryContext));
            this.mAggregatorMainBlobIterator = this.createMainBlobAggregatorIterator(aAggregatorDiskIterator);
            this.mAggregatorMainIterator = this.createMainAggregatorIterator(aAggregatorDiskIterator, this.createMemoryAggregatorIterator(theMemoryContext));
            this.mPKResultAggregatorTapeIterator = this.createPKResultIterator();
            this.mSpillingOutputCollector = this.createSpillingOutputCollector(theOperationTracker);
            this.mBlobFunctorSpillingOutputCollector = this.createBlobSpillingOutputCollector(theOperationTracker);
            this.mMemoryHashTape.setUniquenessMode(this.mPrimaryKeysUniqueness);
            this.mElementWrapper = new ElementWrapper(this.mMemoryByteWriter);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    protected void spillBlob(ByteReader theDataReader) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.resetByteReader(theDataReader);
            this.mSpilledBytesCount.setValue(0L);
            this.mBlobFetchingMarker.setValue(false);
            this.getBlobAssemblingMemoryIterator().setByteReader(theDataReader, this.mMemoryHashTape.getHashCode());
            this.mMainBlobByteReaderIterator.setByteReader(theDataReader, this.mMemoryHashTape.getHashCode(), this.mMemoryHashTape.getPartitionHashCode());
            this.mBlobAssembler.resetTo(this.mAggregatorMainBlobIterator, this.resolveFunctor() == null ? this.mSpillingOutputCollector : this.mBlobFunctorSpillingOutputCollector);
            this.assembleAndSpill(this.mBlobAssembler);
            this.mDataMemoryBlockChain.setTotalSpilledBytes(this.mSpilledBytesCount.getValue());
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    public void put(ByteReader theReader) throws IOException {
        if (this.checkFunctor(theReader)) {
            return;
        }
        if (this.checkUniqueness(theReader)) {
            return;
        }
        super.put(theReader);
    }

    @Override
    protected void spillTapeToTheDisk() {
        if (!this.checkMemoryElements()) {
            return;
        }
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.logTapeSpilling();
            this.mSpilledBytesCount.setValue(0L);
            this.executeSpill(this.mSpillingOutputCollector);
            this.mDataMemoryBlockChain.setTotalSpilledBytes(this.mSpilledBytesCount.getValue());
        }
        finally {
            this.mMemoryHashTape.restoreHashTableContext();
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    @Override
    protected boolean isKeyUnique() {
        return this.mPrimaryKeysUniqueness;
    }

    @Override
    public void aggregateUniqueKeys(boolean theKeyUniqueness) {
        this.mPrimaryKeysUniqueness = theKeyUniqueness;
        this.mAssembler.aggregateUniqueKeys(theKeyUniqueness);
        this.mBlobAssembler.aggregateUniqueKeys(theKeyUniqueness);
        this.mAggregatorMainIterator.setUniquenessMode(theKeyUniqueness);
        this.mMemoryHashTape.setUniquenessMode(theKeyUniqueness);
    }

    @Override
    public ConventionalHashTableTapeIterator getTapeIterator() {
        ConventionalHashTableTapeIterator aTapeIterator = this.resolveIterator();
        aTapeIterator.reset();
        return aTapeIterator;
    }

    @Override
    public void createAggregator() {
        this.create();
    }

    @Override
    public void reset() {
        this.mMemoryHashTape.resetPartitions();
        if (this.mDataMemoryBlockChain != null) {
            SpillingUtil.deleteFile(this.mDataMemoryBlockChain.getSpilledFile());
            this.mDataMemoryBlockChain.setSpilledFile(null);
            this.mDataMemoryBlockChain.reset();
        }
        this.getTapeIterator();
    }

    private boolean checkMemoryElements() {
        return this.mDataMemoryBlockChain.getMemoryElementsCount() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeSpill(AggregatorOutputCollector theAggregatorOutputCollector) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.mAssembler.resetTo(this.mAggregatorMainIterator, theAggregatorOutputCollector);
            for (MemoryBlock aAddressPartition : this.mPartitionsArea) {
                this.mMemoryHashTape.resetPartitionPayLoad(aAddressPartition);
            }
            this.assembleAndSpill(this.mAssembler);
            this.mDataMemoryBlockChain.resetMemoryAfterSpill(true);
            for (MemoryBlock aAddressPartition : this.mPartitionsArea) {
                this.mMemoryHashTape.resetPartition(aAddressPartition);
            }
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    private void assembleAndSpill(AggregatorAssembler theAssembler) {
        File aNewSpilledFile = this.ensureFile();
        try {
            this.mDiskDataBlocksWriter.setOutput(aNewSpilledFile);
            this.assembleAndSpill(theAssembler, this.mDiskDataBlocksWriter);
        }
        catch (Exception e) {
            if (aNewSpilledFile.exists()) {
                this.deleteFile(aNewSpilledFile);
            }
            Throwables.throwIfInstanceOf((Throwable)e, RuntimeException.class);
            throw Utilities.rethrow(e);
        }
        this.mDataMemoryBlockChain.setSpilledFile(aNewSpilledFile);
    }

    private void assembleAndSpill(AggregatorAssembler theAssembler, FileWriter<?> theDiskDataBlocksWriter) {
        try {
            this.openDiskReader();
            theAssembler.assembleAll();
        }
        catch (Throwable throwable) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{theDiskDataBlocksWriter, this.mDiskDataBlocksReader, () -> this.deleteFile(this.mDataMemoryBlockChain.getSpilledFile())});
            throw throwable;
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{theDiskDataBlocksWriter, this.mDiskDataBlocksReader, () -> this.deleteFile(this.mDataMemoryBlockChain.getSpilledFile())});
    }

    @Override
    public void setFunctor(Functor theFunctor, long theValuePosition) {
        this.mFunctor = theFunctor;
        this.mValuePosition = theValuePosition;
        this.setAssemblersFunctor(theFunctor, theValuePosition);
    }

    private long resolveValuePosition() {
        return this.mValuePosition;
    }

    private void putUniqueAndCalculate(ByteReader theReader) throws IOException {
        if (this.ensureUnique(theReader)) {
            return;
        }
        OpenAddressingTable mOpenAddressingTable = this.mMemoryHashTape.getOpenAddressingTable();
        int aHashCodeCellAddress = (int)mOpenAddressingTable.payload();
        assert (aHashCodeCellAddress < -1) : "must point to the existing slot in the OA";
        mOpenAddressingTable.setPayLoad(-1L);
        long aSegmentAddress = ConventionalOpenAddressingTable.getSegmentCellAddress(-aHashCodeCellAddress);
        long aElementRootAddress = ((MemoryBlock)mOpenAddressingTable.getMemoryAccessor()).getLong(aSegmentAddress);
        long aElementAddress = aElementRootAddress + 8L;
        this.mMemoryByteWriter.setPosition(aElementRootAddress);
        this.mElementWrapper.mLength = this.mMemoryByteWriter.readLong();
        this.resetByteReader(theReader);
        long aValuePosition = this.resolveValuePosition();
        this.resolveFunctor().accept(this.mElementWrapper, aElementAddress + aValuePosition, theReader, aValuePosition);
    }

    protected ConventionalHashTableTapeIterator resolveIterator() {
        return this.mPKResultAggregatorTapeIterator;
    }

    private Functor resolveFunctor() {
        return this.mFunctor;
    }

    private AggregatorByteReaderAssemblingTapeIterator getBlobAssemblingMemoryIterator() {
        return this.mBlobAssemblingMemoryIterator;
    }

    @Override
    public void setComparator(Comparator theDefaultComparator) {
        this.mPrimaryComparator = theDefaultComparator;
        super.setComparator(theDefaultComparator);
    }

    @Override
    protected void writeDataAddressToAddressSpace(int theBlockIndex, int theOffset) throws IOException {
        ConventionalOpenAddressingTable mOpenAddressingTable = (ConventionalOpenAddressingTable)this.mMemoryHashTape.getInitiatedOpenAddressingTable();
        if (!this.hasAssociativeFunctor() || mOpenAddressingTable.payload() == -1L) {
            super.writeDataAddressToAddressSpace(theBlockIndex, theOffset);
            return;
        }
        long aElementAddress = Utilities.calculateAddress(theBlockIndex, theOffset, this.blockSizeBitPosition());
        this.checkBytesAvailable(16L);
        long hashCodeCellAddress = mOpenAddressingTable.payload();
        mOpenAddressingTable.assign(hashCodeCellAddress, aElementAddress, this.mMemoryHashTape.getHashCode());
        this.handleOpenAddressingPut(this.mMemoryHashTape.getPartition(), aElementAddress, (int)hashCodeCellAddress);
        mOpenAddressingTable.setPayLoad(-1L);
    }

    @Override
    public void dispose() {
        this.setComparator(this.mPrimaryComparator);
        this.setAssemblersFunctor(this.mFunctor, this.mValuePosition);
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable((Disposable)this.mAssembler), Disposables.asCloseable((Disposable)this.mBlobAssembler), Disposables.asCloseable((Disposable)this.mAggregatorMainIterator), Disposables.asCloseable((Disposable)this.mMainBlobByteReaderIterator), Disposables.asCloseable((Disposable)this.mAggregatorMainBlobIterator), Disposables.asCloseable((Disposable)this.mPKResultAggregatorTapeIterator), Disposables.asCloseable((Disposable)this.mBlobAssemblingMemoryIterator)});
    }

    @Override
    protected Aggregator getCollection() {
        return this;
    }

    private void setAssemblersFunctor(Functor theFunctor, long theValuePosition) {
        this.mAssembler.setFunctor(theFunctor, theValuePosition);
        this.mBlobAssembler.setFunctor(theFunctor, theValuePosition);
    }

    private boolean checkUniqueness(ByteReader theReader) throws IOException {
        if (this.mPrimaryKeysUniqueness) {
            this.mMemoryHashTape.initContext(theReader);
            this.putUnique(theReader);
            return true;
        }
        return false;
    }

    private boolean checkFunctor(ByteReader theReader) throws IOException {
        if (this.hasAssociativeFunctor()) {
            this.mMemoryHashTape.initContext(theReader);
            this.putUniqueAndCalculate(theReader);
            return true;
        }
        return false;
    }

    private boolean hasAssociativeFunctor() {
        Functor aFunctor = this.resolveFunctor();
        return aFunctor != null && aFunctor.isAssociative();
    }

    AggregatorMemoryTapeIterator createMemoryAggregatorIterator(MemoryContext theMemoryContext) {
        return new AggregatorMemoryTapeIterator(this.createOpenAddressingTable(theMemoryContext), this.mPartitionsArea, this.mOverFlowPartitionsArea, this.mDataAreaAccessor, (ConventionalHashTableContext)this.mMemoryHashTape.getHashTableContext(), theMemoryContext);
    }

    private AggregatorDiskTapeIterator createDiskAggregatorIterator(HashTableMultiInputIterator theDiskMultiInputIterator) {
        return new AggregatorDiskTapeIterator(this.mDiskDataBlocksReader, theDiskMultiInputIterator);
    }

    private AggregatorByteReaderTapeIterator createByteReaderIterator(MemoryContext theMemoryContext) {
        return new AggregatorByteReaderTapeIterator(theMemoryContext, this.mBlobFetchingMarker);
    }

    private MemoryBlockChainByteReaderWriterImpl createMemoryBlockChainAccessor(Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, MemoryContext theMemoryContext) {
        return new MemoryBlockChainByteReaderWriterImpl(theDataMemoryBlockChainHolder, theMemoryContext);
    }

    private AggregatorResultTapeIterator createPKResultIterator() {
        return new AggregatorResultTapeIterator(this.mAssembler, this.mDiskDataBlocksReader, this.mAggregatorMainIterator, this.mDataAreaAccessor);
    }

    private AggregatorAssembler createDoubleIteratorAssembler(MemoryContext theMemoryContext, ConventionalSegmentedTapeIterator theDependentIterator) {
        return new DoubleIteratorAggregatorAssembler((ConventionalHashTableContext)this.mMemoryHashTape.getHashTableContext(), this.mPartitionsArea, theMemoryContext, theDependentIterator, this.mDataAreaAccessor);
    }

    private AggregatorAssembler createBlobAssembler(MemoryContext theMemoryContext) {
        return new BlobAggregatorAssembler((ConventionalHashTableContext)this.mMemoryHashTape.getHashTableContext(), this.mPartitionsArea, theMemoryContext, this.mBlobAssemblingMemoryIterator, this.mDataAreaAccessor);
    }

    private BlobFunctorSpillingDiskOutputCollector createBlobSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new BlobFunctorSpillingDiskOutputCollector(this.mDiskDataBlocksWriter, this.mSpilledBytesCount, theOperationTracker);
    }

    private SpillingDiskOutputCollector createSpillingOutputCollector(OperationTracker theOperationTracker) {
        return new SpillingDiskOutputCollector(this.mDiskDataBlocksWriter, this.mSpilledBytesCount, theOperationTracker);
    }

    private DefaultAggregatorTapeIterator createMainBlobAggregatorIterator(ConventionalSegmentedTapeIterator theAggregatorDiskIterator) {
        return new DefaultAggregatorTapeIterator(theAggregatorDiskIterator, this.mMainBlobByteReaderIterator);
    }

    private DefaultAggregatorTapeIterator createMainAggregatorIterator(ConventionalSegmentedTapeIterator theAggregatorDiskIterator, ConventionalSegmentedTapeIterator theAggregatorMemoryIterator) {
        return new DefaultAggregatorTapeIterator(theAggregatorDiskIterator, theAggregatorMemoryIterator);
    }

    private AggregatorByteReaderAssemblingTapeIterator createByteReaderAssemblingIterator(MemoryContext theMemoryContext) {
        return new AggregatorByteReaderAssemblingTapeIterator(this.mMemoryHashTape.getComparatorHolder(), (ConventionalHashTableContext)this.mMemoryHashTape.getHashTableContext(), theMemoryContext, this.mBlobFetchingMarker);
    }

    protected ConventionalSegmentedTapeIterator createMemoryIterator(MemoryContext theMemoryContext) {
        return new AggregatorMemoryAssemblingTapeIterator(this.mPartitionsArea, this.mOverFlowPartitionsArea, this.mMemoryHashTape.getHashComparator(), this.createOpenAddressingTable(theMemoryContext), this.mDataAreaAccessor, (ConventionalHashTableContext)this.mMemoryHashTape.getHashTableContext(), theMemoryContext);
    }

    private ConventionalOpenAddressingTable<MemoryBlock> createOpenAddressingTable(MemoryContext theMemoryContext) {
        return new DefaultOpenAddressingTable(this.mMemoryHashTape.getHashComparator(), theMemoryContext.getBlockSize());
    }
}

