/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Array;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableDiskMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableMultiInputIterator;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedTape;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class AggregatorResultStorage
extends ConventionalSpillingSupportedTape<Array>
implements Array {
    private long mMemoryElementsBytesCount;
    private final ConventionalAddressableTapeIterator<HashTableTapeElementInput> mIterator;
    private final HashTableMultiInputIterator mDiskInputIterator;

    public AggregatorResultStorage(int spillingBufferSize, MemoryContext theMemoryContext, OperationTracker theOperationTracker) {
        super(spillingBufferSize, theMemoryContext, null, theOperationTracker);
        this.mDiskInputIterator = new HashTableDiskMultiInputIterator(this.mMemoryBlockChainFactory, this.mDiskDataBlocksReader, theMemoryContext);
        this.mIterator = new DefaultAddressableTapeIterator();
    }

    @Override
    public void createArray() {
        super.createTape();
    }

    @Override
    protected void writeBytes(ByteReader theReader) throws IOException {
        super.writeBytes(theReader);
        this.mMemoryElementsBytesCount += theReader.length() + 8L;
    }

    @Override
    protected void spillTapeToTheDisk() {
        this.mMemoryElementsBytesCount = 0L;
        super.spillTapeToTheDisk();
    }

    boolean acquireBlocks(int theAcquiredBlocksCount) {
        this.mDataMemoryBlockChain.reset();
        for (int i = 0; i < theAcquiredBlocksCount; ++i) {
            if (this.mDataMemoryBlockChain.obtainNext()) continue;
            this.mDataMemoryBlockChain.dispose();
            return false;
        }
        this.mDataMemoryBlockChain.reset();
        return true;
    }

    void passSpilledFile(MemoryBlockChain theDataMemoryBlockChain) {
        this.mMemoryElementsBytesCount = 0L;
        this.mDataMemoryBlockChain.reset();
        this.mDataMemoryBlockChain.setSpilledFile(theDataMemoryBlockChain.getSpilledFile());
        theDataMemoryBlockChain.setSpilledFile(null);
        this.mDataMemoryBlockChain.setTotalSpilledBytes(theDataMemoryBlockChain.getTotalSpilledBytes());
        this.mDataMemoryBlockChain.setActualBlocksCount(theDataMemoryBlockChain.getActualBlocksCount());
        this.mDataMemoryBlockChain.setTotalElementsCount(theDataMemoryBlockChain.getTotalElementsCount());
    }

    public void releaseUnUsedBlocks() {
        this.mDataMemoryBlockChain.releaseUnusedBlocks();
    }

    @Override
    public ConventionalAddressableTapeIterator<HashTableTapeElementInput> getTapeIterator() {
        this.mIterator.reset();
        return this.mIterator;
    }

    @Override
    protected <TT> void spillBlob(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    protected void spillBlob(ByteReader theDataReader) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Disposables.asCloseable(this.mIterator), Disposables.asCloseable((Disposable)this.mDiskInputIterator), () -> {
            this.mMemoryElementsBytesCount = 0L;
        }});
    }

    @Override
    protected Array getCollection() {
        return this;
    }

    private final class DefaultAddressableTapeIterator
    extends BaseConventionalTapeIterator<HashTableTapeElementInput>
    implements ConventionalAddressableTapeIterator<HashTableTapeElementInput> {
        private boolean mActive;
        private long mCurrentAddress;
        private final HashTableTapeElementInputFactory mTapeElementInputFactory;

        private DefaultAddressableTapeIterator() {
            this.reset();
            this.mTapeElementInputFactory = new DefaultHashTableTapeElementInputFactory(AggregatorResultStorage.this.mMemoryContext, AggregatorResultStorage.this.mMemoryBlockChainFactory);
        }

        @Override
        public boolean hasNext0() {
            if (!this.mActive) {
                this.activate();
            }
            if (this.mCurrentAddress < AggregatorResultStorage.this.mDataMemoryBlockChain.getTotalSpilledBytes()) {
                AggregatorResultStorage.this.mDiskInputIterator.next(0);
                this.mTapeElementInput = AggregatorResultStorage.this.mDiskInputIterator.getInput(0);
                this.setNextAddress();
                return true;
            }
            if (this.mCurrentAddress < AggregatorResultStorage.this.mDataMemoryBlockChain.getTotalSpilledBytes() + AggregatorResultStorage.this.mMemoryElementsBytesCount) {
                long aMemoryAddress = this.mCurrentAddress - AggregatorResultStorage.this.mDataMemoryBlockChain.getTotalSpilledBytes();
                int aSrcBlockOffset = Utilities.maskLongPowerOfTwoAsInt(aMemoryAddress, AggregatorResultStorage.this.blockSizeMask());
                int aSrcBlockIndex = Utilities.divideLongPowerOfTwoAsInt(aMemoryAddress, AggregatorResultStorage.this.blockSizeBitPosition());
                this.mTapeElementInput = this.mTapeElementInputFactory.createMemoryInput(AggregatorResultStorage.this.mDataMemoryBlockChain, aSrcBlockOffset, aSrcBlockIndex);
                this.setNextAddress();
                return true;
            }
            return false;
        }

        @Override
        public HashTableTapeElementInput next0() {
            return (HashTableTapeElementInput)this.mTapeElementInput;
        }

        @Override
        public void reset0() {
            this.mActive = false;
            this.mCurrentAddress = 0L;
            AggregatorResultStorage.this.mDiskInputIterator.reset();
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{AggregatorResultStorage.this.mDiskDataBlocksReader});
        }

        @Override
        public void gotoAddress(long theElementAddress) {
            this.setInitialState();
            if (theElementAddress < AggregatorResultStorage.this.mDataMemoryBlockChain.getTotalSpilledBytes()) {
                try {
                    AggregatorResultStorage.this.mDiskDataBlocksReader.setPosition(theElementAddress);
                }
                catch (IOException theE) {
                    throw Utilities.rethrow(theE);
                }
                AggregatorResultStorage.this.mDiskInputIterator.reset();
            }
            this.mCurrentAddress = theElementAddress;
        }

        @Override
        protected void close0() {
            this.reset0();
        }

        @Override
        public void dispose0() {
            this.reset0();
            this.mTapeElementInputFactory.dispose();
        }

        private void activate() {
            AggregatorResultStorage.this.openDiskReader();
            this.mActive = true;
        }

        private void setNextAddress() {
            this.mCurrentAddress += 8L + ((HashTableTapeElementInput)this.mTapeElementInput).getElementLength();
        }
    }
}

