/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.memoryblock.MemoryType;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public final class MemoryPoolMonitor {
    private final long total;
    private final MemoryType memoryType;
    private final AtomicLong usedMemory = new AtomicLong(0L);

    public MemoryPoolMonitor(long totalSizeInBytes, MemoryType memoryType) {
        this.total = totalSizeInBytes;
        this.memoryType = memoryType;
    }

    public static MemoryPoolMonitor create(long aHeapPoolSize, long aNativePoolSize) {
        if (aHeapPoolSize > aNativePoolSize || !UnsafeUtil.UNSAFE_AVAILABLE) {
            if (aHeapPoolSize == 0L) {
                aHeapPoolSize = aNativePoolSize;
            }
            return new MemoryPoolMonitor(aHeapPoolSize, MemoryType.HEAP);
        }
        return new MemoryPoolMonitor(aNativePoolSize, MemoryType.NATIVE);
    }

    public boolean reserve(int memorySize) {
        long newValue;
        long currentValue;
        Preconditions.checkArgument((memorySize > 0 ? 1 : 0) != 0, (Object)("memorySize: " + memorySize));
        do {
            if ((newValue = (currentValue = this.usedMemory.get()) + (long)memorySize) <= this.total) continue;
            return false;
        } while (!this.usedMemory.compareAndSet(currentValue, newValue));
        return true;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public void release(int memorySize) {
        Preconditions.checkArgument((memorySize > 0 ? 1 : 0) != 0, (Object)("memorySize: " + memorySize));
        this.usedMemory.addAndGet(-memorySize);
    }

    public long getFree() {
        return this.getTotal() - this.getUsed();
    }

    public long getUsed() {
        return this.usedMemory.get();
    }

    public long getTotal() {
        return this.total;
    }
}

