/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.Files2;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.memoryblock.MemoryBlockPool;
import com.complexible.memory.memoryblock.MemoryPoolMonitor;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.File;

public final class MemoryContext
implements Disposable,
AutoCloseable {
    private final int mBlockSize;
    private final int mBlockSizeLog2;
    private final int mBlockSizeMask;
    private final MemoryBlockPool mMemoryBlockPool;
    private final File mSpillingDirectory;
    private final long mMaxSpillingFileLength;
    private final long mSpillingSyncChunkSize;
    private final int mMinBlocksAfterSpill;
    private final boolean mFailOnNoMemoryDuringInit;

    public MemoryContext(MemoryPoolMonitor theMemoryPool, int theBlockSize, boolean theAllocateImmediately) {
        this(theMemoryPool, theBlockSize, theAllocateImmediately, Files2.tmpDir().toFile());
    }

    public MemoryContext(MemoryPoolMonitor theMemoryPool, int theBlockSize, boolean theAllocateImmediately, File theSpillingDir) {
        this(theMemoryPool, theBlockSize, theAllocateImmediately, (int)(262144L / (long)theBlockSize), theSpillingDir);
    }

    public MemoryContext(MemoryPoolMonitor theMemoryPool, int theBlockSize, boolean theAllocateImmediately, int theMinBlocksAfterSpill) {
        this(theMemoryPool, theBlockSize, theAllocateImmediately, Files2.tmpDir().toFile(), 0x40000000L, 0x10000000L, theMinBlocksAfterSpill, false);
    }

    public MemoryContext(MemoryPoolMonitor theMemoryPool, int theBlockSize, boolean theAllocateImmediately, int theMinBlocksAfterSpill, File theSpillingDir) {
        this(theMemoryPool, theBlockSize, theAllocateImmediately, theSpillingDir, 0x40000000L, 0x10000000L, theMinBlocksAfterSpill, false);
    }

    public MemoryContext(MemoryPoolMonitor theMemoryPool, int theBlockSize, boolean theAllocateImmediately, File theSpillingDir, long theMaxSpillingFileLength, long theSpillingSyncChunkSize, int theMinBlocksAfterSpill, boolean failOnOOMDuringInit) {
        Preconditions.checkArgument((boolean)Utilities.isPositivePowerOfTwo(theBlockSize));
        Preconditions.checkArgument(((long)theBlockSize <= 0x40000000L ? 1 : 0) != 0, (Object)"Block's size can't exceeds 1 Gigabyte");
        this.mBlockSize = theBlockSize;
        this.mBlockSizeMask = theBlockSize - 1;
        this.mBlockSizeLog2 = Utilities.log2(theBlockSize);
        this.mMemoryBlockPool = this.createMemoryBlockPool(theMemoryPool, theBlockSize, theAllocateImmediately);
        this.mSpillingSyncChunkSize = theSpillingSyncChunkSize;
        this.mMinBlocksAfterSpill = theMinBlocksAfterSpill;
        this.mSpillingDirectory = theSpillingDir;
        this.mMaxSpillingFileLength = theMaxSpillingFileLength;
        this.mFailOnNoMemoryDuringInit = failOnOOMDuringInit;
        assert (this.mSpillingDirectory != null) : "spillingDirectory shouldn't be null";
        assert (this.mSpillingDirectory.exists() && this.mSpillingDirectory.isDirectory() && this.mSpillingDirectory.canWrite()) : "Invalid spill directory " + this.mSpillingDirectory.getAbsolutePath();
        Disposables.markCreated((Object)this);
    }

    public File getSpillingDirectory() {
        return this.mSpillingDirectory;
    }

    public long getMaxSpillingFileLength() {
        return this.mMaxSpillingFileLength;
    }

    public long getSpillingSyncChunkSize() {
        return this.mSpillingSyncChunkSize;
    }

    public MemoryBlockPool getMemoryBlockPool() {
        return this.mMemoryBlockPool;
    }

    public long getAvailableMemory() {
        return this.mMemoryBlockPool.getAvailableMemory();
    }

    public long getTotal() {
        return this.mMemoryBlockPool.getTotal();
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public boolean isUseBigEndian() {
        return ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN;
    }

    public int getBlockSizeMask() {
        return this.mBlockSizeMask;
    }

    public int getBlockSizeBitPosition() {
        return this.mBlockSizeLog2;
    }

    public boolean failOnNoMemoryDuringInit() {
        return this.mFailOnNoMemoryDuringInit;
    }

    public int allocateLocalBlocks(int theNumberOfBlocks) {
        MemoryBlockPool aCurrentMemoryBlockPool = this.getMemoryBlockPool();
        int aCurrentAllocatedBlockNumber = aCurrentMemoryBlockPool.allocateLocalBlocks(theNumberOfBlocks);
        if (aCurrentAllocatedBlockNumber < theNumberOfBlocks) {
            return aCurrentAllocatedBlockNumber;
        }
        return theNumberOfBlocks;
    }

    public void releaseLocalBlocks() {
        this.mMemoryBlockPool.releaseLocalBlocks();
    }

    public void dispose() {
        Disposables.markReleased((Object)this);
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this::releaseLocalBlocks;
        autoCloseableArray[1] = this.mMemoryBlockPool::dispose;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
        assert (this.mMemoryBlockPool.getUsed() == 0L) : "all block memory should have been returned to the pool";
    }

    @Override
    public void close() {
        this.dispose();
    }

    private MemoryBlockPool createMemoryBlockPool(MemoryPoolMonitor theHeapMemoryPool, int theBlockSize, boolean theAllocateImmediately) {
        return new MemoryBlockPool(theBlockSize, theHeapMemoryPool, theAllocateImmediately);
    }

    public long getThreadLocalBlocks() {
        return this.mMemoryBlockPool.getLocalBlockNumber();
    }

    public int minBlocksAfterSpill() {
        return this.mMinBlocksAfterSpill;
    }
}

