/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.base.Disposable;
import com.complexible.memory.memoryblock.MemoryBlock;
import java.io.File;

public interface MemoryBlockChain
extends Disposable {
    public int size();

    public void clear();

    public void reset();

    public int currentBlockOffset();

    public int currentIndex();

    public boolean isEmpty();

    public boolean gotoNext();

    public boolean acquireNext();

    public boolean obtainNext();

    public boolean checkNext();

    public MemoryBlock remove(int var1);

    public MemoryBlock pop();

    public void chop();

    public MemoryBlock current();

    public MemoryBlock get(int var1);

    public void setCurrentBlock(int var1);

    public void add(MemoryBlock var1);

    public File getSpilledFile();

    public void setSpilledFile(File var1);

    public void releaseUnusedBlocks();

    public int getActualBlocksCount();

    public long getTotalElementsCount();

    public long getMemoryElementsCount();

    public long getTotalSpilledBytes();

    public void setCurrentBlockOffset(int var1);

    public void setActualBlocksCount(int var1);

    public void setMemoryElementsCount(long var1);

    public void incrementTotalSpilledBytes(long var1);

    public void incrementActualBlocksCount();

    public void incrementMemoryElementsCount();

    public void incrementTotalElementsCount();

    public void incrementCurrentBlockIndex();

    public void setTotalElementsCount(long var1);

    public void setTotalSpilledElementsCount(long var1);

    public long getTotalSpilledElementsCount();

    public void setTotalSpilledBytes(long var1);

    public void setPayLoad(long var1);

    public long getPayLoad();

    default public void migrate(MemoryBlockChain theSourceMemoryBlockChain) {
        while (theSourceMemoryBlockChain.size() > 0) {
            this.add(theSourceMemoryBlockChain.remove(0));
        }
        this.reset();
        theSourceMemoryBlockChain.reset();
    }

    public void resetMemoryAfterSpill(boolean var1);

    default public void trimFront(int theBlockCount) {
        throw new UnsupportedOperationException("unsupported");
    }

    public void setMemoryBlock(int var1, MemoryBlock var2);
}

