/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.file.impl;

import com.complexible.memory.file.impl.AbstractFileWriter;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class DefaultFileWriter
extends AbstractFileWriter<FileOutputStream> {
    public DefaultFileWriter(int bufferSize, long maxFileLength, long syncChunkSize) {
        super(bufferSize, maxFileLength, syncChunkSize);
    }

    @Override
    public void setOutput(File theOutput) throws FileNotFoundException {
        this.setOutput(new FileOutputStream(theOutput));
    }

    @Override
    protected long outPutLength(FileOutputStream theOut) {
        try {
            return ((FileOutputStream)this.output).getChannel().size();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    protected void flushOutput() throws IOException {
        ((FileOutputStream)this.output).flush();
    }

    @Override
    protected void writeOutput() throws IOException {
        ((FileOutputStream)this.output).write(this.buffer(), 0, this.position);
    }

    @Override
    protected void closeOutput() throws IOException {
        ((FileOutputStream)this.output).close();
    }

    @Override
    protected void syncOutput() throws IOException {
        ((FileOutputStream)this.output).getFD().sync();
    }

    @Override
    protected void moveToPosition(long thePosition) {
        try {
            ((FileOutputStream)this.output).getChannel().position(thePosition);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void truncate(long theActualSize) {
        try {
            ((FileOutputStream)this.output).getChannel().truncate(theActualSize);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }
}

