/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.file.impl;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.ByteMemoryAccessor;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.ByteArrayMemoryAccessor;
import com.complexible.memory.memoryblock.UnsafeByteArrayMemoryAccessor;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class AbstractFileReader<S>
implements FileReader<S> {
    protected S mInput;
    protected long mFileOffset;
    protected int mReadPosition;
    protected int mReadLimit;
    private final int mBufferSize;
    private ByteMemoryAccessor mBufferMemoryAccessor;

    protected AbstractFileReader(int bufSize) {
        assert (bufSize >= 8);
        this.mBufferSize = bufSize;
    }

    @Override
    public void setInput(File theInput) throws FileNotFoundException {
        assert (this.readyInBuffer() == 0) : "Attempt to set input stream while buffer not empty";
        this.openInput(theInput);
    }

    @Override
    public void setInput(S theInput) throws FileNotFoundException {
        assert (this.readyInBuffer() == 0) : "Attempt to set input stream while buffer not empty";
        this.openInput(theInput);
    }

    @Override
    public boolean checkAvailable(int theBytesToRead) {
        int aFreeInBuffer;
        if (this.mInput == null) {
            return false;
        }
        if (this.mBufferMemoryAccessor == null) {
            byte[] buffer = new byte[this.mBufferSize];
            ByteMemoryAccessor byteMemoryAccessor = this.mBufferMemoryAccessor = UnsafeUtil.UNSAFE_AVAILABLE ? new UnsafeByteArrayMemoryAccessor(buffer) : new ByteArrayMemoryAccessor(buffer);
        }
        assert (theBytesToRead <= this.mBufferSize) : String.format("Requested to make %d bytes available, but buffer size is %d", theBytesToRead, this.mBufferSize);
        if (this.readyInBuffer() >= theBytesToRead) {
            return true;
        }
        this.compact();
        while ((aFreeInBuffer = this.freeInBuffer()) > 0) {
            try {
                int aReadCount = this.read(aFreeInBuffer);
                if (aReadCount < 0) {
                    return this.readyInBuffer() >= theBytesToRead;
                }
                this.mReadLimit += aReadCount;
                this.mFileOffset += (long)aReadCount;
            }
            catch (IOException e) {
                throw new IllegalStateException("Reading from spill file failed", e);
            }
        }
        return true;
    }

    @Override
    public int readBlob(MemoryAccessor theMemoryBlock, int theOffset, int theLength) {
        int transferredCount;
        assert (theMemoryBlock != null) : "readBlob() called with null memory block";
        int readCount = 0;
        int writePosition = theOffset;
        boolean endOfFile = false;
        for (int remainingToTransfer = theLength; remainingToTransfer > 0; remainingToTransfer -= transferredCount) {
            if (!this.checkAvailable(Math.min(remainingToTransfer, this.mBufferSize))) {
                endOfFile = true;
            }
            if ((transferredCount = Math.min(remainingToTransfer, this.readyInBuffer())) == 0) {
                return readCount;
            }
            theMemoryBlock.copyFromByteArray(this.buffer(), this.mReadPosition, writePosition, transferredCount);
            this.mReadPosition += transferredCount;
            writePosition += transferredCount;
            readCount += transferredCount;
            if (!endOfFile) continue;
            return readCount;
        }
        return readCount;
    }

    @Override
    public long readLongBuffer(long[] theData, long theOffset, long theLength) {
        int transferredCount;
        assert (theData != null) : "readLongBuffer() called with null theData block";
        int aReadCount = 0;
        long aWritePosition = theOffset;
        boolean aEndOfFile = false;
        for (long remainingToTransfer = theLength; remainingToTransfer > 0L; remainingToTransfer -= (long)transferredCount) {
            if (!this.checkAvailable((int)Math.min(remainingToTransfer, (long)this.mBufferSize))) {
                aEndOfFile = true;
            }
            if ((transferredCount = (int)Math.min(remainingToTransfer, (long)this.readyInBuffer())) == 0) {
                return aReadCount;
            }
            this.mBufferMemoryAccessor.copyToLongArray(theData, this.mReadPosition, aWritePosition, transferredCount);
            this.mReadPosition += transferredCount;
            aWritePosition += (long)transferredCount;
            aReadCount += transferredCount;
            if (!aEndOfFile) continue;
            return aReadCount;
        }
        return aReadCount;
    }

    public long readBuffer(char[] theBuffer, long theOffset, long theLength) {
        return this.readCharBuffer(theBuffer, theOffset, theLength);
    }

    @Override
    public long readCharBuffer(char[] theData, long theOffset, long theLength) {
        int transferredCount;
        assert (theData != null) : "readLongBuffer() called with null theData block";
        int aReadCount = 0;
        long aWritePosition = theOffset;
        boolean aEndOfFile = false;
        for (long remainingToTransfer = theLength; remainingToTransfer > 0L; remainingToTransfer -= (long)transferredCount) {
            if (!this.checkAvailable((int)Math.min(remainingToTransfer, (long)this.mBufferSize))) {
                aEndOfFile = true;
            }
            if ((transferredCount = (int)Math.min(remainingToTransfer, (long)this.readyInBuffer())) == 0) {
                return aReadCount;
            }
            this.mBufferMemoryAccessor.copyToCharArray(theData, this.mReadPosition, aWritePosition, transferredCount);
            this.mReadPosition += transferredCount;
            aWritePosition += (long)transferredCount;
            aReadCount += transferredCount;
            if (!aEndOfFile) continue;
            return aReadCount;
        }
        return aReadCount;
    }

    @Override
    public long readNextLong() {
        return this.readLong();
    }

    @Override
    public int readNextInt() {
        return this.readInt();
    }

    public int read(byte[] theData, int theOffset, int theLength) throws IOException {
        int transferredCount;
        assert (theData != null) : "read(byte[] theData, int offset, int theLength) called with null array";
        int aReadCount = 0;
        int aWritePosition = theOffset;
        boolean aEndOfFile = false;
        for (int aRemainingToTransfer = theLength; aRemainingToTransfer > 0; aRemainingToTransfer -= transferredCount) {
            if (!this.checkAvailable(Math.min(aRemainingToTransfer, this.mBufferSize))) {
                aEndOfFile = true;
            }
            if ((transferredCount = Math.min(aRemainingToTransfer, this.readyInBuffer())) == 0) {
                return aReadCount;
            }
            System.arraycopy(this.buffer(), this.mReadPosition, theData, aWritePosition, transferredCount);
            this.mReadPosition += transferredCount;
            aWritePosition += transferredCount;
            aReadCount += transferredCount;
            if (!aEndOfFile) continue;
            return aReadCount;
        }
        return aReadCount;
    }

    public int readNative(long theAddress, int theLength) {
        int aTransferredCount;
        int aReadCount = 0;
        int aWritePosition = 0;
        boolean aEndOfFile = false;
        for (int aRemainingToTransfer = theLength; aRemainingToTransfer > 0; aRemainingToTransfer -= aTransferredCount) {
            if (!this.checkAvailable(Math.min(aRemainingToTransfer, this.mBufferSize))) {
                aEndOfFile = true;
            }
            if ((aTransferredCount = Math.min(aRemainingToTransfer, this.readyInBuffer())) == 0) {
                return aReadCount;
            }
            SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(this.buffer(), this.mReadPosition, theAddress + (long)aWritePosition, aTransferredCount);
            this.mReadPosition += aTransferredCount;
            aWritePosition += aTransferredCount;
            aReadCount += aTransferredCount;
            if (!aEndOfFile) continue;
            return aReadCount;
        }
        return aReadCount;
    }

    public int read(byte[] theData) throws IOException {
        return this.read(theData, 0, theData.length);
    }

    public byte readByte() {
        if (!this.checkAvailable(1)) {
            throw new IllegalStateException("Reached end of file while trying to read a byte value from spilled file");
        }
        byte aResult = this.buffer()[this.mReadPosition];
        ++this.mReadPosition;
        return aResult;
    }

    public int readInt() {
        if (!this.checkAvailable(4)) {
            throw new IllegalStateException("Reached end of file while trying to read an int value from spilled file");
        }
        int aResult = this.mBufferMemoryAccessor.getInt(this.mReadPosition);
        this.mReadPosition += 4;
        return aResult;
    }

    public int readVInt() {
        return this.readInt();
    }

    public long readLong() {
        if (!this.checkAvailable(8)) {
            throw new IllegalStateException("Reached end of file while trying to read a long value from spilled file");
        }
        long aResult = this.mBufferMemoryAccessor.getLong(this.mReadPosition);
        this.mReadPosition += 8;
        return aResult;
    }

    public long readVLong() {
        return this.readLong();
    }

    public double readDouble() {
        if (!this.checkAvailable(8)) {
            throw new IllegalStateException("Reached end of file while trying to read a double value from spilled file");
        }
        double aResult = this.mBufferMemoryAccessor.getDouble(this.mReadPosition);
        this.mReadPosition += 8;
        return aResult;
    }

    public float readFloat() {
        if (!this.checkAvailable(4)) {
            throw new IllegalStateException("Reached end of file while trying to read a float value from spilled file");
        }
        float aResult = this.mBufferMemoryAccessor.getFloat(this.mReadPosition);
        this.mReadPosition += 4;
        return aResult;
    }

    public short readShort() {
        if (!this.checkAvailable(2)) {
            throw new IllegalStateException("Reached end of file while trying to read a short value from spilled file");
        }
        short aResult = this.mBufferMemoryAccessor.getShort(this.mReadPosition);
        this.mReadPosition += 2;
        return aResult;
    }

    public String readString() {
        throw new UnsupportedOperationException("");
    }

    public long getPosition() {
        return this.mFileOffset - (long)this.mReadLimit + (long)this.mReadPosition;
    }

    public void setPosition(long thePosition) throws IOException {
        if (thePosition != this.getPosition()) {
            this.resetBufferCounters();
            this.position(thePosition);
        }
    }

    @Override
    public void resetPosition() {
        this.resetBufferCounters();
        try {
            if (this.mInput != null) {
                this.position(0L);
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void moveForward(long theBytes) {
        if ((long)this.readyInBuffer() >= theBytes) {
            this.mReadPosition = (int)((long)this.mReadPosition + theBytes);
            return;
        }
        try {
            long position = this.position();
            long delta = theBytes - (long)this.readyInBuffer();
            this.mReadLimit = 0;
            this.mReadPosition = 0;
            this.position(position + delta);
        }
        catch (IOException e) {
            throw new IllegalStateException("Move forward failed", e);
        }
    }

    protected abstract void openInput(S var1);

    protected abstract void openInput(File var1) throws FileNotFoundException;

    protected abstract long position() throws IOException;

    protected abstract void closeInput() throws IOException;

    protected abstract void position(long var1) throws IOException;

    protected abstract int read(int var1) throws IOException;

    protected void resetBufferCounters() {
        this.mReadLimit = 0;
        this.mReadPosition = 0;
    }

    private int readyInBuffer() {
        return this.mReadLimit - this.mReadPosition;
    }

    private int freeInBuffer() {
        return this.mBufferSize - this.mReadLimit;
    }

    private void compact() {
        int remaining = this.readyInBuffer();
        if (remaining > 0) {
            this.mBufferMemoryAccessor.copyMemory(this.mReadPosition, 0L, remaining);
        }
        this.mReadPosition = 0;
        this.mReadLimit = remaining;
    }

    protected final byte[] buffer() {
        return this.mBufferMemoryAccessor.array();
    }

    @Override
    public void close() {
        this.resetPosition();
        if (this.mInput == null) {
            return;
        }
        try {
            this.closeInput();
            this.mInput = null;
        }
        catch (IOException e) {
            throw Utilities.rethrow(e);
        }
    }
}

