/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.factory.impl.factory.pooled;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.factory.impl.factory.BaseCollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.memoryblock.MemoryTypeUsageStrategy;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.OperationTracker;
import java.util.ArrayDeque;
import java.util.Deque;

abstract class BasePooledCollectionFactory<T extends Collection, C extends CollectionFactory<T>>
extends BaseCollectionFactory<T> {
    protected final int mPoolSize;
    protected final C mCollectionFactory;
    protected final ThreadLocal<Deque<T>> mLocalPool = new ThreadLocal();

    protected BasePooledCollectionFactory(int theSpillingBufferSize, MemoryContext theMemoryContext, MemoryTypeUsageStrategy theMemoryTypeUsageStrategy, int thePoolSize, C theBaseCollectionFactory, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theMemoryTypeUsageStrategy, theOperationTracker);
        this.mPoolSize = thePoolSize;
        this.mCollectionFactory = theBaseCollectionFactory;
    }

    @Override
    public void releaseCollection(T theCollection) {
        this.ensureLocalPool();
        if (this.mLocalPool.get().size() < this.mPoolSize) {
            this.mLocalPool.get().add(theCollection);
        }
    }

    @Override
    public T create(CollectionFactory<T> theOriginFactory) {
        if (this.checkPooledCollection()) {
            return (T)((Collection)this.mLocalPool.get().remove());
        }
        return this.mCollectionFactory.create(theOriginFactory);
    }

    @Override
    public void dispose() {
        this.mLocalPool.remove();
    }

    protected boolean checkPooledCollection() {
        this.ensureLocalPool();
        return this.mLocalPool.get().size() > 0;
    }

    protected void ensureLocalPool() {
        if (this.mLocalPool.get() == null) {
            this.mLocalPool.set(new ArrayDeque(this.mPoolSize));
        }
    }
}

