/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.factory.impl;

import com.complexible.memory.factory.AggregatorFactory;
import com.complexible.memory.factory.ArrayFactory;
import com.complexible.memory.factory.HashSetFactory;
import com.complexible.memory.factory.HashTableFactory;
import com.complexible.memory.factory.LongDequeueFactory;
import com.complexible.memory.factory.LongHashSetFactory;
import com.complexible.memory.factory.LongQueueFactory;
import com.complexible.memory.factory.impl.BaseCollectionFactoryContext;
import com.complexible.memory.factory.impl.factory.pooled.PooledAggregatorFactory;
import com.complexible.memory.factory.impl.factory.pooled.PooledArrayFactory;
import com.complexible.memory.factory.impl.factory.pooled.PooledHashSetFactory;
import com.complexible.memory.factory.impl.factory.pooled.PooledHashTableFactory;
import com.complexible.memory.factory.impl.factory.pooled.PooledLongDequeueFactory;
import com.complexible.memory.factory.impl.factory.pooled.PooledLongHashSetFactory;
import com.complexible.memory.factory.impl.factory.pooled.PooledLongQueueFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.memoryblock.MemoryTypeUsageStrategy;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.aggregator.DefaultAggregatorFactory;
import com.complexible.memory.structure.impl.array.DefaultArrayFactory;
import com.complexible.memory.structure.impl.hashtable.DefaultHashSetFactory;
import com.complexible.memory.structure.impl.hashtable.DefaultHashTableFactory;
import com.complexible.memory.structure.impl.hashtable.DefaultLongHashSetFactory;
import com.complexible.memory.structure.impl.queue.DefaultLongDequeueFactory;
import com.complexible.memory.structure.impl.queue.DefaultLongQueueFactory;

public final class PooledCollectionFactoryContext
extends BaseCollectionFactoryContext {
    private final int mPoolSize;
    private final ArrayFactory mArrayFactory;
    private final HashSetFactory mHashSetFactory;
    private final HashTableFactory mHashTableFactory;
    private final LongQueueFactory mLongQueueFactory;
    private final LongDequeueFactory mLongDequeueFactory;
    private final AggregatorFactory mAggregatorFactory;
    private final LongHashSetFactory mLongHashSetFactory;

    public PooledCollectionFactoryContext(int spillingBufferSize, MemoryContext theMemoryContext, MemoryTypeUsageStrategy theMemoryTypeUsageStrategy, int thePoolSize, OperationTracker theOperationTracker) {
        super(spillingBufferSize, theMemoryContext, theMemoryTypeUsageStrategy, theOperationTracker);
        this.mPoolSize = thePoolSize;
        this.mArrayFactory = this.createArrayFactory();
        this.mHashSetFactory = this.createHashSetFactory();
        this.mHashTableFactory = this.createHashTableFactory();
        this.mAggregatorFactory = this.createAggregatorFactory();
        this.mLongHashSetFactory = this.createLongHashSetFactory();
        this.mLongQueueFactory = this.createLongQueueFactory();
        this.mLongDequeueFactory = this.createLongDequeueFactory();
    }

    private LongDequeueFactory createLongDequeueFactory() {
        return new PooledLongDequeueFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultLongDequeueFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    private LongQueueFactory createLongQueueFactory() {
        return new PooledLongQueueFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultLongQueueFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    private AggregatorFactory createAggregatorFactory() {
        return new PooledAggregatorFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultAggregatorFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    private HashSetFactory createHashSetFactory() {
        return new PooledHashSetFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultHashSetFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    private LongHashSetFactory createLongHashSetFactory() {
        return new PooledLongHashSetFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultLongHashSetFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    private HashTableFactory createHashTableFactory() {
        return new PooledHashTableFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultHashTableFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    private ArrayFactory createArrayFactory() {
        return new PooledArrayFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, new DefaultArrayFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker), this.mPoolSize, this.mOperationTracker);
    }

    @Override
    public ArrayFactory arrayFactory() {
        return this.mArrayFactory;
    }

    @Override
    public HashTableFactory hashTableFactory() {
        return this.mHashTableFactory;
    }

    @Override
    public HashSetFactory hashSetFactory() {
        return this.mHashSetFactory;
    }

    @Override
    public LongHashSetFactory longHashSetFactory() {
        return this.mLongHashSetFactory;
    }

    @Override
    public AggregatorFactory aggregatorFactory() {
        return this.mAggregatorFactory;
    }

    @Override
    public LongQueueFactory longQueueFactory() {
        return this.mLongQueueFactory;
    }

    @Override
    public LongDequeueFactory longDequeueFactory() {
        return this.mLongDequeueFactory;
    }

    public void dispose() {
        this.mArrayFactory.dispose();
        this.mHashSetFactory.dispose();
        this.mHashTableFactory.dispose();
        this.mLongQueueFactory.dispose();
        this.mLongDequeueFactory.dispose();
        this.mAggregatorFactory.dispose();
        this.mLongHashSetFactory.dispose();
    }
}

