/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.factory.impl;

import com.complexible.memory.factory.AggregatorFactory;
import com.complexible.memory.factory.ArrayFactory;
import com.complexible.memory.factory.HashSetFactory;
import com.complexible.memory.factory.HashTableFactory;
import com.complexible.memory.factory.LongDequeueFactory;
import com.complexible.memory.factory.LongHashSetFactory;
import com.complexible.memory.factory.LongQueueFactory;
import com.complexible.memory.factory.impl.BaseCollectionFactoryContext;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.memoryblock.MemoryTypeUsageStrategy;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.aggregator.DefaultAggregatorFactory;
import com.complexible.memory.structure.impl.array.DefaultArrayFactory;
import com.complexible.memory.structure.impl.hashtable.DefaultHashSetFactory;
import com.complexible.memory.structure.impl.hashtable.DefaultHashTableFactory;
import com.complexible.memory.structure.impl.hashtable.DefaultLongHashSetFactory;
import com.complexible.memory.structure.impl.queue.DefaultLongDequeueFactory;
import com.complexible.memory.structure.impl.queue.DefaultLongQueueFactory;

public final class DefaultCollectionFactoryContext
extends BaseCollectionFactoryContext {
    private final ArrayFactory mArrayFactory = this.createArrayFactory();
    private final HashSetFactory mHashSetFactory = this.createHashSetFactory();
    private final HashTableFactory mHashTableFactory = this.createHashTableFactory();
    private final LongQueueFactory mLongQueueFactory;
    private final LongDequeueFactory mLongDequeueFactory;
    private final AggregatorFactory mAggregatorFactory = this.createAggregatorFactory();
    private final LongHashSetFactory mLongHashSetFactory = this.createLongHashSetFactory();

    public DefaultCollectionFactoryContext(int spillingBufferSize, MemoryContext theMemoryContext, MemoryTypeUsageStrategy theMemoryTypeUsageStrategy, OperationTracker theOperationTracker) {
        super(spillingBufferSize, theMemoryContext, theMemoryTypeUsageStrategy, theOperationTracker);
        this.mLongQueueFactory = this.createLongQueueFactory();
        this.mLongDequeueFactory = this.createLongDequeueFactory();
    }

    private AggregatorFactory createAggregatorFactory() {
        return new DefaultAggregatorFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    private HashSetFactory createHashSetFactory() {
        return new DefaultHashSetFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    private LongHashSetFactory createLongHashSetFactory() {
        return new DefaultLongHashSetFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    private HashTableFactory createHashTableFactory() {
        return new DefaultHashTableFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    private ArrayFactory createArrayFactory() {
        return new DefaultArrayFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    private LongDequeueFactory createLongDequeueFactory() {
        return new DefaultLongDequeueFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    private LongQueueFactory createLongQueueFactory() {
        return new DefaultLongQueueFactory(this.mSpillingBufferSize, this.mMemoryContext, this.mMemoryTypeUsageStrategy, this.mOperationTracker);
    }

    @Override
    public ArrayFactory arrayFactory() {
        return this.mArrayFactory;
    }

    @Override
    public HashTableFactory hashTableFactory() {
        return this.mHashTableFactory;
    }

    @Override
    public HashSetFactory hashSetFactory() {
        return this.mHashSetFactory;
    }

    @Override
    public LongHashSetFactory longHashSetFactory() {
        return this.mLongHashSetFactory;
    }

    @Override
    public AggregatorFactory aggregatorFactory() {
        return this.mAggregatorFactory;
    }

    @Override
    public LongQueueFactory longQueueFactory() {
        return this.mLongQueueFactory;
    }

    @Override
    public LongDequeueFactory longDequeueFactory() {
        return this.mLongDequeueFactory;
    }

    public void dispose() {
        this.mArrayFactory.dispose();
        this.mHashSetFactory.dispose();
        this.mHashTableFactory.dispose();
        this.mLongQueueFactory.dispose();
        this.mAggregatorFactory.dispose();
        this.mLongDequeueFactory.dispose();
    }
}

