/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.accessor.impl;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;

final class SystemNativeMemoryAccessor
implements SystemMemoryAccessor {
    public static final SystemNativeMemoryAccessor INSTANCE = UnsafeUtil.UNSAFE_AVAILABLE && SystemNativeMemoryAccessor.isUnalignedAccessAllowed() ? new SystemNativeMemoryAccessor() : null;

    SystemNativeMemoryAccessor() {
        if (!UnsafeUtil.UNSAFE_AVAILABLE) {
            throw new IllegalStateException("UNSAFE is unavailable");
        }
    }

    static boolean isUnalignedAccessAllowed() {
        String arch = System.getProperty("os.arch");
        return arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return UnsafeUtil.UNSAFE.getBoolean(null, theAddress);
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        UnsafeUtil.UNSAFE.putBoolean(null, theAddress, theValue);
    }

    @Override
    public byte getByte(long theAddress) {
        return UnsafeUtil.UNSAFE.getByte(theAddress);
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        UnsafeUtil.UNSAFE.putByte(theAddress, theValue);
    }

    @Override
    public char getChar(long theAddress) {
        return UnsafeUtil.UNSAFE.getChar(theAddress);
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        UnsafeUtil.UNSAFE.putChar(theAddress, theValue);
    }

    @Override
    public short getShort(long theAddress) {
        return UnsafeUtil.UNSAFE.getShort(theAddress);
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        UnsafeUtil.UNSAFE.putShort(theAddress, theValue);
    }

    @Override
    public int getInt(long theAddress) {
        return UnsafeUtil.UNSAFE.getInt(theAddress);
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        UnsafeUtil.UNSAFE.putInt(theAddress, theValue);
    }

    @Override
    public float getFloat(long theAddress) {
        return UnsafeUtil.UNSAFE.getFloat(theAddress);
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        UnsafeUtil.UNSAFE.putFloat(theAddress, theValue);
    }

    @Override
    public long getLong(long theAddress) {
        return UnsafeUtil.UNSAFE.getLong(theAddress);
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        UnsafeUtil.UNSAFE.putLong(theAddress, theValue);
    }

    @Override
    public double getDouble(long theAddress) {
        return UnsafeUtil.UNSAFE.getDouble(theAddress);
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        UnsafeUtil.UNSAFE.putDouble(theAddress, theValue);
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long lengthBytes) {
        UnsafeUtil.UNSAFE.copyMemory(theSrcAddress, theDstAddress, lengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        this.copyMemory(theSourceArray, ARRAY_BYTE_BASE_OFFSET + ARRAY_BYTE_INDEX_SCALE * theSrcOffset, null, theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        this.copyMemory(theSourceArray, ARRAY_LONG_BASE_OFFSET + theSrcOffset, null, theDstAddress, theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        this.copyMemory(null, theSrcAddress, theDstArray, ARRAY_BYTE_BASE_OFFSET + ARRAY_BYTE_INDEX_SCALE * theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        this.copyMemory(null, theSrcAddress, theDstArray, (long)ARRAY_LONG_BASE_OFFSET + theDstOffset, theLength);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        this.copyMemory(null, theSrcAddress, theDstArray, (long)ARRAY_CHAR_BASE_OFFSET + theDstOffset, theLength);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        UnsafeUtil.UNSAFE.setMemory(theAddress, theLengthBytes, theValue);
    }

    @Override
    public int arrayBaseOffset(Class<?> arrayClass) {
        return UnsafeUtil.UNSAFE.arrayBaseOffset(arrayClass);
    }

    @Override
    public int arrayIndexScale(Class<?> arrayClass) {
        return UnsafeUtil.UNSAFE.arrayIndexScale(arrayClass);
    }

    @Override
    public void copyMemory(Object srcObj, long srcOffset, Object destObj, long destOffset, long lengthBytes) {
        UnsafeUtil.UNSAFE.copyMemory(srcObj, srcOffset, destObj, destOffset, lengthBytes);
    }

    @Override
    public byte getByte(Object theResource, long theOffset) {
        return UnsafeUtil.UNSAFE.getByte(theResource, theOffset);
    }

    @Override
    public void putByte(Object theResource, long theOffset, byte theValue) {
        UnsafeUtil.UNSAFE.putByte(theResource, theOffset, theValue);
    }
}

