/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.command.Accessor;
import io.airlift.command.OptionType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class OptionMetadata {
    private final OptionType optionType;
    private final Set<String> options;
    private final String title;
    private final String description;
    private final int arity;
    private final boolean required;
    private final boolean hidden;
    private final Set<String> allowedValues;
    private final Set<Accessor> accessors;

    public OptionMetadata(OptionType optionType, Iterable<String> options, String title, String description, int arity, boolean required, boolean hidden, Iterable<String> allowedValues, Iterable<Field> path) {
        Preconditions.checkNotNull((Object)((Object)optionType), (Object)"optionType is null");
        Preconditions.checkNotNull(options, (Object)"options is null");
        Preconditions.checkArgument((!Iterables.isEmpty(options) ? 1 : 0) != 0, (Object)"options is empty");
        Preconditions.checkNotNull((Object)title, (Object)"title is null");
        Preconditions.checkNotNull(path, (Object)"path is null");
        Preconditions.checkArgument((!Iterables.isEmpty(path) ? 1 : 0) != 0, (Object)"path is empty");
        this.optionType = optionType;
        this.options = ImmutableSet.copyOf(options);
        this.title = title;
        this.description = description;
        this.arity = arity;
        this.required = required;
        this.hidden = hidden;
        this.allowedValues = allowedValues != null ? ImmutableSet.copyOf(allowedValues) : null;
        this.accessors = ImmutableSet.of((Object)new Accessor(path));
    }

    public OptionMetadata(Iterable<OptionMetadata> options) {
        Preconditions.checkNotNull(options, (Object)"options is null");
        Preconditions.checkArgument((!Iterables.isEmpty(options) ? 1 : 0) != 0, (Object)"options is empty");
        OptionMetadata option = options.iterator().next();
        this.optionType = option.optionType;
        this.options = option.options;
        this.title = option.title;
        this.description = option.description;
        this.arity = option.arity;
        this.required = option.required;
        this.hidden = option.hidden;
        this.allowedValues = option.allowedValues != null ? ImmutableSet.copyOf(option.allowedValues) : null;
        HashSet accessors = Sets.newHashSet();
        for (OptionMetadata other : options) {
            Preconditions.checkArgument((boolean)option.equals(other), (String)"Conflicting options definitions: %s, %s", (Object)option, (Object)other);
            accessors.addAll(other.getAccessors());
        }
        this.accessors = ImmutableSet.copyOf((Collection)accessors);
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isMultiValued() {
        return this.accessors.iterator().next().isMultiValued();
    }

    public Class<?> getJavaType() {
        return this.accessors.iterator().next().getJavaType();
    }

    public Set<Accessor> getAccessors() {
        return this.accessors;
    }

    public Set<String> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionMetadata that = (OptionMetadata)o;
        if (this.arity != that.arity) {
            return false;
        }
        if (this.hidden != that.hidden) {
            return false;
        }
        if (this.required != that.required) {
            return false;
        }
        if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.optionType != that.optionType) {
            return false;
        }
        if (!this.options.equals(that.options)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public int hashCode() {
        int result = this.optionType.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.arity;
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.allowedValues != null ? this.allowedValues.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OptionMetadata");
        sb.append("{optionType=").append((Object)this.optionType);
        sb.append(", options=").append(this.options);
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", arity=").append(this.arity);
        sb.append(", required=").append(this.required);
        sb.append(", hidden=").append(this.hidden);
        sb.append(", accessors=").append(this.accessors);
        sb.append('}');
        return sb.toString();
    }

    public static Function<OptionMetadata, Set<String>> optionsGetter() {
        return new Function<OptionMetadata, Set<String>>(){

            public Set<String> apply(OptionMetadata input) {
                return input.getOptions();
            }
        };
    }

    public static Predicate<OptionMetadata> isHiddenPredicate() {
        return new Predicate<OptionMetadata>(){

            public boolean apply(@Nullable OptionMetadata input) {
                return !input.isHidden();
            }
        };
    }
}

