/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.airlift.command.Accessor;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Group;
import io.airlift.command.Groups;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import io.airlift.command.Suggester;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.OptionMetadata;
import io.airlift.command.model.SuggesterMetadata;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class MetadataLoader {
    public static GlobalMetadata loadGlobal(String name, Integer navOrder, String description, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> groups) {
        ImmutableList.Builder globalOptionsBuilder = ImmutableList.builder();
        if (defaultCommand != null) {
            globalOptionsBuilder.addAll(defaultCommand.getGlobalOptions());
        }
        for (CommandMetadata command : defaultGroupCommands) {
            globalOptionsBuilder.addAll(command.getGlobalOptions());
        }
        for (CommandGroupMetadata group : groups) {
            for (CommandMetadata command : group.getCommands()) {
                globalOptionsBuilder.addAll(command.getGlobalOptions());
            }
        }
        List<OptionMetadata> globalOptions = MetadataLoader.mergeOptionSet((List<OptionMetadata>)globalOptionsBuilder.build());
        return new GlobalMetadata(name, navOrder, description, globalOptions, defaultCommand, defaultGroupCommands, groups);
    }

    public static CommandGroupMetadata loadCommandGroup(String name, String description, String markdownDescription, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        ImmutableList.Builder groupOptionsBuilder = ImmutableList.builder();
        if (defaultCommand != null) {
            groupOptionsBuilder.addAll(defaultCommand.getGroupOptions());
        }
        for (CommandMetadata command : commands) {
            groupOptionsBuilder.addAll(command.getGroupOptions());
        }
        List<OptionMetadata> groupOptions = MetadataLoader.mergeOptionSet((List<OptionMetadata>)groupOptionsBuilder.build());
        return new CommandGroupMetadata(name, description, markdownDescription, groupOptions, defaultCommand, commands);
    }

    public static <T> ImmutableList<CommandMetadata> loadCommands(Iterable<Class<? extends T>> defaultCommands) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(defaultCommands, MetadataLoader::loadCommand));
    }

    public static CommandMetadata loadCommand(Class<?> commandType) {
        if (commandType == null) {
            return null;
        }
        Command command = null;
        ArrayList groups = Lists.newArrayList();
        Class<?> cls = commandType;
        while (command == null && !Object.class.equals(cls)) {
            command = cls.getAnnotation(Command.class);
            if (cls.isAnnotationPresent(Groups.class)) {
                groups.addAll(Arrays.asList(cls.getAnnotation(Groups.class).value()));
            }
            if (cls.isAnnotationPresent(Group.class)) {
                groups.add(cls.getAnnotation(Group.class));
            }
            cls = cls.getSuperclass();
        }
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (String)"Command %s is not annotated with @Command", (Object)commandType.getName());
        String name = command.name();
        String description = command.description().isEmpty() ? null : command.description();
        List<String> groupNames = Arrays.asList(command.groupNames());
        boolean hidden = command.hidden();
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(commandType);
        return new CommandMetadata(name, description, command.discussion().isEmpty() ? null : command.discussion(), command.examples().length == 0 ? null : Lists.newArrayList((Object[])command.examples()), hidden, injectionMetadata.globalOptions, injectionMetadata.groupOptions, injectionMetadata.commandOptions, (ArgumentsMetadata)Iterables.getFirst((Iterable)injectionMetadata.arguments, null), injectionMetadata.metadataInjections, commandType, groupNames, groups);
    }

    public static SuggesterMetadata loadSuggester(Class<? extends Suggester> suggesterClass) {
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(suggesterClass);
        return new SuggesterMetadata(suggesterClass, injectionMetadata.metadataInjections);
    }

    public static InjectionMetadata loadInjectionMetadata(Class<?> type) {
        InjectionMetadata injectionMetadata = new InjectionMetadata();
        MetadataLoader.loadInjectionMetadata(type, injectionMetadata, (List<Field>)ImmutableList.of());
        injectionMetadata.compact();
        return injectionMetadata;
    }

    public static void loadInjectionMetadata(Class<?> type, InjectionMetadata injectionMetadata, List<Field> fields) {
        if (type.isInterface()) {
            return;
        }
        Class<?> cls = type;
        while (!Object.class.equals(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                ImmutableList<Field> path = MetadataLoader.concat(fields, field);
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation != null) {
                    if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                        injectionMetadata.metadataInjections.add(new Accessor((Iterable<Field>)path));
                    } else {
                        MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                    }
                }
                try {
                    Object aGuiceInject = field.getAnnotation(Class.forName("com.google.inject.Inject"));
                    if (aGuiceInject != null) {
                        if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                            injectionMetadata.metadataInjections.add(new Accessor((Iterable<Field>)path));
                        } else {
                            MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                        }
                    }
                }
                catch (ClassNotFoundException aGuiceInject) {
                }
                catch (ClassCastException aGuiceInject) {
                    // empty catch block
                }
                Option optionAnnotation = field.getAnnotation(Option.class);
                if (optionAnnotation != null) {
                    Class<?> fieldType;
                    OptionType optionType = optionAnnotation.type();
                    String name = !optionAnnotation.title().isEmpty() ? optionAnnotation.title() : field.getName();
                    ImmutableList options = ImmutableList.copyOf((Object[])optionAnnotation.name());
                    String description = optionAnnotation.description();
                    int arity = optionAnnotation.arity();
                    Preconditions.checkArgument((arity >= 0 || arity == Integer.MIN_VALUE ? 1 : 0) != 0, (String)"Invalid arity for option %s", (Object)name);
                    arity = optionAnnotation.arity() >= 0 ? optionAnnotation.arity() : (Boolean.class.isAssignableFrom(fieldType = field.getType()) || Boolean.TYPE.isAssignableFrom(fieldType) ? 0 : 1);
                    boolean required = optionAnnotation.required();
                    boolean hidden = optionAnnotation.hidden();
                    ImmutableList allowedValues = ImmutableList.copyOf((Object[])optionAnnotation.allowedValues());
                    if (allowedValues.isEmpty()) {
                        allowedValues = null;
                    }
                    OptionMetadata optionMetadata = new OptionMetadata(optionType, (Iterable<String>)options, name, description, arity, required, hidden, (Iterable<String>)allowedValues, (Iterable<Field>)path);
                    switch (optionType) {
                        case GLOBAL: {
                            injectionMetadata.globalOptions.add(optionMetadata);
                            break;
                        }
                        case GROUP: {
                            injectionMetadata.groupOptions.add(optionMetadata);
                            break;
                        }
                        case COMMAND: {
                            injectionMetadata.commandOptions.add(optionMetadata);
                        }
                    }
                }
                Arguments argumentsAnnotation = field.getAnnotation(Arguments.class);
                if (!field.isAnnotationPresent(Arguments.class)) continue;
                ImmutableList.Builder titlesBuilder = ImmutableList.builder();
                if (argumentsAnnotation.title().length != 1 || !argumentsAnnotation.title()[0].isEmpty()) {
                    titlesBuilder.add((Object[])argumentsAnnotation.title());
                } else {
                    titlesBuilder.add((Object)field.getName());
                }
                String description = argumentsAnnotation.description();
                String usage = argumentsAnnotation.usage();
                boolean required = argumentsAnnotation.required();
                injectionMetadata.arguments.add(new ArgumentsMetadata((Iterable<String>)titlesBuilder.build(), description, usage, required, (Iterable<Field>)path));
            }
            cls = cls.getSuperclass();
        }
    }

    private static List<OptionMetadata> mergeOptionSet(List<OptionMetadata> options) {
        Multimap metadataIndex = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), Lists::newArrayList);
        for (OptionMetadata option : options) {
            metadataIndex.put((Object)option, (Object)option);
        }
        options = ImmutableList.copyOf((Iterable)Iterables.transform(metadataIndex.asMap().values(), OptionMetadata::new));
        LinkedHashMap optionIndex = Maps.newLinkedHashMap();
        for (OptionMetadata option : options) {
            for (String optionName : option.getOptions()) {
                if (optionIndex.containsKey(optionName)) {
                    throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s", ((OptionMetadata)optionIndex.get(optionName)).getAccessors().iterator().next(), option.getAccessors().iterator().next(), optionName));
                }
                optionIndex.put(optionName, option);
            }
        }
        return options;
    }

    private static <T> ImmutableList<T> concat(Iterable<T> iterable, T item) {
        return ImmutableList.builder().addAll(iterable).add(item).build();
    }

    public static void loadCommandsIntoGroupsByAnnotation(List<CommandMetadata> allCommands, List<CommandGroupMetadata> commandGroups, List<CommandMetadata> defaultCommandGroup) {
        ArrayList<CommandMetadata> newCommands = new ArrayList<CommandMetadata>();
        MetadataLoader.createGroupsFromAnnotations(allCommands, newCommands, commandGroups, defaultCommandGroup);
        for (CommandMetadata command : allCommands) {
            boolean added = false;
            for (String groupName : command.getGroupNames()) {
                CommandGroupMetadata group = (CommandGroupMetadata)Iterables.find(commandGroups, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)groupName), CommandGroupMetadata.nameGetter()), null);
                if (group != null) {
                    group.addCommand(command);
                    added = true;
                    continue;
                }
                ImmutableList.Builder groupOptionsBuilder = ImmutableList.builder();
                groupOptionsBuilder.addAll(command.getGroupOptions());
                CommandGroupMetadata newGroup = MetadataLoader.loadCommandGroup(groupName, "", null, null, Collections.singletonList(command));
                commandGroups.add(newGroup);
                added = true;
            }
            if (!added || !defaultCommandGroup.contains(command)) continue;
            defaultCommandGroup.remove(command);
        }
        allCommands.addAll(newCommands);
    }

    private static void createGroupsFromAnnotations(List<CommandMetadata> allCommands, List<CommandMetadata> newCommands, List<CommandGroupMetadata> commandGroups, List<CommandMetadata> defaultCommandGroup) {
        for (CommandMetadata command : allCommands) {
            boolean added = false;
            for (Group groupAnno : command.getGroups()) {
                Class<?> defaultCommandClass = null;
                CommandMetadata defaultCommand = null;
                if (!groupAnno.defaultCommand().equals(Group.DEFAULT.class) && null == (defaultCommand = (CommandMetadata)Iterables.find(allCommands, (Predicate)Predicates.compose((Predicate)Predicates.equalTo(defaultCommandClass = groupAnno.defaultCommand()), CommandMetadata.typeGetter()), null))) {
                    defaultCommand = MetadataLoader.loadCommand(defaultCommandClass);
                    newCommands.add(defaultCommand);
                }
                ArrayList<CommandMetadata> groupCommands = new ArrayList<CommandMetadata>(groupAnno.commands().length);
                for (Class<?> commandClass : groupAnno.commands()) {
                    CommandMetadata groupCommand = (CommandMetadata)Iterables.find(allCommands, (Predicate)Predicates.compose((Predicate)Predicates.equalTo(commandClass), CommandMetadata.typeGetter()), null);
                    if (null != groupCommand) continue;
                    groupCommand = MetadataLoader.loadCommand(commandClass);
                    newCommands.add(groupCommand);
                    groupCommands.add(groupCommand);
                }
                CommandGroupMetadata groupMetadata = (CommandGroupMetadata)Iterables.find(commandGroups, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)groupAnno.name()), CommandGroupMetadata.nameGetter()), null);
                if (null == groupMetadata) {
                    groupMetadata = MetadataLoader.loadCommandGroup(groupAnno.name(), groupAnno.description(), null, defaultCommand, groupCommands);
                    commandGroups.add(groupMetadata);
                }
                groupMetadata.addCommand(command);
                added = true;
            }
            if (!added || !defaultCommandGroup.contains(command)) continue;
            defaultCommandGroup.remove(command);
        }
    }

    private static class InjectionMetadata {
        private List<OptionMetadata> globalOptions = Lists.newArrayList();
        private List<OptionMetadata> groupOptions = Lists.newArrayList();
        private List<OptionMetadata> commandOptions = Lists.newArrayList();
        private List<ArgumentsMetadata> arguments = Lists.newArrayList();
        private List<Accessor> metadataInjections = Lists.newArrayList();

        private InjectionMetadata() {
        }

        private void compact() {
            this.globalOptions = MetadataLoader.mergeOptionSet(this.globalOptions);
            this.groupOptions = MetadataLoader.mergeOptionSet(this.groupOptions);
            this.commandOptions = MetadataLoader.mergeOptionSet(this.commandOptions);
            if (this.arguments.size() > 1) {
                this.arguments = ImmutableList.of((Object)new ArgumentsMetadata(this.arguments));
            }
        }
    }
}

