/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import io.airlift.command.Accessor;
import io.airlift.command.Group;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.List;

public class CommandMetadata {
    private final String name;
    private final String description;
    private final boolean hidden;
    private final List<OptionMetadata> globalOptions;
    private final List<OptionMetadata> groupOptions;
    private final List<OptionMetadata> commandOptions;
    private final ArgumentsMetadata arguments;
    private final List<Accessor> metadataInjections;
    private final Class<?> type;
    private final List<String> groupNames;
    private final List<Group> groups;
    private final List<String> examples;
    private final String discussion;

    public CommandMetadata(String name, String description, String discussion, List<String> examples, boolean hidden, Iterable<OptionMetadata> globalOptions, Iterable<OptionMetadata> groupOptions, Iterable<OptionMetadata> commandOptions, ArgumentsMetadata arguments, Iterable<Accessor> metadataInjections, Class<?> type, List<String> groupNames, List<Group> groups) {
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.globalOptions = ImmutableList.copyOf(globalOptions);
        this.groupOptions = ImmutableList.copyOf(groupOptions);
        this.commandOptions = ImmutableList.copyOf(commandOptions);
        this.arguments = arguments;
        this.metadataInjections = ImmutableList.copyOf(metadataInjections);
        this.type = type;
        this.discussion = discussion;
        this.examples = examples;
        this.groupNames = groupNames;
        this.groups = groups;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<OptionMetadata> getAllOptions() {
        return ImmutableList.builder().addAll(this.globalOptions).addAll(this.groupOptions).addAll(this.commandOptions).build();
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public String getDiscussion() {
        return this.discussion;
    }

    public List<OptionMetadata> getGlobalOptions() {
        return this.globalOptions;
    }

    public List<OptionMetadata> getGroupOptions() {
        return this.groupOptions;
    }

    public List<OptionMetadata> getCommandOptions() {
        return this.commandOptions;
    }

    public ArgumentsMetadata getArguments() {
        return this.arguments;
    }

    public List<Accessor> getMetadataInjections() {
        return this.metadataInjections;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", discussion='").append(this.discussion).append('\'');
        sb.append(", examples='").append(this.examples).append('\'');
        sb.append(", globalOptions=").append(this.globalOptions);
        sb.append(", groupOptions=").append(this.groupOptions);
        sb.append(", commandOptions=").append(this.commandOptions);
        sb.append(", arguments=").append(this.arguments);
        sb.append(", metadataInjections=").append(this.metadataInjections);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static Function<CommandMetadata, String> nameGetter() {
        return CommandMetadata::getName;
    }

    public static Function<CommandMetadata, Class> typeGetter() {
        return CommandMetadata::getType;
    }
}

