/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.List;

public class CommandGroupMetadata {
    private final String name;
    private final String description;
    private final String markdownDescription;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> commands;

    public CommandGroupMetadata(String name, String description, String markdownDescription, Iterable<OptionMetadata> options, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        this.name = name;
        this.description = description;
        this.markdownDescription = markdownDescription;
        this.options = ImmutableList.copyOf(options);
        this.defaultCommand = defaultCommand;
        this.commands = Lists.newArrayList(commands);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMarkdownDescription() {
        return this.markdownDescription;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getCommands() {
        return ImmutableList.copyOf(this.commands);
    }

    public void addCommand(CommandMetadata command) {
        if (!this.commands.contains(command)) {
            this.commands.add(command);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandGroupMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        if (this.markdownDescription != null) {
            sb.append(", markdownDescription='").append(this.markdownDescription).append('\'');
        }
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", commands=").append(this.commands);
        sb.append('}');
        return sb.toString();
    }

    public static Function<CommandGroupMetadata, String> nameGetter() {
        return CommandGroupMetadata::getName;
    }
}

