/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.command.Context;
import io.airlift.command.ParseOptionIllegalValueException;
import io.airlift.command.ParseState;
import io.airlift.command.TypeConverter;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.List;
import java.util.regex.Pattern;

public class Parser {
    private static final Pattern SHORT_OPTIONS_PATTERN = Pattern.compile("-[^-].*");

    public ParseState parse(GlobalMetadata metadata, String ... params) {
        return this.parse(metadata, (Iterable<String>)ImmutableList.copyOf((Object[])params));
    }

    public ParseState parse(GlobalMetadata metadata, Iterable<String> params) {
        ParseState state;
        block8: {
            CommandGroupMetadata group;
            PeekingIterator tokens = Iterators.peekingIterator(params.iterator());
            state = ParseState.newInstance().pushContext(Context.GLOBAL);
            state = this.parseOptions((PeekingIterator<String>)tokens, state, metadata.getOptions());
            if (tokens.hasNext() && (group = (CommandGroupMetadata)Iterables.find(metadata.getCommandGroups(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)((String)tokens.peek())), CommandGroupMetadata.nameGetter()), null)) != null) {
                tokens.next();
                state = state.withGroup(group).pushContext(Context.GROUP);
                state = this.parseOptions((PeekingIterator<String>)tokens, state, state.getGroup().getOptions());
            }
            List<CommandMetadata> expectedCommands = metadata.getDefaultGroupCommands();
            if (state.getGroup() != null) {
                expectedCommands = state.getGroup().getCommands();
            }
            if (!tokens.hasNext()) break block8;
            CommandMetadata command = (CommandMetadata)Iterables.find(expectedCommands, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)((String)tokens.peek())), CommandMetadata.nameGetter()), state.getGroup() != null ? state.getGroup().getDefaultCommand() : null);
            if (command == null && state.getGroup() == null && metadata.getDefaultCommand() != null) {
                command = metadata.getDefaultCommand();
            }
            if (command == null) {
                while (tokens.hasNext()) {
                    state = state.withUnparsedInput((String)tokens.next());
                }
            } else {
                if (((String)tokens.peek()).equals(command.getName())) {
                    tokens.next();
                }
                state = state.withCommand(command).pushContext(Context.COMMAND);
                while (tokens.hasNext()) {
                    state = this.parseOptions((PeekingIterator<String>)tokens, state, command.getCommandOptions());
                    state = this.parseArgs(state, (PeekingIterator<String>)tokens, command.getArguments());
                }
            }
        }
        return state;
    }

    public ParseState parseCommand(CommandMetadata command, Iterable<String> params) {
        PeekingIterator tokens = Iterators.peekingIterator(params.iterator());
        ParseState state = ParseState.newInstance().pushContext(Context.GLOBAL).withCommand(command);
        while (tokens.hasNext()) {
            state = this.parseOptions((PeekingIterator<String>)tokens, state, command.getCommandOptions());
            state = this.parseArgs(state, (PeekingIterator<String>)tokens, command.getArguments());
        }
        return state;
    }

    private ParseState parseOptions(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        while (tokens.hasNext()) {
            ParseState nextState = this.parseSimpleOption(tokens, state, allowedOptions);
            if (nextState != null) {
                state = nextState;
                continue;
            }
            nextState = this.parseLongGnuGetOpt(tokens, state, allowedOptions);
            if (nextState != null) {
                state = nextState;
                continue;
            }
            nextState = this.parseClassicGetOpt(tokens, state, allowedOptions);
            if (nextState == null) break;
            state = nextState;
        }
        return state;
    }

    private ParseState parseSimpleOption(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        OptionMetadata option = this.findOption(allowedOptions, (String)tokens.peek());
        if (option == null) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        if (option.getArity() == 0) {
            state = state.withOptionValue(option, Boolean.TRUE).popContext();
        } else if (option.getArity() == 1) {
            if (tokens.hasNext()) {
                String tokenStr = (String)tokens.next();
                this.checkValidValue(option, tokenStr);
                Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), tokenStr);
                state = state.withOptionValue(option, value).popContext();
            }
        } else {
            int count;
            ImmutableList.Builder values = ImmutableList.builder();
            boolean hasSeparator = false;
            boolean foundNextOption = false;
            for (count = 0; count < option.getArity() && tokens.hasNext() && !hasSeparator; ++count) {
                String peekedToken = (String)tokens.peek();
                hasSeparator = peekedToken.equals("--");
                boolean bl = foundNextOption = this.findOption(allowedOptions, peekedToken) != null;
                if (hasSeparator || foundNextOption) break;
                String tokenStr = (String)tokens.next();
                this.checkValidValue(option, tokenStr);
                values.add(TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), tokenStr));
            }
            if (count == option.getArity() || hasSeparator || foundNextOption) {
                state = state.withOptionValue(option, values.build()).popContext();
            }
        }
        return state;
    }

    private ParseState parseLongGnuGetOpt(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)'=').limit(2).split((CharSequence)tokens.peek()));
        if (parts.size() != 2) {
            return null;
        }
        OptionMetadata option = this.findOption(allowedOptions, (String)parts.get(0));
        if (option == null || option.getArity() != 1) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        this.checkValidValue(option, (String)parts.get(1));
        Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), (String)parts.get(1));
        state = state.withOption(option).withOptionValue(option, value).popContext();
        return state;
    }

    private ParseState parseClassicGetOpt(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        if (!SHORT_OPTIONS_PATTERN.matcher((CharSequence)tokens.peek()).matches()) {
            return null;
        }
        String remainingToken = ((String)tokens.peek()).substring(1);
        ParseState nextState = state;
        while (!remainingToken.isEmpty()) {
            char tokenCharacter = remainingToken.charAt(0);
            OptionMetadata option = this.findOption(allowedOptions, "-" + tokenCharacter);
            if (option == null) {
                return null;
            }
            nextState = nextState.pushContext(Context.OPTION).withOption(option);
            remainingToken = remainingToken.substring(1);
            if (option.getArity() == 0) {
                nextState = nextState.withOptionValue(option, Boolean.TRUE).popContext();
                continue;
            }
            if (option.getArity() == 1) {
                tokens.next();
                if (!remainingToken.isEmpty()) {
                    this.checkValidValue(option, remainingToken);
                    Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), remainingToken);
                    nextState = nextState.withOptionValue(option, value).popContext();
                } else if (tokens.hasNext()) {
                    String tokenStr = (String)tokens.next();
                    this.checkValidValue(option, tokenStr);
                    Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), tokenStr);
                    nextState = nextState.withOptionValue(option, value).popContext();
                }
                return nextState;
            }
            throw new UnsupportedOperationException("Short options style can not be used with option " + option.getAllowedValues());
        }
        tokens.next();
        return nextState;
    }

    private void checkValidValue(OptionMetadata option, String tokenStr) {
        if (option.getAllowedValues() == null) {
            return;
        }
        if (option.getAllowedValues().contains(tokenStr)) {
            return;
        }
        throw new ParseOptionIllegalValueException(option.getTitle(), tokenStr, option.getAllowedValues());
    }

    private ParseState parseArgs(ParseState state, PeekingIterator<String> tokens, ArgumentsMetadata arguments) {
        if (tokens.hasNext()) {
            if (((String)tokens.peek()).equals("--")) {
                state = state.pushContext(Context.ARGS);
                tokens.next();
                while (tokens.hasNext()) {
                    state = this.parseArg(state, tokens, arguments);
                }
            } else {
                state = this.parseArg(state, tokens, arguments);
            }
        }
        return state;
    }

    private ParseState parseArg(ParseState state, PeekingIterator<String> tokens, ArgumentsMetadata arguments) {
        state = arguments != null ? state.withArgument(TypeConverter.newInstance().convert(arguments.getTitle().get(0), arguments.getJavaType(), (String)tokens.next())) : state.withUnparsedInput((String)tokens.next());
        return state;
    }

    private OptionMetadata findOption(List<OptionMetadata> options, String param) {
        for (OptionMetadata optionMetadata : options) {
            if (!optionMetadata.getOptions().contains(param)) continue;
            return optionMetadata;
        }
        return null;
    }
}

