/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.collect.Lists;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.CommandGroupUsage;
import io.airlift.command.CommandUsage;
import io.airlift.command.GlobalUsage;
import io.airlift.command.GlobalUsageSummary;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Command(name="help", description="Display help information")
public class Help
implements Runnable,
Callable<Void> {
    public static boolean USAGE_AS_HTML = false;
    public static boolean USAGE_AS_RONN = false;
    public static boolean USAGE_AS_MD = false;
    @Inject
    @Nullable
    public GlobalMetadata global;
    @Arguments
    public List<String> command = Lists.newArrayList();

    @Override
    public void run() throws UnsupportedOperationException {
        Help.help(this.global, this.command);
    }

    @Override
    public Void call() throws UnsupportedOperationException {
        this.run();
        return null;
    }

    public static void help(CommandMetadata command) throws UnsupportedOperationException {
        StringBuilder stringBuilder = new StringBuilder();
        Help.help(command, stringBuilder);
        System.out.println(stringBuilder);
    }

    public static void help(CommandMetadata command, StringBuilder out) throws UnsupportedOperationException {
        new CommandUsage().usage(null, null, command.getName(), command, out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames) throws UnsupportedOperationException {
        StringBuilder stringBuilder = new StringBuilder();
        Help.help(global, commandNames, stringBuilder);
        System.out.println(stringBuilder);
    }

    public static void help(GlobalMetadata global, List<String> commandNames, StringBuilder out) throws UnsupportedOperationException {
        if (commandNames.isEmpty()) {
            new GlobalUsageSummary().usage(global, out);
            return;
        }
        String name = commandNames.get(0);
        if (name.equals(global.getName())) {
            if (USAGE_AS_HTML) {
                throw new UnsupportedOperationException("Global usage not supported in HTML format");
            }
            if (USAGE_AS_RONN) {
                throw new UnsupportedOperationException("Global usage not supported in RONN format");
            }
            if (USAGE_AS_MD) {
                out.append(new GlobalUsage().usageMD(global));
            } else {
                new GlobalUsage().usage(global, out);
            }
            return;
        }
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            if (!name.equals(command.getName())) continue;
            if (USAGE_AS_HTML) {
                out.append(new CommandUsage().usageHTML(global.getName(), null, command));
            } else if (USAGE_AS_RONN) {
                out.append(new CommandUsage().usageRonn(global.getName(), null, command));
            } else if (USAGE_AS_MD) {
                out.append(new CommandUsage().usageMD(global.getName(), null, command));
            } else {
                new CommandUsage().usage(global.getName(), null, command.getName(), command, out);
            }
            return;
        }
        for (CommandGroupMetadata group : global.getCommandGroups()) {
            if (!name.equals(group.getName())) continue;
            if (commandNames.size() == 1) {
                if (USAGE_AS_HTML) {
                    throw new UnsupportedOperationException("Command group usage not supported in HTML format");
                }
                if (USAGE_AS_RONN) {
                    throw new UnsupportedOperationException("Command group usage not supported in RONN format");
                }
                if (USAGE_AS_MD) {
                    out.append(new CommandGroupUsage().usageMD(global, group));
                } else {
                    new CommandGroupUsage().usage(global, group, out);
                }
                return;
            }
            String commandName = commandNames.get(1);
            for (CommandMetadata command : group.getCommands()) {
                if (!commandName.equals(command.getName())) continue;
                if (USAGE_AS_HTML) {
                    out.append(new CommandUsage().usageHTML(global.getName(), group.getName(), command));
                } else if (USAGE_AS_RONN) {
                    out.append(new CommandUsage().usageRonn(global.getName(), group.getName(), command));
                } else if (USAGE_AS_MD) {
                    out.append(new CommandUsage().usageMD(global.getName(), group.getName(), command));
                } else {
                    new CommandUsage().usage(global.getName(), group.getName(), command.getName(), command, out);
                }
                return;
            }
            throw new UnsupportedOperationException("Unknown command " + name + " " + commandName);
        }
        throw new UnsupportedOperationException("Unknown command " + name);
    }
}

