/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.command.UsageHelper;
import io.airlift.command.UsagePrinter;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

public class GlobalUsageSummary {
    private final int columnSize;

    public GlobalUsageSummary() {
        this(79);
    }

    public GlobalUsageSummary(int columnSize) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    public void usage(GlobalMetadata global) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(global, stringBuilder);
        System.out.println(stringBuilder);
    }

    public void usage(GlobalMetadata global, StringBuilder out) {
        this.usage(global, new UsagePrinter(out, this.columnSize));
    }

    public void usage(GlobalMetadata global, UsagePrinter out) {
        ArrayList commandArguments = Lists.newArrayList();
        Collection args = Collections2.transform(global.getOptions(), option -> {
            if (option.isHidden()) {
                return "";
            }
            return UsageHelper.toUsage(option);
        });
        commandArguments.addAll(args);
        out.newPrinterWithHangingIndent(8).append("usage:").append(global.getName()).appendWords(commandArguments).append("<command> [ <args> ]").newline().newline();
        TreeMap commands = Maps.newTreeMap();
        for (CommandMetadata commandMetadata : global.getDefaultGroupCommands()) {
            if (commandMetadata.isHidden()) continue;
            commands.put(commandMetadata.getName(), commandMetadata.getDescription());
        }
        for (CommandGroupMetadata commandGroupMetadata : global.getCommandGroups()) {
            commands.put(commandGroupMetadata.getName(), commandGroupMetadata.getDescription());
        }
        out.append("Commands are:").newline();
        out.newIndentedPrinter(4).appendTable(Iterables.transform(commands.entrySet(), entry -> ImmutableList.of((Object)((String)entry.getKey()), (Object)((String)MoreObjects.firstNonNull((Object)((String)entry.getValue()), (Object)"")))));
        out.newline();
        out.append("See").append("'" + global.getName()).append("help <command>' for more information on a specific command.").newline();
    }
}

