/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.command.UsageHelper;
import io.airlift.command.UsagePrinter;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;

public class GlobalUsage {
    private final int columnSize;
    private final Comparator<? super OptionMetadata> optionComparator;

    public GlobalUsage() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public GlobalUsage(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public GlobalUsage(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
        this.optionComparator = optionComparator;
    }

    public void usage(GlobalMetadata global) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(global, stringBuilder);
        System.out.println(stringBuilder);
    }

    public void usage(GlobalMetadata global, StringBuilder out) {
        this.usage(global, new UsagePrinter(out, this.columnSize));
    }

    public void usage(GlobalMetadata global, UsagePrinter out) {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(global.getName()).append("-").append(global.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        out.newIndentedPrinter(8).newPrinterWithHangingIndent(8).append(global.getName()).appendWords(UsageHelper.toSynopsisUsage(global.getOptions())).append("<command> [ <args> ]").newline().newline();
        ArrayList options = Lists.newArrayList(global.getOptions());
        if (!options.isEmpty()) {
            if (this.optionComparator != null) {
                options.sort(this.optionComparator);
            }
            out.append("OPTIONS").newline();
            for (OptionMetadata option : options) {
                if (option.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(UsageHelper.toDescription(option)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(option.getDescription()).newline();
                descriptionPrinter.newline();
            }
        }
        out.append("COMMANDS").newline();
        UsagePrinter commandPrinter = out.newIndentedPrinter(8);
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            this.printCommandDescription(commandPrinter, null, command);
        }
        for (CommandGroupMetadata group : global.getCommandGroups()) {
            for (CommandMetadata command : group.getCommands()) {
                this.printCommandDescription(commandPrinter, group, command);
            }
        }
    }

    private void printCommandDescription(UsagePrinter commandPrinter, @Nullable CommandGroupMetadata group, CommandMetadata command) {
        if (!command.isHidden()) {
            if (group != null) {
                commandPrinter.append(group.getName());
            }
            commandPrinter.append(command.getName()).newline();
            if (command.getDescription() != null) {
                commandPrinter.newIndentedPrinter(4).append(command.getDescription()).newline();
            }
            commandPrinter.newline();
        }
    }

    public String usageMD(GlobalMetadata global) {
        ImmutableList groups = ImmutableList.sortedCopyOf(Comparator.comparing(CommandGroupMetadata::getName), global.getCommandGroups());
        ImmutableList commands = ImmutableList.sortedCopyOf(Comparator.comparing(CommandMetadata::getName), global.getDefaultGroupCommands());
        StringBuilder builder = new StringBuilder();
        builder.append("---\n");
        builder.append("layout: default\n");
        String friendlyName = "stardog".equals(global.getName()) ? "Stardog CLI Reference" : ("stardog-admin".equals(global.getName()) ? "Stardog Admin CLI Reference" : global.getName());
        builder.append("title: ").append(friendlyName).append("\n");
        if (global.getNavOrder() != null) {
            builder.append("nav_order: ").append(global.getNavOrder()).append("\n");
        }
        builder.append("has_children: true\n");
        builder.append("has_toc: false\n");
        builder.append("description: This chapter contains details of all ").append(global.getName()).append(" CLI commands.\n");
        builder.append("---\n\n");
        builder.append("# ").append(friendlyName).append("\n");
        if (!Strings.isNullOrEmpty((String)global.getDescription())) {
            builder.append("\n");
            builder.append(global.getDescription());
            builder.append("\n");
        }
        if (!groups.isEmpty()) {
            builder.append("\n");
            builder.append("Below you'll find all command groups in the `").append(global.getName()).append("` client. Select any of the command groups in the table below to view the specific commands in that command group.");
            builder.append("\n\n");
            builder.append("| Command Group | Description |\n");
            builder.append("|---------------|-------------|\n");
            for (CommandGroupMetadata group : groups) {
                builder.append("| [`").append(group.getName()).append("`](./").append(group.getName()).append(") | ").append(group.getDescription()).append(" |\n");
            }
        }
        return builder.toString();
    }
}

