/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.command.UsageHelper;
import io.airlift.command.UsagePrinter;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class CommandUsage {
    private final int columnSize;
    private final Comparator<? super OptionMetadata> optionComparator;

    public CommandUsage() {
        this(79, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandUsage(int columnSize) {
        this(columnSize, UsageHelper.DEFAULT_OPTION_COMPARATOR);
    }

    public CommandUsage(int columnSize, @Nullable Comparator<? super OptionMetadata> optionComparator) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
        this.optionComparator = optionComparator;
    }

    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(programName, groupName, commandName, command, stringBuilder);
        System.out.println(stringBuilder);
    }

    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, StringBuilder out) {
        this.usage(programName, groupName, commandName, command, new UsagePrinter(out, this.columnSize));
    }

    public void usage(@Nullable String programName, @Nullable String groupName, String commandName, CommandMetadata command, UsagePrinter out) {
        out.append("NAME").newline();
        out.newIndentedPrinter(8).append(programName).append(groupName).append(commandName).append("-").append(command.getDescription()).newline().newline();
        out.append("SYNOPSIS").newline();
        UsagePrinter synopsis = out.newIndentedPrinter(8).newPrinterWithHangingIndent(8);
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            synopsis.append(programName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())));
            options.addAll(command.getGlobalOptions());
        }
        if (groupName != null) {
            synopsis.append(groupName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGroupOptions())));
            options.addAll(command.getGroupOptions());
        }
        synopsis.append(commandName).appendWords(UsageHelper.toSynopsisUsage(this.sortOptions(command.getCommandOptions())));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            synopsis.append("[--]").append(UsageHelper.toUsage(arguments));
        }
        synopsis.newline();
        synopsis.newline();
        if (!options.isEmpty() || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            out.append("OPTIONS").newline();
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append(UsageHelper.toDescription(optionMetadata)).newline();
                UsagePrinter descriptionPrinter = optionPrinter.newIndentedPrinter(4);
                descriptionPrinter.append(optionMetadata.getDescription()).newline();
                descriptionPrinter.newline();
            }
            if (arguments != null) {
                UsagePrinter optionPrinter = out.newIndentedPrinter(8);
                optionPrinter.append("--").newline();
                UsagePrinter usagePrinter = optionPrinter.newIndentedPrinter(4);
                usagePrinter.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options").newline();
                usagePrinter.newline();
                optionPrinter.append(UsageHelper.toDescription(arguments)).newline();
                usagePrinter.append(arguments.getDescription()).newline();
                usagePrinter.newline();
            }
        }
        if (command.getDiscussion() != null) {
            out.append("DISCUSSION").newline();
            UsagePrinter disc = out.newIndentedPrinter(8);
            disc.append(command.getDiscussion()).newline().newline();
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            out.append("EXAMPLES").newline();
            UsagePrinter ex = out.newIndentedPrinter(8);
            ex.appendTable(Iterables.partition(command.getExamples(), (int)1));
        }
    }

    private List<OptionMetadata> sortOptions(List<OptionMetadata> options) {
        if (this.optionComparator != null) {
            options = new ArrayList<OptionMetadata>(options);
            options.sort(this.optionComparator);
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    public String usageRonn(@Nullable String programName, @Nullable String groupName, CommandMetadata command) {
        List<OptionMetadata> aOptions;
        StringBuilder aBuilder = new StringBuilder();
        String NEW_PARA = "\n\n";
        aBuilder.append(programName).append("_");
        aBuilder.append(groupName).append("_");
        aBuilder.append(command.getName()).append(programName != null && programName.equals("stardog-admin") ? "(8) -" : "(1) -");
        String aDescription = command.getDescription();
        String aLongDesc = null;
        if (aBuilder.length() + aDescription.length() >= 255) {
            int aFirstPeriod = aDescription.indexOf(46);
            if (aFirstPeriod != -1) {
                String aShortDesc = aDescription.substring(0, aFirstPeriod + 1);
                if (aBuilder.length() + aShortDesc.length() < 255) {
                    aBuilder.append(aShortDesc).append("\n");
                }
            }
            aLongDesc = aDescription;
        } else {
            aBuilder.append(aDescription).append("\n");
        }
        aBuilder.append("==========");
        aBuilder.append("\n\n").append("## SYNOPSIS").append("\n\n");
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            aBuilder.append("`").append(programName).append("`");
            aOptions = command.getGlobalOptions();
            if (aOptions != null && !aOptions.isEmpty()) {
                aBuilder.append(" ").append(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        if (groupName != null) {
            aBuilder.append(" `").append(groupName).append("`");
            aOptions = command.getGroupOptions();
            if (aOptions != null && !aOptions.isEmpty()) {
                aBuilder.append(" ").append(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(aOptions))));
                options.addAll(aOptions);
            }
        }
        aOptions = command.getCommandOptions();
        aBuilder.append(" `").append(command.getName()).append("` ").append(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(aOptions))));
        options.addAll(aOptions);
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            aBuilder.append(" [--] ").append(UsageHelper.toUsage(arguments));
        }
        if (aLongDesc != null) {
            aBuilder.append("\n\n").append("## DESCRIPTION").append("\n\n").append(aLongDesc);
        }
        if (!options.isEmpty() || arguments != null) {
            aBuilder.append("\n\n").append("## OPTIONS");
            options = this.sortOptions((List<OptionMetadata>)options);
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                aBuilder.append("\n\n").append("* ").append(UsageHelper.toRonnDescription(optionMetadata)).append(":\n");
                aBuilder.append(optionMetadata.getDescription());
            }
            if (arguments != null) {
                aBuilder.append("\n\n").append("* --:\n");
                aBuilder.append("This option can be used to separate command-line options from the list of arguments (useful when arguments might be mistaken for command-line options).");
                aBuilder.append("\n\n").append("* ").append(UsageHelper.toDescription(arguments)).append(":\n");
                aBuilder.append(arguments.getDescription());
            }
        }
        if (command.getDiscussion() != null) {
            aBuilder.append("\n\n").append("## DISCUSSION").append("\n\n");
            aBuilder.append(command.getDiscussion());
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            aBuilder.append("\n\n").append("## EXAMPLES");
            for (int i = 0; i < command.getExamples().size(); i += 3) {
                void var12_18;
                String string = command.getExamples().get(i).trim();
                String aEx = CommandUsage.htmlize(command.getExamples().get(i + 1));
                if (string.startsWith("*")) {
                    String string2 = string.substring(1).trim();
                }
                aBuilder.append("\n\n").append("* ").append((String)var12_18).append(":\n");
                aBuilder.append(aEx);
            }
        }
        return aBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String usageHTML(@Nullable String programName, @Nullable String groupName, CommandMetadata command) {
        StringBuilder aBuilder = new StringBuilder();
        String NEWLINE = "<br/>\n";
        aBuilder.append("<html>\n");
        aBuilder.append("<head>\n");
        aBuilder.append("<link href=\"css/bootstrap.min.css\" rel=\"stylesheet\" media=\"screen\">\n");
        aBuilder.append("</head>\n");
        aBuilder.append("<style>\n    body { margin: 50px; }\n</style>\n");
        aBuilder.append("<body>\n");
        aBuilder.append("<hr/>\n");
        aBuilder.append("<h1 class=\"text-info\">").append(programName).append(" ").append(groupName).append(" ").append(command.getName()).append(" Manual Page\n");
        aBuilder.append("<hr/>\n");
        aBuilder.append("<h1 class=\"text-info\">NAME</h1>\n").append("<br/>\n");
        aBuilder.append("<div class=\"row\">");
        aBuilder.append("<div class=\"span8 offset1\">");
        aBuilder.append(programName).append(" ");
        aBuilder.append(groupName).append(" ");
        aBuilder.append(command.getName()).append(" ");
        aBuilder.append("&mdash;");
        aBuilder.append(CommandUsage.htmlize(command.getDescription()));
        aBuilder.append("</div>\n");
        aBuilder.append("</div>\n");
        aBuilder.append("<br/>\n");
        aBuilder.append("<h1 class=\"text-info\">SYNOPSIS</h1>\n").append("<br/>\n");
        List<Object> options = Lists.newArrayList();
        aBuilder.append("<div class=\"row\">\n");
        aBuilder.append("<div class=\"span8 offset1\">\n");
        if (programName != null) {
            aBuilder.append(programName).append(" ").append(CommandUsage.htmlize(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGlobalOptions())))));
            options.addAll(command.getGlobalOptions());
            aBuilder.append(" ");
        }
        if (groupName != null) {
            aBuilder.append(groupName).append(" ").append(CommandUsage.htmlize(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGroupOptions())))));
            options.addAll(command.getGroupOptions());
            aBuilder.append(" ");
        }
        aBuilder.append(command.getName()).append(" ").append(CommandUsage.htmlize(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(command.getCommandOptions())))));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            aBuilder.append(" [--] ").append(CommandUsage.htmlize(UsageHelper.toUsage(arguments)));
        }
        aBuilder.append("</div>\n");
        aBuilder.append("</div>\n");
        if (!options.isEmpty() || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            aBuilder.append("<br/>\n");
            aBuilder.append("<h1 class=\"text-info\">OPTIONS</h1>\n").append("<br/>\n");
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                aBuilder.append("<div class=\"row\">\n");
                aBuilder.append("<div class=\"span8 offset1\">\n");
                aBuilder.append(CommandUsage.htmlize(UsageHelper.toDescription(optionMetadata)));
                aBuilder.append("</div>\n");
                aBuilder.append("</div>\n");
                aBuilder.append("<div class=\"row\">\n");
                aBuilder.append("<div class=\"span8 offset2\">\n");
                aBuilder.append(CommandUsage.htmlize(optionMetadata.getDescription()));
                aBuilder.append("</div>\n");
                aBuilder.append("</div>\n");
            }
            if (arguments != null) {
                aBuilder.append("<div class=\"row\">\n");
                aBuilder.append("<div class=\"span8 offset1\">\n");
                aBuilder.append("--\n");
                aBuilder.append("</div>\n");
                aBuilder.append("</div>\n");
                aBuilder.append("<div class=\"row\">\n");
                aBuilder.append("<div class=\"span8 offset2\">\n");
                aBuilder.append("This option can be used to separate command-line options from the list of argument, (useful when arguments might be mistaken for command-line options\n");
                aBuilder.append("</div>\n");
                aBuilder.append("</div>\n");
                aBuilder.append("<div class=\"row\">\n");
                aBuilder.append("<div class=\"span8 offset1\">\n");
                aBuilder.append(CommandUsage.htmlize(UsageHelper.toDescription(arguments)));
                aBuilder.append("</div>\n");
                aBuilder.append("</div>\n");
                aBuilder.append("<div class=\"row\">\n");
                aBuilder.append("<div class=\"span8 offset2\">\n");
                aBuilder.append(CommandUsage.htmlize(arguments.getDescription()));
                aBuilder.append("</div>\n");
                aBuilder.append("</div>\n");
            }
        }
        if (command.getDiscussion() != null) {
            aBuilder.append("<br/>\n");
            aBuilder.append("<h1 class=\"text-info\">DISCUSSION</h1>\n").append("<br/>\n");
            aBuilder.append("<div class=\"row\">\n");
            aBuilder.append("<div class=\"span8 offset1\">\n");
            aBuilder.append(CommandUsage.htmlize(command.getDiscussion()));
            aBuilder.append("</div>\n");
            aBuilder.append("</div>\n");
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            aBuilder.append("<br/>\n");
            aBuilder.append("<h1 class=\"text-info\">EXAMPLES</h1>\n").append("<br/>\n");
            aBuilder.append("<div class=\"row\">\n");
            aBuilder.append("<div class=\"span12 offset1\">\n");
            for (int i = 0; i < command.getExamples().size(); i += 3) {
                void var9_14;
                String string = command.getExamples().get(i).trim();
                String aEx = CommandUsage.htmlize(command.getExamples().get(i + 1));
                if (string.startsWith("*")) {
                    String string2 = string.substring(1).trim();
                }
                aBuilder.append("<p>\n");
                aBuilder.append((String)var9_14);
                aBuilder.append("</p>\n");
                aBuilder.append("<pre>\n");
                aBuilder.append(aEx);
                aBuilder.append("</pre>\n");
            }
            aBuilder.append("</div>\n");
            aBuilder.append("</div>\n");
        }
        aBuilder.append("</body>\n");
        aBuilder.append("</html>\n");
        return aBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String usageMD(@Nullable String programName, @Nullable String groupName, CommandMetadata command) {
        StringBuilder aBuilder = new StringBuilder();
        aBuilder.append("---\n");
        aBuilder.append("layout: default\n");
        aBuilder.append("title: ").append(groupName).append(" ").append(command.getName()).append("\n");
        if ("stardog".equals(programName)) {
            aBuilder.append("grand_parent: ").append("Stardog CLI Reference\n");
        } else {
            aBuilder.append("grand_parent: ").append("Stardog Admin CLI Reference\n");
        }
        aBuilder.append("parent: ").append(groupName).append("\n");
        aBuilder.append("description: ").append("'").append(command.getDescription().replace("'", "")).append("'").append("\n");
        aBuilder.append("---\n\n");
        aBuilder.append("# ").append(" `").append(programName).append(" ").append(groupName).append(" ").append(command.getName()).append("` ").append("\n");
        aBuilder.append("## Description\n");
        aBuilder.append(command.getDescription()).append("\n");
        aBuilder.append("## Usage\n`");
        List<Object> options = Lists.newArrayList();
        if (programName != null) {
            aBuilder.append(programName).append(" ").append(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGlobalOptions()))));
            options.addAll(command.getGlobalOptions());
            aBuilder.append(" ");
        }
        if (groupName != null) {
            aBuilder.append(groupName).append(" ").append(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(command.getGroupOptions()))));
            options.addAll(command.getGroupOptions());
            aBuilder.append(" ");
        }
        aBuilder.append(command.getName()).append(" ").append(Joiner.on((String)" ").join(UsageHelper.toSynopsisUsage(this.sortOptions(command.getCommandOptions()))));
        options.addAll(command.getCommandOptions());
        ArgumentsMetadata arguments = command.getArguments();
        if (arguments != null) {
            aBuilder.append(" [--] ").append(UsageHelper.toUsage(arguments));
        }
        aBuilder.append("`\n{: .fs-5}\n");
        if (!options.isEmpty() || arguments != null) {
            options = this.sortOptions((List<OptionMetadata>)options);
            aBuilder.append("## Options\n\n");
            aBuilder.append("Name, shorthand | Description \n");
            aBuilder.append("---|---\n");
            for (OptionMetadata optionMetadata : options) {
                if (optionMetadata.isHidden()) continue;
                aBuilder.append("`");
                aBuilder.append(UsageHelper.toDescription(optionMetadata));
                aBuilder.append("` | ");
                aBuilder.append(optionMetadata.getDescription());
                aBuilder.append("\n");
            }
            if (arguments != null) {
                aBuilder.append("`--` | This option can be used to separate command-line options from the list of argument(s). (Useful when an argument might be mistaken for a command-line option)\n");
                aBuilder.append("`").append(UsageHelper.toDescription(arguments)).append("` | ");
                aBuilder.append(arguments.getDescription()).append("\n");
            }
        }
        if (command.getDiscussion() != null) {
            aBuilder.append("\n## Discussion\n").append(command.getDiscussion()).append("\n");
        }
        if (command.getExamples() != null && !command.getExamples().isEmpty()) {
            aBuilder.append("\n## Examples\n");
            for (int i = 0; i < command.getExamples().size(); i += 3) {
                void var8_13;
                String string = command.getExamples().get(i).trim();
                String aEx = command.getExamples().get(i + 1);
                if (string.startsWith("*")) {
                    String string2 = string.substring(1).trim();
                }
                aBuilder.append((String)var8_13).append("\n```bash\n").append(aEx).append("\n```\n");
            }
        }
        return aBuilder.toString();
    }

    private static String htmlize(String theStr) {
        return theStr.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br/>");
    }
}

