/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.command.CommandFactory;
import io.airlift.command.CommandFactoryDefault;
import io.airlift.command.Context;
import io.airlift.command.ParseArgumentsMissingException;
import io.airlift.command.ParseArgumentsUnexpectedException;
import io.airlift.command.ParseCommandMissingException;
import io.airlift.command.ParseCommandUnrecognizedException;
import io.airlift.command.ParseGlobalOptionUnexpectedException;
import io.airlift.command.ParseOptionMissingException;
import io.airlift.command.ParseOptionMissingValueException;
import io.airlift.command.ParseState;
import io.airlift.command.Parser;
import io.airlift.command.ParserUtil;
import io.airlift.command.TypeConverter;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.MetadataLoader;
import io.airlift.command.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Cli<C> {
    private final GlobalMetadata metadata;
    private final CommandFactory<C> mCommandFactory;

    public static <T> CliBuilder<T> builder(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        return new CliBuilder(name);
    }

    @Deprecated
    public static CliBuilder<Object> buildCli(String name) {
        return Cli.builder(name);
    }

    @Deprecated
    public static <T> CliBuilder<T> buildCli(String name, Class<T> commandTypes) {
        return Cli.builder(name);
    }

    private Cli(String name, Integer navOrder, String description, TypeConverter typeConverter, Class<? extends C> defaultCommand, CommandFactory<C> theCommandFactory, Iterable<Class<? extends C>> defaultGroupCommands, Iterable<GroupBuilder<C>> groups) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)typeConverter, (Object)"typeConverter is null");
        Preconditions.checkNotNull(theCommandFactory);
        this.mCommandFactory = theCommandFactory;
        CommandMetadata defaultCommandMetadata = null;
        if (defaultCommand != null) {
            defaultCommandMetadata = MetadataLoader.loadCommand(defaultCommand);
        }
        ArrayList<CommandMetadata> allCommands = new ArrayList<CommandMetadata>();
        ArrayList defaultCommandGroup = Lists.newArrayList(MetadataLoader.loadCommands(defaultGroupCommands));
        allCommands.addAll(defaultCommandGroup);
        ArrayList commandGroups = Lists.newArrayList((Iterable)Iterables.transform(groups, group -> {
            CommandMetadata groupDefault = MetadataLoader.loadCommand(((GroupBuilder)group).defaultCommand);
            ImmutableList<CommandMetadata> groupCommands = MetadataLoader.loadCommands(((GroupBuilder)group).commands);
            allCommands.addAll((Collection<CommandMetadata>)groupCommands);
            return MetadataLoader.loadCommandGroup(((GroupBuilder)group).name, ((GroupBuilder)group).description, ((GroupBuilder)group).markdownDescription, groupDefault, groupCommands);
        }));
        MetadataLoader.loadCommandsIntoGroupsByAnnotation(allCommands, commandGroups, defaultCommandGroup);
        this.metadata = MetadataLoader.loadGlobal(name, navOrder, description, defaultCommandMetadata, (Iterable<CommandMetadata>)ImmutableList.copyOf((Collection)defaultCommandGroup), (Iterable<CommandGroupMetadata>)ImmutableList.copyOf((Collection)commandGroups));
    }

    public GlobalMetadata getMetadata() {
        return this.metadata;
    }

    public C parse(CommandFactory<C> commandFactory, String ... args) {
        return this.parse(commandFactory, (Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(String ... args) {
        return this.parse(this.mCommandFactory, (Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(Iterable<String> args) {
        return this.parse(this.mCommandFactory, args);
    }

    public C parse(CommandFactory<C> commandFactory, Iterable<String> args) {
        Preconditions.checkNotNull(args, (Object)"args is null");
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, args);
        if (state.getCommand() == null) {
            state = state.getGroup() != null ? state.withCommand(state.getGroup().getDefaultCommand()) : state.withCommand(this.metadata.getDefaultCommand());
        }
        this.validate(state);
        CommandMetadata command = state.getCommand();
        ImmutableMap.Builder bindings = ImmutableMap.builder().put(GlobalMetadata.class, (Object)this.metadata);
        if (state.getGroup() != null) {
            bindings.put(CommandGroupMetadata.class, (Object)state.getGroup());
        }
        if (state.getCommand() != null) {
            bindings.put(CommandMetadata.class, (Object)state.getCommand());
        }
        return ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), bindings.build(), commandFactory);
    }

    public C parse(C commandInstance, String ... args) {
        Preconditions.checkNotNull((Object)args, (Object)"args is null");
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, args);
        CommandMetadata command = MetadataLoader.loadCommand(commandInstance.getClass());
        state = state.withCommand(command);
        this.validate(state);
        ImmutableMap.Builder bindings = ImmutableMap.builder().put(GlobalMetadata.class, (Object)this.metadata);
        if (state.getGroup() != null) {
            bindings.put(CommandGroupMetadata.class, (Object)state.getGroup());
        }
        bindings.put(CommandMetadata.class, (Object)command);
        return ParserUtil.injectOptions(commandInstance, command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), bindings.build());
    }

    private void validate(ParseState state) {
        CommandMetadata command = state.getCommand();
        if (command == null) {
            List<String> unparsedInput = state.getUnparsedInput();
            if (unparsedInput.isEmpty()) {
                throw new ParseCommandMissingException();
            }
            throw new ParseCommandUnrecognizedException(unparsedInput);
        }
        ArgumentsMetadata arguments = command.getArguments();
        if (state.getParsedArguments().isEmpty() && arguments != null && arguments.isRequired()) {
            throw new ParseArgumentsMissingException(arguments.getTitle());
        }
        if (!state.getUnparsedInput().isEmpty()) {
            throw new ParseArgumentsUnexpectedException(state.getUnparsedInput());
        }
        if (state.getLocation() == Context.OPTION) {
            throw new ParseOptionMissingValueException(state.getCurrentOption().getTitle());
        }
        for (OptionMetadata option : command.getAllOptions()) {
            if (!option.isRequired() || state.getParsedOptions().containsKey((Object)option)) continue;
            throw new ParseOptionMissingException(option.getOptions().iterator().next());
        }
        for (OptionMetadata optionMetadata : state.getParsedOptions().keys()) {
            List<OptionMetadata> allOptions = command.getAllOptions();
            if (allOptions.contains(optionMetadata)) continue;
            throw new ParseGlobalOptionUnexpectedException(optionMetadata);
        }
    }

    public static class GroupBuilder<C> {
        private final String name;
        private String description = null;
        private String markdownDescription = null;
        private Class<? extends C> defaultCommand = null;
        private final List<Class<? extends C>> commands = Lists.newArrayList();

        private GroupBuilder(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            this.name = name;
        }

        public GroupBuilder<C> withDescription(String description) {
            Preconditions.checkNotNull((Object)description, (String)"description for group %s is null", (Object)this.name);
            Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (String)"description for group %s is empty", (Object)this.name);
            Preconditions.checkState((this.description == null ? 1 : 0) != 0, (String)"description for group %s is already set to %s", (Object)this.name, (Object)this.description);
            this.description = description;
            return this;
        }

        public GroupBuilder<C> withMarkdownDescription(String markdownDescription) {
            Preconditions.checkNotNull((Object)markdownDescription, (String)"markdown description for group %s is null", (Object)this.name);
            Preconditions.checkArgument((!markdownDescription.isEmpty() ? 1 : 0) != 0, (String)"markdown description for group %s is empty", (Object)this.name);
            Preconditions.checkState((this.markdownDescription == null ? 1 : 0) != 0, (String)"markdown description for group %s is already set to %s", (Object)this.name, (Object)this.markdownDescription);
            this.markdownDescription = markdownDescription;
            return this;
        }

        public GroupBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
            Preconditions.checkNotNull(defaultCommand, (String)"defaultCommand for group %s is null", (Object)this.name);
            String existingName = this.defaultCommand == null ? null : this.defaultCommand.getName();
            Preconditions.checkState((this.defaultCommand == null ? 1 : 0) != 0, (String)"defaultCommand for group %s is already set to %s", (Object)this.name, (Object)existingName);
            this.defaultCommand = defaultCommand;
            return this;
        }

        public GroupBuilder<C> withCommand(Class<? extends C> command) {
            Preconditions.checkNotNull(command, (String)"command for group %s is null", (Object)this.name);
            this.commands.add(command);
            return this;
        }

        @SafeVarargs
        public final GroupBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
            this.commands.add(command);
            this.commands.addAll((Collection<Class<C>>)ImmutableList.copyOf((Object[])moreCommands));
            return this;
        }

        public GroupBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
            this.commands.addAll((Collection<Class<C>>)ImmutableList.copyOf(commands));
            return this;
        }
    }

    public static class CliBuilder<C> {
        protected final String name;
        protected Integer navOrder;
        protected String description;
        protected TypeConverter typeConverter = new TypeConverter();
        protected String optionSeparators;
        private Class<? extends C> defaultCommand;
        private final List<Class<? extends C>> defaultCommandGroupCommands = Lists.newArrayList();
        protected final Map<String, GroupBuilder<C>> groups = Maps.newHashMap();
        protected CommandFactory<C> commandFactory = new CommandFactoryDefault<C>();

        public CliBuilder(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            this.name = name;
        }

        public CliBuilder<C> withNavOrder(Integer navOrder) {
            Preconditions.checkNotNull((Object)navOrder, (String)"nav_order for CLI %s is null", (Object)this.name);
            Preconditions.checkState((this.navOrder == null ? 1 : 0) != 0, (String)"nav_order for CLI %s is already set to %s", (Object)this.name, (Object)this.navOrder);
            this.navOrder = navOrder;
            return this;
        }

        public CliBuilder<C> withDescription(String description) {
            Preconditions.checkNotNull((Object)description, (String)"description for CLI %s is null", (Object)this.name);
            Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (String)"description for CLI %s is empty", (Object)this.name);
            Preconditions.checkState((this.description == null ? 1 : 0) != 0, (String)"description for CLI %s is already set to %s", (Object)this.name, (Object)this.description);
            this.description = description;
            return this;
        }

        public CliBuilder<C> withCommandFactory(CommandFactory<C> commandFactory) {
            this.commandFactory = commandFactory;
            return this;
        }

        public CliBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
            this.defaultCommand = defaultCommand;
            return this;
        }

        public CliBuilder<C> withCommand(Class<? extends C> command) {
            this.defaultCommandGroupCommands.add(command);
            return this;
        }

        @SafeVarargs
        public final CliBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
            this.defaultCommandGroupCommands.add(command);
            this.defaultCommandGroupCommands.addAll((Collection<Class<C>>)ImmutableList.copyOf((Object[])moreCommands));
            return this;
        }

        public CliBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
            this.defaultCommandGroupCommands.addAll((Collection<Class<C>>)ImmutableList.copyOf(commands));
            return this;
        }

        public GroupBuilder<C> withGroup(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            if (this.groups.containsKey(name)) {
                return this.groups.get(name);
            }
            GroupBuilder group = new GroupBuilder(name);
            this.groups.put(name, group);
            return group;
        }

        public GroupBuilder<C> getGroup(String theName) {
            Preconditions.checkNotNull((Object)theName, (Object)"name is null");
            Preconditions.checkArgument((!theName.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            Preconditions.checkArgument((boolean)this.groups.containsKey(theName), (String)"Group %s has not been declared", (Object)theName);
            return this.groups.get(theName);
        }

        public Cli<C> build() {
            return new Cli(this.name, this.navOrder, this.description, this.typeConverter, this.defaultCommand, this.commandFactory, this.defaultCommandGroupCommands, this.groups.values());
        }
    }
}

