/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DelegatingAdminConnection;
import com.complexible.stardog.protocols.http.JSON;
import com.complexible.stardog.protocols.http.client.AdminConnectionImpl;
import com.complexible.stardog.protocols.http.client.HttpAdminClientImpl;
import com.complexible.stardog.protocols.http.shared.virtual.VirtualAdminProtocolConsts;
import com.complexible.stardog.virtual.api.admin.ComputeAdminConnection;
import com.complexible.stardog.virtual.api.admin.VirtualGraphAdminConnection;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.ContentType;

public class HttpComputeAdminConnectionImpl
extends DelegatingAdminConnection
implements ComputeAdminConnection,
VirtualAdminProtocolConsts {
    protected final HttpAdminClientImpl mClient;
    public static final ContentType TEXT_PLAIN_UTF_8 = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)StandardCharsets.UTF_8);
    public static final ContentType MAPPING_SMS2 = ContentType.create((String)"application/mapping+sms", (Charset)StandardCharsets.UTF_8);

    protected HttpComputeAdminConnectionImpl(AdminConnectionImpl theConnection) {
        super((AdminConnection)theConnection);
        this.mClient = (HttpAdminClientImpl)theConnection.getClient();
    }

    public void importGraph(String theDatabase, @Nullable String theDataSource, Properties theProps, String theMappings, String theNamedGraph, String thePartitionColumn, String theComputeSource, boolean theRemoveAll) {
        JsonObject payload = new JsonObject();
        payload.addProperty("db", theDatabase);
        payload.addProperty("data_source", theDataSource);
        payload.add("options", (JsonElement)JSON.toJson((Object)theProps));
        payload.addProperty("mappings", theMappings);
        payload.addProperty("named_graph", theNamedGraph);
        payload.addProperty("compute_source", theComputeSource);
        payload.addProperty("remove_all", Boolean.valueOf(theRemoveAll));
        if (thePartitionColumn != null) {
            payload.addProperty("partition_column", thePartitionColumn);
        }
        this.mClient.executeHttpPost("virtual_graphs_compute/import_db", payload);
    }

    public void importFile(String theDatabase, String theMappings, Properties theProps, String theNamedGraph, String theInputFile, VirtualGraphAdminConnection.InputFileType fileType, String theComputeSource) {
        JsonObject payload = new JsonObject();
        payload.addProperty("db", theDatabase);
        payload.add("options", (JsonElement)JSON.toJson((Object)theProps));
        payload.addProperty("mappings", theMappings);
        payload.addProperty("named_graph", theNamedGraph);
        payload.addProperty("compute_source", theComputeSource);
        payload.addProperty("input_file", theInputFile);
        payload.addProperty("input_file_type", fileType.name());
        this.mClient.executeHttpPost("virtual_graphs_compute/import", payload);
    }
}

