/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.Template;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.impl.TermMapImpl;
import java.util.HashSet;
import java.util.Set;

public class ObjectMapImpl
extends TermMapImpl
implements ObjectMap {
    String langTag;
    Object dataType;

    public ObjectMapImpl(LibConfiguration c, TermMap.TermMapType termMapType, Template template) {
        super(c, termMapType, template);
    }

    public ObjectMapImpl(LibConfiguration c, TermMap.TermMapType termMapType, String columnOrConst) {
        super(c, termMapType, columnOrConst);
    }

    @Override
    public void setTermType(Object typeURI) {
        if (typeURI != null && !this.lc.getResourceClass().isInstance(typeURI)) {
            throw new IllegalArgumentException("Parameter typeURI is of type " + String.valueOf(typeURI.getClass()) + ". Should be an instance of " + String.valueOf(this.lc.getResourceClass()) + ".");
        }
        if (typeURI.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#IRI")) || typeURI.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#BlankNode")) || typeURI.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#Literal"))) {
            this.termtype = typeURI;
            if (!typeURI.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#Literal"))) {
                this.removeLanguageTag();
                this.removeDatatype();
            }
        } else {
            throw new IllegalArgumentException("The typeIRI is not a valid term type IRI for an ObjectMap.");
        }
    }

    @Override
    public void setDefaultTermType() {
        this.termtype = this.type == TermMap.TermMapType.COLUMN_VALUED || this.langTag != null || this.dataType != null ? this.lc.createResource("http://www.w3.org/ns/r2rml#Literal") : this.lc.createResource("http://www.w3.org/ns/r2rml#IRI");
    }

    @Override
    public void setLanguageTag(String lang) {
        if (!this.termtype.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#Literal"))) {
            throw new IllegalStateException("The term type is " + String.valueOf(this.termtype) + ". Should be http://www.w3.org/ns/r2rml#Literal.");
        }
        this.removeDatatype();
        this.langTag = lang;
    }

    @Override
    public void setDatatype(Object datatypeURI) {
        if (datatypeURI != null && !this.lc.getResourceClass().isInstance(datatypeURI)) {
            throw new IllegalArgumentException("Parameter datatypeURI is of type " + String.valueOf(datatypeURI.getClass()) + ". Should be an instance of " + String.valueOf(this.lc.getResourceClass()) + ".");
        }
        if (!this.termtype.equals(this.lc.createResource("http://www.w3.org/ns/r2rml#Literal"))) {
            throw new IllegalStateException("The term type is " + String.valueOf(this.termtype) + ". Should be http://www.w3.org/ns/r2rml#Literal.");
        }
        this.dataType = datatypeURI;
        this.removeLanguageTag();
    }

    @Override
    public String getLanguageTag() {
        return this.langTag;
    }

    @Override
    public <R> R getDatatype(Class<R> resourceClass) {
        return resourceClass.cast(this.dataType);
    }

    @Override
    public void removeDatatype() {
        this.dataType = null;
    }

    @Override
    public void removeLanguageTag() {
        this.langTag = null;
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.addAll(super.serialize(tripleClass));
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#ObjectMap"))));
        if (this.dataType != null) {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#datatype"), this.dataType)));
        } else if (this.langTag != null) {
            stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#language"), this.langTag)));
        }
        return stmtSet;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.langTag == null ? 0 : this.langTag.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectMapImpl)) {
            return false;
        }
        ObjectMapImpl other = (ObjectMapImpl)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        return !(this.langTag == null ? other.langTag != null : !this.langTag.equals(other.langTag));
    }

    @Override
    public String toString() {
        return "ObjectMapImpl [langTag=" + this.langTag + ", dataType=" + String.valueOf(this.dataType) + ", type=" + String.valueOf((Object)this.type) + ", termtype=" + String.valueOf(this.termtype) + ", template=" + String.valueOf(this.template) + ", constVal=" + this.constVal + ", columnName=" + this.columnName + ", inverseExp=" + String.valueOf(this.inverseExp) + ", res=" + String.valueOf(this.res) + "]";
    }
}

