/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.complexible.common.base.PropertiesBuilder;
import com.complexible.stardog.metadata.TextIO;
import com.complexible.stardog.virtual.api.VirtualGraphMappingSyntax;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class VirtualGraphOptions {
    public static final String BASE_URI = "base";
    public static final String NAMESPACES = "namespaces";
    public static final String DEFAULT_MAPPING_INCLUDE_TABLES = "default.mapping.include.tables";
    public static final String DEFAULT_MAPPING_EXCLUDE_TABLES = "default.mapping.exclude.tables";
    public static final String CSV_SEPARATOR = "csv.separator";
    public static final String CSV_QUOTE = "csv.quote";
    public static final String CSV_ESCAPE = "csv.escape";
    public static final String CSV_HEADER = "csv.header";
    public static final String CSV_SKIP_EMPTY = "csv.skip.empty";
    public static final String CSV_HASH_FUNCTION = "csv.hash.function";
    public static final String CSV_CLASS = "csv.class";
    public static final String PERCENT_ENCODE = "percent.encode";
    public static final String SCHEMA_IN_GENERATED_MAPPINGS = "schema.in.generated.mappings";
    public static final String UNION_STRATEGY = "union.strategy";
    public static final String CHARSET_HANDLING = "charset.handling";
    public static final String PARSER_SQL_QUOTING = "parser.sql.quoting";
    public static final String PARSER_QUOTING_ANSI = "ANSI";
    public static final String SQL_FUNCTIONS = "sql.functions";
    public static final String MAPPINGS_SYNTAX = "mappings.syntax";
    public static final String VG_OPTION_R2RML = "mappings.syntax=" + String.valueOf((Object)VirtualGraphMappingSyntax.R2RML);
    public static final Properties VG_OPTIONS_R2RML = PropertiesBuilder.propertiesFromString((String)VG_OPTION_R2RML);
    public static final String MAPPINGS_FORMAT = "mappings.format";
    public static final String EXPLAIN_FORMAT = "explain.format";
    public static final String ALLOW_UNAVAILABLE = "unavailable.allow";
    public static final String FORCE_UNAVAILABLE = "unavailable.force";
    public static final String ALLOW_INVALID_NAME = "invalid.name.allow";
    public static final String ALLOW_REF_OBJECT_MAP_LEFT_JOIN = "allow.ref.object.map.left.join";
    public static final String VG_RESULT_BATCH_SIZE = "vg.result.batch.size";

    public static NamespacesImpl getNamespacesOption(Properties options) {
        String aNS = options.getProperty(NAMESPACES);
        return new NamespacesImpl((Iterable)(aNS == null ? Namespaces.DEFAULT : (Iterable)TextIO.forSet(Namespace.class).read(aNS)));
    }

    public static void setNamespacesOption(Properties options, Namespaces namespaces) {
        String namespacesString = TextIO.forSet(Namespace.class).write((Object)StreamSupport.stream(namespaces.spliterator(), false).sorted().collect(Collectors.toList()));
        options.setProperty(NAMESPACES, namespacesString);
    }

    public static boolean isAllowUnavailable(Properties options) {
        return Boolean.parseBoolean(options.getProperty(ALLOW_UNAVAILABLE, "false"));
    }

    public static boolean isForceUnavailable(Properties options) {
        return Boolean.parseBoolean(options.getProperty(FORCE_UNAVAILABLE, "false"));
    }

    public static boolean isPercentEncode(Properties options) {
        return Boolean.parseBoolean(options.getProperty(PERCENT_ENCODE, "true"));
    }

    public static boolean isCharsetHandling(Properties options) {
        return Boolean.parseBoolean(options.getProperty(CHARSET_HANDLING, "true"));
    }

    public static String getBaseUriOption(Properties options) {
        return options.getProperty(BASE_URI, "http://api.stardog.com/");
    }

    public static boolean isSchemaInIris(Properties options, boolean defaultValue) {
        return Boolean.parseBoolean(options.getProperty(SCHEMA_IN_GENERATED_MAPPINGS, Boolean.toString(defaultValue)));
    }

    public static int getResultBatchSize(Properties options) {
        return Integer.parseInt(options.getProperty(VG_RESULT_BATCH_SIZE, "1024"));
    }

    public static boolean isParserQuotingAnsi(Properties options) {
        return PARSER_QUOTING_ANSI.equalsIgnoreCase(options.getProperty(PARSER_SQL_QUOTING));
    }

    public static IRI getSubjectClass(Properties options) {
        String subjectClass = options.getProperty(CSV_CLASS);
        return subjectClass == null ? null : Values.iri((String)subjectClass);
    }
}

