/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.complexible.common.io.block.BlockMarker;
import com.complexible.common.io.block.BlockSpec;
import com.complexible.common.io.block.Bracket;
import com.complexible.common.io.block.TextBlockWriter;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.stardog.virtual.api.JoinConditionOptimizer;
import com.complexible.stardog.virtual.api.StardogMappingVocabulary;
import com.google.common.collect.Maps;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.turtle.TurtleUtil;
import com.stardog.stark.vocabs.RDF;
import eu.optique.api.mapping.GraphMap;
import eu.optique.api.mapping.LogicalTable;
import eu.optique.api.mapping.MappingFactory;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.PredicateMap;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.R2RMLMappingManager;
import eu.optique.api.mapping.SQLTable;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.TriplesMap;
import eu.optique.api.mapping.impl.InvalidR2RMLMappingException;
import eu.optique.api.mapping.impl.sesame.SesameR2RMLMappingManagerFactory;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StardogMappingSyntaxWriter {
    private static final R2RMLMappingManager MANAGER = new SesameR2RMLMappingManagerFactory().getR2RMLMappingManager();
    private static final MappingFactory FACTORY = MANAGER.getMappingFactory();
    private static final BlockSpec BLOCK = BlockSpec.INDENTED.copy().newLineAfterBegin(true);
    private static final BlockSpec BNODE_BLOCK = BLOCK.copy().marker((BlockMarker)Bracket.SQUARE);
    private static final BlockSpec GRAPH_BLOCK = BLOCK.copy().marker((BlockMarker)Bracket.CURLY);
    private TurtleValueWriter mTurtleWriter;
    private Map<String, String> mPrefixes;
    private TextBlockWriter mOut;

    public void write(Set<Statement> theModel, Namespaces theNamespaces, OutputStream theWriter) throws InvalidR2RMLMappingException {
        this.mOut = new TextBlockWriter((Writer)new PrintWriter(theWriter));
        this.mTurtleWriter = new TurtleValueWriter((Iterable)theNamespaces);
        this.mPrefixes = Maps.newHashMap();
        for (Namespace aNamespace : theNamespaces) {
            this.writeNamespace(aNamespace);
            this.mPrefixes.put(aNamespace.iri(), aNamespace.prefix());
        }
        Collection<TriplesMap> aTriplesMaps = MANAGER.importMappings(theModel);
        JoinConditionOptimizer.optimizeJoinConditions(aTriplesMaps);
        for (TriplesMap aTriplesMap : aTriplesMaps) {
            this.writeTriplesMapGraphs(aTriplesMap);
        }
        this.mOut.flush();
    }

    private void writeNamespace(Namespace theNamespace) {
        this.mOut.write("@prefix ");
        this.mOut.write(theNamespace.prefix());
        this.mOut.write(": <");
        this.mOut.write(TurtleUtil.encodeURIString((String)theNamespace.iri()));
        this.mOut.write("> .");
        this.mOut.println();
    }

    private void writeTriplesMapGraphs(TriplesMap theTriplesMap) {
        List<GraphMap> aGraphMaps = theTriplesMap.getSubjectMap().getGraphMaps();
        if (aGraphMaps.isEmpty()) {
            this.writeTriplesMap(theTriplesMap);
        } else {
            for (GraphMap aGraphMap : aGraphMaps) {
                this.writeTermMap(aGraphMap);
                this.mOut.write(" ");
                this.mOut.beginBlock(GRAPH_BLOCK);
                this.writeTriplesMap(theTriplesMap);
                this.mOut.endBlock();
            }
        }
        this.mOut.println();
    }

    private void writeTriplesMap(TriplesMap theTriplesMap) {
        SubjectMap aSubjectMap = theTriplesMap.getSubjectMap();
        this.writeTermMap(aSubjectMap);
        this.mOut.beginBlock(BLOCK);
        this.writeSubjectMap(aSubjectMap);
        for (PredicateObjectMap aPredicateObjectMap : theTriplesMap.getPredicateObjectMaps()) {
            this.writePredicateObjectMap(aPredicateObjectMap);
        }
        this.writeLogicalTable(theTriplesMap.getLogicalTable());
        this.mOut.endBlock();
        this.mOut.println(" .");
    }

    private void writeLogicalTable(LogicalTable theLogicalTable) {
        String aValue;
        this.writeURI(StardogMappingVocabulary.MAP);
        this.mOut.printSpace();
        this.mOut.beginBlock(BNODE_BLOCK);
        if (theLogicalTable instanceof SQLTable) {
            this.writeURI(StardogMappingVocabulary.TABLE);
            aValue = ((SQLTable)theLogicalTable).getSQLTableName();
        } else {
            this.writeURI(StardogMappingVocabulary.QUERY);
            aValue = theLogicalTable.getSQLQuery();
        }
        this.mOut.print(" ");
        this.writeLiteral(aValue);
        this.mOut.println(" ;");
        this.mOut.endBlock();
    }

    private void writeSubjectMap(SubjectMap theSubjectMap) {
        List<IRI> aClasses = theSubjectMap.getClasses(IRI.class);
        for (IRI aClass : aClasses) {
            this.writeURI(RDF.TYPE);
            this.mOut.printSpace();
            this.writeURI(aClass);
            this.mOut.printSpace();
            this.mOut.println(";");
        }
    }

    private void writePredicateObjectMap(PredicateObjectMap thePredicateObjectMap) {
        if (!thePredicateObjectMap.getRefObjectMaps().isEmpty()) {
            throw new UnsupportedOperationException("Unsupported join condition");
        }
        for (PredicateMap aPredicateMap : thePredicateObjectMap.getPredicateMaps()) {
            for (ObjectMap aObjectMap : thePredicateObjectMap.getObjectMaps()) {
                this.writeTermMap(aPredicateMap);
                this.mOut.printSpace();
                this.writeTermMap(aObjectMap);
                this.mOut.printSpace();
                this.mOut.println(";");
            }
        }
    }

    private void writeTermMap(TermMap theTermMap) {
        IRI aTermType = theTermMap.getTermType(IRI.class);
        String aTermString = this.getTermString(theTermMap);
        if (aTermType.toString().equals("http://www.w3.org/ns/r2rml#IRI")) {
            this.writeURI(aTermString);
        } else if (aTermType.toString().equals("http://www.w3.org/ns/r2rml#BlankNode")) {
            this.mOut.print("_:" + aTermString);
        } else if (aTermType.toString().equals("http://www.w3.org/ns/r2rml#Literal")) {
            this.writeLiteral(aTermString);
            ObjectMap aObjectMap = (ObjectMap)theTermMap;
            String aLang = aObjectMap.getLanguageTag();
            IRI aDatatype = aObjectMap.getDatatype(IRI.class);
            if (aLang != null) {
                this.mOut.print("@" + aLang);
            } else if (aDatatype != null) {
                this.mOut.print("^^");
                this.writeURI(aDatatype);
            }
        }
    }

    private String getTermString(TermMap theTermMap) {
        switch (theTermMap.getTermMapType()) {
            case TEMPLATE_VALUED: {
                return theTermMap.getTemplateString();
            }
            case COLUMN_VALUED: {
                return "{" + theTermMap.getColumn() + "}";
            }
            case CONSTANT_VALUED: {
                return theTermMap.getConstant();
            }
        }
        throw new IllegalArgumentException();
    }

    private void writeURI(String theStr) {
        try {
            this.writeURI(Values.iri((String)theStr));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mOut.print("<" + theStr + ">");
        }
    }

    private void writeLiteral(String theStr) {
        this.mOut.print(this.mTurtleWriter.write((Value)Values.literal((String)theStr)));
    }

    private void writeURI(IRI theStr) {
        String aLocalName = theStr.localName();
        String aNamespace = theStr.namespace();
        String aPrefix = this.mPrefixes.get(aNamespace);
        if (aPrefix != null) {
            this.mOut.print(aPrefix + ":" + aLocalName);
        } else {
            this.mOut.print(this.mTurtleWriter.write((Value)theStr));
        }
    }
}

