/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.virtual.api;

import com.complexible.common.base.Options;
import com.complexible.common.base.Pair;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.stardog.index.IndexOrder;
import com.complexible.stardog.virtual.api.StardogMappingVocabulary;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.stardog.stark.BNode;
import com.stardog.stark.Graphs;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.StatementPattern;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlers;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.turtle.TurtleUtil;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import com.stardog.stark.vocabs.XSD;
import eu.optique.api.mapping.GraphMap;
import eu.optique.api.mapping.LogicalTable;
import eu.optique.api.mapping.MappingFactory;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.PredicateMap;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.R2RMLMappingManager;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.Template;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.TriplesMap;
import eu.optique.api.mapping.impl.sesame.SesameR2RMLMappingManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StardogMappingSyntaxParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StardogMappingSyntaxParser.class);
    private static final R2RMLMappingManager MANAGER = new SesameR2RMLMappingManagerFactory().getR2RMLMappingManager();
    private static final MappingFactory FACTORY = MANAGER.getMappingFactory();
    private static final IRI STRING_TYPE = RDFS.LITERAL;
    private final String mSeparator;
    private final List<String> mColumns = Lists.newArrayList();

    public StardogMappingSyntaxParser() {
        this("__");
    }

    public StardogMappingSyntaxParser(String theSep) {
        this.mSeparator = theSep;
    }

    public Set<Statement> parse(InputStream theInput, RDFFormat theFormat) throws IOException {
        return (Set)this.parse(new InputStreamReader(theInput, Charsets.UTF_8), theFormat).second();
    }

    public Pair<Namespaces, Set<Statement>> parse(Reader theInput, RDFFormat theFormat) throws IOException {
        return this.parse(CharStreams.toString((Readable)theInput), theFormat);
    }

    public Pair<Namespaces, Set<Statement>> parse(String theInput, RDFFormat theFormat) throws IOException {
        String aEscapedStr = this.preprocessTemplate(theInput);
        LOGGER.debug("Escaped input: {}", (Object)aEscapedStr);
        RDFHandlers.GraphBuilder graphBuilder = RDFHandlers.toGraph();
        RDFParsers.read((InputStream)new ByteArrayInputStream(aEscapedStr.getBytes()), (RDFFormat)theFormat, (Options)ParserConfigs.lax(), (RDFHandler)graphBuilder);
        Set aInputModel = graphBuilder.graph();
        ArrayList aTriplesMaps = Lists.newArrayList();
        aInputModel.stream().filter(stmt -> stmt.predicate().equals((Object)StardogMappingVocabulary.MAP)).map(aStatement -> {
            LogicalTable aTable = this.getLogicalTable(aInputModel, (Statement)aStatement);
            return this.createTriplesMap(aInputModel, aStatement.subject(), aTable);
        }).forEach(aTriplesMaps::add);
        if (aTriplesMaps.isEmpty()) {
            throw new IllegalArgumentException("There were no triples maps found in the mappings file. Is this a Stardog Mapping Syntax file?");
        }
        return Pair.create((Object)graphBuilder.namespaces(), (Object)MANAGER.exportMappings(aTriplesMaps, Set.class));
    }

    private String preprocessTemplate(String theInput) {
        String aResult = this.escapeTemplate(theInput);
        String aStart = this.mSeparator + "\"^^";
        String aStringType = aStart + "<" + String.valueOf(STRING_TYPE) + ">";
        aResult = aResult.replace(aStart + "xsd:string", aStringType);
        aResult = aResult.replace(aStart + "<" + String.valueOf(XSD.STRING) + ">", aStringType);
        return aResult;
    }

    private String escapeTemplate(String theInput) {
        String rawIriTemplatesReplaced = this.replaceDelimitedExpr(theInput, "<\\{", ".+?", "\\}>", s -> {
            this.mColumns.add(TurtleUtil.decodeString((String)s));
            return String.format("<%s/%s%d%s>", StardogMappingVocabulary.PLACEHOLDER, this.mSeparator, this.mColumns.size() - 1, this.mSeparator);
        });
        return this.replaceDelimitedExpr(rawIriTemplatesReplaced, "\\{", ".+?", "\\}", s -> {
            this.mColumns.add(TurtleUtil.decodeString((String)s));
            return this.mSeparator + (this.mColumns.size() - 1) + this.mSeparator;
        });
    }

    private String unescapeTemplate(String theInput) {
        String rawIriTemplatesRestored = this.replaceDelimitedExpr(theInput, String.valueOf(StardogMappingVocabulary.PLACEHOLDER) + "/" + this.mSeparator, "\\d+", this.mSeparator, s -> "{" + this.getColumn((String)s) + "}");
        return this.replaceDelimitedExpr(rawIriTemplatesRestored, this.mSeparator, "\\d+", this.mSeparator, s -> "{" + this.getColumn((String)s) + "}");
    }

    private String replaceDelimitedExpr(String theInput, String aBegin, String aExpr, String aEnd, Function<String, String> theReplacement) {
        Pattern aPattern = Pattern.compile("(" + aBegin + ")(" + aExpr + ")(" + aEnd + ")");
        Matcher aMatcher = aPattern.matcher(theInput);
        StringBuffer sb = new StringBuffer();
        while (aMatcher.find()) {
            String aMatch = aMatcher.group(2);
            String aReplacement = theReplacement.apply(aMatch);
            aMatcher.appendReplacement(sb, aReplacement);
        }
        aMatcher.appendTail(sb);
        return sb.toString();
    }

    private String getColumn(String theIndex) {
        return this.mColumns.get(Integer.valueOf(theIndex));
    }

    private LogicalTable getLogicalTable(Set<Statement> theGraph, Statement aStatement) {
        Resource aMapping = (Resource)aStatement.object();
        Optional<Literal> aLiteral = Graphs.object(theGraph, (Resource)aMapping, (IRI)StardogMappingVocabulary.TABLE).map(Literal.class::cast);
        if (aLiteral.isPresent()) {
            return FACTORY.createSQLBaseTableOrView(aLiteral.get().label());
        }
        aLiteral = Graphs.object(theGraph, (Resource)aMapping, (IRI)StardogMappingVocabulary.QUERY).map(Literal.class::cast);
        if (aLiteral.isPresent()) {
            return FACTORY.createR2RMLView(aLiteral.get().label());
        }
        throw new IllegalArgumentException("No logical table found for mapping " + String.valueOf(aStatement.subject()));
    }

    private TriplesMap createTriplesMap(Set<Statement> theGraph, Resource aSubject, LogicalTable aTable) {
        SubjectMap aSubjectMap = this.createSubjectMap((Value)aSubject);
        TriplesMap aTriplesMap = FACTORY.createTriplesMap(aTable, aSubjectMap);
        Iterator aIter = Graphs.matching(theGraph, (StatementPattern)StatementPattern.s((Resource)aSubject)).iterator();
        while (aIter.hasNext()) {
            Statement aStatement = (Statement)aIter.next();
            IRI aPred = aStatement.predicate();
            Value aObject = aStatement.object();
            if (aPred.namespace().equals("tag:stardog:api:mapping:")) continue;
            GraphMap aGraphMap = this.createGraphMap((Value)aStatement.context());
            PredicateObjectMap aPredicateObjectMap = this.createPredicateObjectMap(aPred, aObject);
            if (aPred.equals((Object)RDF.TYPE) && aPredicateObjectMap.getObjectMap(0).getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                aSubjectMap.addClass(aObject);
                if (aGraphMap == null) continue;
                aSubjectMap.addGraphMap(aGraphMap);
                continue;
            }
            if (aGraphMap != null) {
                aPredicateObjectMap.addGraphMap(aGraphMap);
            }
            aTriplesMap.addPredicateObjectMap(aPredicateObjectMap);
        }
        return aTriplesMap;
    }

    private PredicateObjectMap createPredicateObjectMap(IRI thePred, Value theObject) {
        PredicateMap aPredicateMap = this.createPredicateMap((Value)thePred);
        ObjectMap aObjectMap = this.createObjectMap(theObject);
        return FACTORY.createPredicateObjectMap(aPredicateMap, aObjectMap);
    }

    private SubjectMap createSubjectMap(Value theValue) {
        return (SubjectMap)this.createTermMap(theValue, IndexOrder.Field.S);
    }

    private PredicateMap createPredicateMap(Value theValue) {
        return (PredicateMap)this.createTermMap(theValue, IndexOrder.Field.P);
    }

    private ObjectMap createObjectMap(Value theValue) {
        return (ObjectMap)this.createTermMap(theValue, IndexOrder.Field.O);
    }

    private GraphMap createGraphMap(Value theValue) {
        return theValue instanceof Resource && Values.isDefaultGraph((Resource)((Resource)theValue)) ? null : (GraphMap)this.createTermMap(theValue, IndexOrder.Field.C);
    }

    private TermMap createTermMap(Value theValue, IndexOrder.Field theField) {
        String aStr = Value.lex((Value)theValue);
        TermMap aTermMap = this.createTermMap(aStr, theField);
        if (theValue instanceof Literal) {
            Literal aLiteral = (Literal)theValue;
            ObjectMap aObjectMap = (ObjectMap)aTermMap;
            aObjectMap.setTermType(Values.iri((String)"http://www.w3.org/ns/r2rml#Literal"));
            IRI aDatatype = aLiteral.datatypeIRI();
            if (aDatatype.equals((Object)RDF.LANG_STRING)) {
                aObjectMap.setLanguageTag(this.unescapeTemplate((String)aLiteral.lang().get()));
            } else if (aDatatype.equals((Object)STRING_TYPE)) {
                aObjectMap.setDatatype(XSD.STRING);
            } else if (!aDatatype.equals((Object)XSD.STRING)) {
                aObjectMap.setDatatype(aDatatype);
            }
        } else if (theValue instanceof BNode) {
            if (aTermMap instanceof SubjectMap) {
                ((SubjectMap)aTermMap).setTermType(Values.iri((String)"http://www.w3.org/ns/r2rml#BlankNode"));
            } else if (aTermMap instanceof ObjectMap) {
                ((ObjectMap)aTermMap).setTermType(Values.iri((String)"http://www.w3.org/ns/r2rml#BlankNode"));
            }
        }
        return aTermMap;
    }

    private TermMap createTermMap(String theValue, IndexOrder.Field theField) {
        TermMap.TermMapType termMapType;
        Template aTemplate = null;
        int aSepBegin = theValue.indexOf(this.mSeparator);
        int aSepEnd = theValue.indexOf(this.mSeparator, aSepBegin + 1);
        if (aSepBegin < 0) {
            termMapType = TermMap.TermMapType.CONSTANT_VALUED;
        } else if (aSepBegin == 0 && aSepEnd == theValue.length() - this.mSeparator.length()) {
            theValue = this.getColumn(theValue.substring(this.mSeparator.length(), aSepEnd));
            termMapType = TermMap.TermMapType.COLUMN_VALUED;
        } else {
            termMapType = TermMap.TermMapType.TEMPLATE_VALUED;
            theValue = this.unescapeTemplate(theValue);
            aTemplate = FACTORY.createTemplate(theValue);
        }
        switch (theField) {
            case S: {
                if (aTemplate != null) {
                    return FACTORY.createSubjectMap(aTemplate);
                }
                return FACTORY.createSubjectMap(termMapType, theValue);
            }
            case P: {
                if (aTemplate != null) {
                    return FACTORY.createPredicateMap(aTemplate);
                }
                return FACTORY.createPredicateMap(termMapType, theValue);
            }
            case O: {
                if (aTemplate != null) {
                    return FACTORY.createObjectMap(aTemplate);
                }
                return FACTORY.createObjectMap(termMapType, theValue);
            }
            case C: {
                if (aTemplate != null) {
                    return FACTORY.createGraphMap(aTemplate);
                }
                return FACTORY.createGraphMap(termMapType, theValue);
            }
        }
        throw new IllegalArgumentException("Invalid field type: " + String.valueOf(theField));
    }
}

