/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Change;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpConnection;
import com.complexible.stardog.query.AbstractGraphAliases;
import com.complexible.stardog.query.GraphAliasesUpdater;
import com.complexible.stardog.query.GraphAliasesVocabulary;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.Datasets;
import com.stardog.stark.query.SelectQueryResult;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

class HttpGraphAliases
extends AbstractGraphAliases
implements GraphAliasesUpdater {
    private final HttpConnection mConnection;

    HttpGraphAliases(HttpConnection theConnection) {
        Preconditions.checkArgument((boolean)theConnection.isOpen(), (Object)"The connection is closed");
        this.mConnection = theConnection;
        this.assertAliasesEnabled(theConnection);
        this.initialize();
    }

    private void assertAliasesEnabled(HttpConnection conn) {
        if (!((Boolean)conn.admin().get(conn.name(), (MetaProperty)DatabaseOptions.GRAPH_ALIASES)).booleanValue()) {
            throw new IllegalStateException("graph.aliases database option is disabled for " + conn.name());
        }
    }

    protected SelectQueryResult select(String query) {
        return (SelectQueryResult)this.mConnection.select(query).dataset(Datasets.of((IRI)GraphAliasesVocabulary.GA_GRAPH, (IRI[])new IRI[0])).execute();
    }

    public void finish() {
        this.pushChanges();
    }

    List<Change<ConnectionChangeType, Object>> getChanges() {
        if (!this.mChanged) {
            return Collections.emptyList();
        }
        List statements = this.mAliases.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(g -> Values.statement((Resource)((Resource)e.getKey()), (IRI)GraphAliasesVocabulary.GA_PREDICATE, (Value)g, (Resource)GraphAliasesVocabulary.GA_GRAPH))).collect(Collectors.toList());
        return ImmutableList.of((Object)Change.of((Enum)ConnectionChangeType.RemoveContext, (Object)GraphAliasesVocabulary.GA_GRAPH), (Object)Change.of((Enum)ConnectionChangeType.Add, (Object)MemoryStatementSource.of(statements)));
    }

    void markUnchanged() {
        this.mChanged = false;
    }

    private void pushChanges() {
        if (!this.mChanged || this.mConnection.getTxId() != null) {
            return;
        }
        HttpClient client = this.mConnection.getClient();
        UUID tx = UUID.randomUUID();
        client.begin(tx, "default");
        this.getChanges().forEach(change -> client.applyChange(tx, (Change<ConnectionChangeType, Object>)change));
        client.commit(tx);
        this.mChanged = false;
    }
}

