/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Change;
import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.common.base.Streams;
import com.complexible.common.base.SystemUtil;
import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.rdf.RDFStreamSupplier;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.StatementSource;
import com.complexible.common.rdf.impl.StreamStatementSources;
import com.complexible.common.rdf.query.PathQueryResult;
import com.complexible.common.rdf.query.TuplesAsPathQueryResult;
import com.complexible.common.rdf.rio.ParserConfigs;
import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.common.util.concurrent.DaemonExecutor;
import com.complexible.stardog.CommitResult;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.TxInfo;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.Exporter;
import com.complexible.stardog.api.impl.ConnectionChangeType;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.icv.shacl.ShaclBasedDataModelGenerator;
import com.complexible.stardog.protocols.http.admin.JsonSerializableOptions;
import com.complexible.stardog.protocols.http.admin.TxInfoOptions;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.protocols.http.client.HttpAdminClientImpl;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpOptions;
import com.complexible.stardog.protocols.http.client.QueryRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelGeneratorOptions;
import com.stardog.model.DataModelTextParser;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.query.Dataset;
import com.stardog.stark.query.Datasets;
import com.stardog.stark.query.GraphQueryResult;
import com.stardog.stark.query.QueryExecutionFailure;
import com.stardog.stark.query.SelectQueryResult;
import com.stardog.stark.query.io.AsyncGraphQueryResult;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultParsers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.KerberosCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientImpl
extends BaseHttpClient
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientImpl.class);
    private static final int QUERY_RESULT_BATCH_SIZE = SystemUtil.getPropertyAsInt((String)"com.stardog.client.result.batch", (int)1024);
    private final String baseWithSlash;
    private final URI sizeURI;
    private final URI updateURI;
    private final URI startTxURI;
    private final String commitTxURIBase;
    private final String rollbackTxURIBase;
    private final RDFFormat mDefaultFormat;
    private final QueryResultFormat mDefaultQueryResultFormat;
    private static final Map<String, Option> OPTS = Maps.newHashMap();

    public HttpClientImpl(URL theURL, Options theOptions) {
        super(theURL, theOptions);
        this.mDefaultFormat = (RDFFormat)theOptions.get(HttpOptions.DEFAULT_RDF_FORMAT);
        this.mDefaultQueryResultFormat = (QueryResultFormat)theOptions.get(HttpOptions.DEFAULT_QUERY_RESULT_FORMAT);
        String aURLStr = theURL.toString();
        this.baseWithSlash = aURLStr.endsWith("/") ? aURLStr : aURLStr + "/";
        this.sizeURI = URI.create(this.baseWithSlash + "size");
        this.updateURI = URI.create(this.baseWithSlash + "update");
        this.startTxURI = URI.create(this.baseWithSlash + "transaction/begin");
        this.rollbackTxURIBase = this.baseWithSlash + "transaction/rollback/";
        this.commitTxURIBase = this.baseWithSlash + "transaction/commit/";
    }

    @Override
    public Options connect(String theUser, char[] thePW) throws StardogException {
        UsernamePasswordCredentials aCreds = new UsernamePasswordCredentials(theUser, thePW);
        return this.connect((Credentials)aCreds);
    }

    @Override
    public Options connect(Credentials theCredentials) throws StardogException {
        this.resetContext(theCredentials);
        if (theCredentials instanceof KerberosCredentials) {
            HttpClientImpl.consumeResponse(this.executeHttpGet("authenticate"));
        }
        return Options.create();
    }

    @Override
    public boolean ask(QueryRequest theRequest) throws StardogException {
        HttpUriRequestBase get = this.getQueryMethod(theRequest);
        get.addHeader(ACCEPT_BOOLEAN_HEADER);
        try {
            return ApacheHttp.HttpResponses.toBoolean(this.execute((ClassicHttpRequest)get));
        }
        catch (IOException | ParseException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException(e);
        }
    }

    @Override
    public SelectQueryResult select(QueryRequest theRequest) throws StardogException {
        HttpUriRequestBase get = this.getQueryMethod(theRequest);
        get.addHeader((Header)new BasicHeader("Accept", (Object)this.mDefaultQueryResultFormat.defaultMimeType()));
        CloseableHttpResponse response = this.execute((ClassicHttpRequest)get);
        HttpEntity entity = response.getEntity();
        try {
            return this.getTupleResultsFromHttpContext(entity, this.mDefaultQueryResultFormat, response);
        }
        catch (Exception e) {
            ApacheHttp.HttpResponses.consumeQuietly(response);
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public SelectQueryResult plan(QueryRequest theRequest) throws StardogException {
        HttpUriRequestBase get = this.getQueryMethod(theRequest);
        get.addHeader((Header)new BasicHeader("Accept", (Object)this.mDefaultQueryResultFormat.defaultMimeType()));
        CloseableHttpResponse response = this.execute((ClassicHttpRequest)get);
        HttpEntity entity = response.getEntity();
        try {
            return this.getTupleResultsFromHttpContext(entity, this.mDefaultQueryResultFormat, response);
        }
        catch (Exception e) {
            ApacheHttp.HttpResponses.consumeQuietly(response);
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public void update(QueryRequest theRequest) throws StardogException {
        UUID aTx;
        long aTimeout;
        Dataset aDataset;
        ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
        aBuilder.parameter("update", theRequest.query());
        if (theRequest.baseURI() != null) {
            aBuilder.parameter("baseURI", theRequest.baseURI());
        }
        if (!Strings.isNullOrEmpty((String)theRequest.id())) {
            aBuilder.parameter("id", theRequest.id());
        }
        if ((aDataset = theRequest.dataset()) != null && aDataset != Datasets.NO_DATASET) {
            for (Resource aURI : aDataset.defaultGraphs()) {
                aBuilder.parameter("using-graph-uri", aURI.toString());
            }
            for (Resource aURI : aDataset.namedGraphs()) {
                aBuilder.parameter("using-named-graph-uri", aURI.toString());
            }
            for (Resource aURI : aDataset.defaultRemoveGraphs()) {
                aBuilder.parameter("remove-graph-uri", aURI.toString());
            }
            if (aDataset.defaultInsertGraph().isPresent()) {
                aBuilder.parameter("insert-graph-uri", ((Resource)aDataset.defaultInsertGraph().get()).toString());
            }
        }
        if (!Objects.equals(theRequest.schema(), null)) {
            aBuilder.parameter("reasoning", "true");
            aBuilder.parameter("schema", theRequest.schema());
        }
        if ((aTimeout = theRequest.timeout()) != -1L) {
            aBuilder.parameter("timeout", String.valueOf(aTimeout));
        }
        HttpPost aPostRequest = new HttpPost((aTx = (UUID)theRequest.tx().orElse(null)) == null ? this.updateURI : URI.create(this.baseWithSlash + String.valueOf(aTx) + "/update"));
        aPostRequest.setEntity(aBuilder.postBody());
        aPostRequest.addHeader(ACCEPT_BOOLEAN_HEADER);
        try {
            HttpClientImpl.maybeAssertBindings((HttpUriRequestBase)aPostRequest, theRequest.bindings(), theRequest.hints(), "update", theRequest.query());
        }
        catch (URISyntaxException e) {
            throw new StardogException((Throwable)e);
        }
        ApacheHttp.HttpResponses.consumeQuietly(this.execute((ClassicHttpRequest)aPostRequest));
    }

    @Override
    public GraphQueryResult graph(QueryRequest theRequest) throws StardogException {
        HttpUriRequestBase get = this.getQueryMethod(theRequest);
        get.addHeader(ACCEPT_TRIG_HEADER);
        CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)get);
        HttpEntity entity = aResponse.getEntity();
        String contentType = entity.getContentType();
        RDFFormat fmt = contentType == null ? RDFFormats.TRIG : RDFFormats.forMime((String)contentType).orElse(RDFFormats.TRIG);
        try {
            InputStream content = entity.getContent();
            RDFParser parser = (RDFParser)RDFParsers.forFormat((RDFFormat)fmt).orElseThrow(() -> new StardogException("Unrecognized RDF format: " + String.valueOf(fmt)));
            return new AsyncGraphQueryResult(content, parser, ParserConfigs.lax(), (ExecutorService)DaemonExecutor.get(), QUERY_RESULT_BATCH_SIZE, CancelCheck.DUMMY, complete -> HttpClientImpl.onResponseEnd(aResponse, complete), err -> this.onParseError((Exception)err, aResponse));
        }
        catch (IOException e) {
            ApacheHttp.HttpResponses.consumeQuietly(aResponse);
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public PathQueryResult paths(QueryRequest theRequest) throws StardogException {
        HttpUriRequestBase get = this.getQueryMethod(theRequest);
        get.addHeader(ACCEPT_TUPLE_FORMAT_HEADER);
        CloseableHttpResponse response = this.execute((ClassicHttpRequest)get);
        HttpEntity entity = response.getEntity();
        String contentType = entity.getContentType();
        QueryResultFormat fmt = contentType == null ? PREFERRED_TUPLE_FORMAT : QueryResultFormats.forMime((String)contentType).orElse(PREFERRED_TUPLE_FORMAT);
        try {
            SelectQueryResult aTuples = this.getTupleResultsFromHttpContext(entity, fmt, response);
            return new TuplesAsPathQueryResult(aTuples);
        }
        catch (Exception e) {
            ApacheHttp.HttpResponses.consumeQuietly(response);
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    private SelectQueryResult getTupleResultsFromHttpContext(HttpEntity theEntity, QueryResultFormat theFormat, CloseableHttpResponse theResponse) throws IOException {
        InputStream content = theEntity.getContent();
        try {
            SelectQueryResult result = QueryResultParsers.readSelectAsync((InputStream)content, (ExecutorService)DaemonExecutor.get(), (QueryResultFormat)theFormat, (int)QUERY_RESULT_BATCH_SIZE, (CancelCheck)CancelCheck.DUMMY, complete -> HttpClientImpl.onResponseEnd(theResponse, complete), err -> this.onParseError((Exception)err, theResponse));
            boolean unused = result.hasNext();
            return result;
        }
        catch (Exception e) {
            HttpClientImpl.onResponseEnd(theResponse, true);
            throw e;
        }
    }

    private RuntimeException onParseError(Exception err, CloseableHttpResponse response) {
        ApacheHttp.HttpResponses.consumeQuietly(response);
        RuntimeException errFromServer = HttpClientImpl.httpTrailersToException(ApacheHttp.HttpResponses.getHttpTrailers(response));
        return (RuntimeException)MoreObjects.firstNonNull((Object)errFromServer, (Object)new QueryExecutionFailure((Throwable)err));
    }

    @Override
    public InputStream executeReadQuery(QueryRequest theRequest) throws StardogException {
        HttpUriRequestBase get = this.getQueryMethod(theRequest);
        get.addHeader((Header)new BasicHeader("Accept", (Object)theRequest.format().defaultMimeType()));
        CloseableHttpResponse response = this.execute((ClassicHttpRequest)get);
        HttpEntity entity = response.getEntity();
        try {
            return entity.getContent();
        }
        catch (Exception e) {
            ApacheHttp.HttpResponses.consumeQuietly(response);
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public CommitResult applyChange(UUID theTxId, Change<ConnectionChangeType, Object> theChange, HttpClient.TxAction theTxAction) throws StardogException {
        ArrayList<BasicNameValuePair> aParams = new ArrayList<BasicNameValuePair>(3);
        if (theTxAction == HttpClient.TxAction.BEGIN || theTxAction == HttpClient.TxAction.BEGIN_AND_COMMIT) {
            aParams.add(new BasicNameValuePair("begin", null));
        }
        if (theTxAction == HttpClient.TxAction.COMMIT || theTxAction == HttpClient.TxAction.BEGIN_AND_COMMIT) {
            aParams.add(new BasicNameValuePair("commit", null));
        }
        StatementSource source = null;
        String aURL = this.baseWithSlash + theTxId.toString() + "/";
        ConnectionChangeType aChangeType = (ConnectionChangeType)theChange.getChangeType();
        switch (aChangeType) {
            case Add: {
                aURL = aURL + "add";
                source = (StatementSource)theChange.getChange();
                break;
            }
            case Remove: {
                aURL = aURL + "remove";
                source = (StatementSource)theChange.getChange();
                break;
            }
            case RemoveContext: {
                aURL = aURL + "clear";
                Resource aContextToRemove = (Resource)theChange.getChange();
                String aContextParam = aContextToRemove == null ? "default" : Value.lex((Value)aContextToRemove);
                aParams.add(new BasicNameValuePair("graph-uri", aContextParam));
                break;
            }
            case RemoveAll: {
                aURL = aURL + "clear";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(theChange.getChangeType()) + " is not supported");
            }
        }
        if (source instanceof RDFStreamSupplier) {
            String bnodeIdPrefix = (String)((RDFStreamSupplier)source).getParserConfig().get(ParserContext.BNODE_ID_PREFIX);
            if (bnodeIdPrefix != null) {
                aParams.add(new BasicNameValuePair(ParserContext.BNODE_ID_PREFIX.getName(), bnodeIdPrefix));
            }
        } else {
            boolean preserveBnodeIds = this.getOptions().contains(ParserOptions.PRESERVE_BNODE_IDS);
            if (preserveBnodeIds) {
                Preconditions.checkArgument((boolean)this.mDefaultFormat.equals((Object)RDFFormats.BINARY), (String)"HTTP client cannot be configured to preserve bnode IDs when the RDF format is %s", (Object)this.mDefaultFormat);
                aParams.add(new BasicNameValuePair(ParserOptions.PRESERVE_BNODE_IDS.getName(), String.valueOf(this.getOptions().is(ParserOptions.PRESERVE_BNODE_IDS))));
            }
        }
        HttpPost post = new HttpPost(ApacheHttp.URIs.uri(aURL, aParams));
        try {
            if (source != null) {
                this.appendSourceToRequest((HttpUriRequestBase)post, source);
            }
            CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)post);
            CommitResult commitResult = ApacheHttp.HttpResponses.toObject(aResponse, CommitResult.class);
            return commitResult;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)post.getEntity());
        }
    }

    @Override
    public void begin(UUID theTxId, String theSchema) throws StardogException {
        try {
            ArrayList<BasicNameValuePair> params = null;
            if (theSchema != null) {
                params = new ArrayList<BasicNameValuePair>(1);
                params.add(new BasicNameValuePair("schema", theSchema));
            }
            CloseableHttpResponse response = this.execute((ClassicHttpRequest)new HttpPost(ApacheHttp.URIs.uri(String.valueOf(this.startTxURI) + "/" + theTxId.toString(), params)));
            ApacheHttp.HttpResponses.consume(response);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new StardogException((Throwable)e);
        }
    }

    private static void assertInTx(UUID theTxId) throws StardogException {
        if (theTxId == null) {
            throw new StardogException("Cannot initiate transaction operation, transaction credentials are missing.");
        }
    }

    @Override
    public CommitResult commit(UUID theTxId) throws StardogException {
        HttpClientImpl.assertInTx(theTxId);
        HttpPost post = new HttpPost(URI.create(this.commitTxURIBase + theTxId.toString()));
        post.addHeader((Header)new BasicHeader("Accept", (Object)"application/json"));
        try {
            CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)post);
            return ApacheHttp.HttpResponses.toObject(aResponse, CommitResult.class);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public String explain(QueryRequest theRequest) throws StardogException {
        try {
            return ApacheHttp.HttpResponses.toString(this.execute((ClassicHttpRequest)this.getQueryMethod("explain", theRequest)));
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public void rollback(UUID theTxId) throws StardogException {
        HttpClientImpl.assertInTx(theTxId);
        HttpPost post = new HttpPost(URI.create(this.rollbackTxURIBase + theTxId.toString()));
        try {
            ApacheHttp.HttpResponses.consume(this.execute((ClassicHttpRequest)post));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    private long size(boolean theExact, UUID theTx) {
        try {
            ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
            aBuilder.parameter("exact", theExact);
            if (theTx != null) {
                aBuilder.parameter("transaction", theTx.toString());
            }
            return ApacheHttp.HttpResponses.toLong(this.execute((ClassicHttpRequest)new HttpGet(aBuilder.uri(this.sizeURI))));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public long size() throws StardogException {
        return this.size(false, null);
    }

    @Override
    public long exactSize(UUID theTx) throws StardogException {
        return this.size(true, theTx);
    }

    private StatementSource createStatementSource(File theFile) {
        try {
            return StreamStatementSources.oneTime().create(RDFFormats.forFile((File)theFile, (RDFFormat)RDFFormats.TURTLE), theFile, null);
        }
        catch (IOException e) {
            throw new StardogException((Throwable)e);
        }
    }

    private ClassicHttpRequest createExportRequest(Collection<Resource> theContexts, File theObfConfig, RDFFormat theServerSideFormat) throws StardogException {
        ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
        for (Resource aURI : theContexts) {
            aBuilder.parameter("graph-uri", aURI.toString());
        }
        if (theServerSideFormat != null) {
            aBuilder.parameter("server-side", null).parameter("format", RDFFormats.baseFormat((RDFFormat)theServerSideFormat).name());
            FileFormat.Compression aCompression = RDFFormats.compressionOf((RDFFormat)theServerSideFormat);
            if (aCompression != FileFormat.Compression.NONE) {
                aBuilder.parameter("compression", aCompression.name());
            }
        }
        if (theObfConfig != null) {
            if (theObfConfig == Exporter.DEFAULT_OBFUSCATION) {
                aBuilder.parameter("obf", "DEFAULT");
            } else {
                if (!theObfConfig.exists()) {
                    throw new StardogException("Configuration file not found: " + String.valueOf(theObfConfig));
                }
                HttpPost post = new HttpPost(aBuilder.uri(this.baseWithSlash + "export"));
                this.appendSourceToRequest((HttpUriRequestBase)post, this.createStatementSource(theObfConfig));
                return post;
            }
        }
        return new HttpGet(aBuilder.uri(this.baseWithSlash + "export"));
    }

    @Override
    public void export(Collection<Resource> theContexts, RDFFormat theFormat, Iterable<Namespace> theNamespaces, OutputStream theOutput, File theObfConfig) throws StardogException {
        ClassicHttpRequest request = this.createExportRequest(theContexts, theObfConfig, null);
        ApacheHttp.HttpRequests.accept((HttpMessage)request, theFormat.defaultMimeType());
        Closer aCloser = Closer.create();
        CloseableHttpResponse aResponse = this.execute(request);
        try {
            InputStream aStream = aResponse.getEntity().getContent();
            aCloser.register((Closeable)theOutput);
            aCloser.register((Closeable)aStream);
            ByteStreams.copy((InputStream)aStream, (OutputStream)theOutput);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
        finally {
            this.closeQuietly(aCloser);
            BaseHttpClient.onResponseEnd(aResponse, true);
        }
    }

    @Override
    public String serverExport(Collection<Resource> theContexts, RDFFormat theFormat, File theObfConfig) throws StardogException {
        ClassicHttpRequest request = this.createExportRequest(theContexts, theObfConfig, theFormat);
        try {
            return ApacheHttp.HttpResponses.toString(this.execute(request));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public DataModel generateModel(DataModelFormat theInputFormat, Options theOptions) throws StardogException {
        DataModel dataModel;
        block11: {
            ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
            Boolean aIncludeProvenance = (Boolean)theOptions.get(DataModelGeneratorOptions.INCLUDE_PROVENANCE_VIRTUAL);
            DataModelFormat aOutputFormat = aIncludeProvenance != false ? DataModelFormat.SHACL : DataModelFormat.TEXT;
            aBuilder.parameter("input", theInputFormat.getName());
            aBuilder.parameter("output", aOutputFormat.getName());
            aBuilder.parameter("prettify", "true");
            String aSchema = (String)this.getOptions().get(ConnectionConfiguration.REASONING_SCHEMA);
            if (aSchema != null) {
                aBuilder.parameter("schema", aSchema);
            }
            HttpGet aHttpGet = new HttpGet(aBuilder.uri(this.baseWithSlash + "model"));
            try {
                BaseHttpClient.addConnectionStringParams((HttpMessage)aHttpGet, theOptions);
            }
            catch (URISyntaxException e) {
                throw new StardogException((Throwable)e);
            }
            CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)aHttpGet);
            try {
                InputStream content = aResponse.getEntity().getContent();
                Object dataModelGenerator = aOutputFormat == DataModelFormat.SHACL ? new ShaclBasedDataModelGenerator(RDFParsers.read((InputStream)content, (RDFFormat)RDFFormats.TURTLE)) : new DataModelTextParser(content);
                dataModel = dataModelGenerator.generate(theOptions).build();
                if (aResponse == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (aResponse != null) {
                        try {
                            aResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                    throw new StardogException((Throwable)e);
                }
            }
            aResponse.close();
        }
        return dataModel;
    }

    public HttpUriRequestBase getQueryMethod(QueryRequest theRequest) {
        return this.getQueryMethod("query", theRequest);
    }

    public HttpUriRequestBase getQueryMethod(String thePath, QueryRequest theRequest) {
        return this.getQueryMethod(this.uri(thePath, theRequest.tx()), theRequest);
    }

    public HttpUriRequestBase getQueryMethod(URI theHttpURI, QueryRequest theRequest) {
        HttpGet aRequest;
        URI aReqURI;
        String theQuery = theRequest.query();
        String theBaseURI = theRequest.baseURI();
        String theID = theRequest.id();
        long theLimit = theRequest.limit();
        long theOffset = theRequest.offset();
        long theTimeout = theRequest.timeout();
        Map<String, Value> theBindings = theRequest.bindings();
        Dataset theDataset = theRequest.dataset();
        String theSchema = theRequest.schema();
        FileFormat theFormat = theRequest.format();
        boolean theVerbose = theRequest.isVerbose();
        boolean theRefreshGA = theRequest.refreshGraphAliases();
        ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
        aBuilder.parameter("query", theQuery);
        if (theBaseURI != null) {
            aBuilder.parameter("baseURI", theBaseURI);
        }
        if (!Strings.isNullOrEmpty((String)theID)) {
            aBuilder.parameter("id", theID);
        }
        if (theLimit != -1L) {
            aBuilder.parameter("limit", String.valueOf(theLimit));
        }
        if (theOffset != -1L) {
            aBuilder.parameter("offset", String.valueOf(theOffset));
        }
        if (theTimeout != -1L) {
            aBuilder.parameter("timeout", String.valueOf(theTimeout));
        }
        if (theDataset != null && theDataset != Datasets.NO_DATASET) {
            for (Resource aURI : theDataset.defaultGraphs()) {
                aBuilder.parameter("default-graph-uri", aURI.toString());
            }
            for (Resource aURI : theDataset.namedGraphs()) {
                aBuilder.parameter("named-graph-uri", aURI.toString());
            }
            theDataset.excludedGraphs().forEach(g -> aBuilder.parameter("exclude-graph-uri", g.toString()));
        }
        if (!Objects.equals(theSchema, null)) {
            aBuilder.parameter("reasoning", "true");
            aBuilder.parameter("schema", theSchema);
        }
        if (theVerbose) {
            aBuilder.parameter("verbose", true);
        }
        if (theRequest.profiling()) {
            aBuilder.parameter("profile", true);
        }
        if (theFormat != null) {
            aBuilder.parameter("useNamespaces", "true");
            if (theFormat.equals((Object)RDFFormats.PRETTY_TURTLE)) {
                aBuilder.parameter("prettify", "true");
            }
        }
        if (theRefreshGA) {
            aBuilder.parameter("refresh_ga", true);
        }
        if ((aReqURI = aBuilder.uri(theHttpURI)).toString().length() < (Integer)this.getOptions().get(HttpOptions.HTTP_MAX_HTTP_GET_QUERY_LENGTH)) {
            aRequest = new HttpGet(aReqURI);
        } else {
            HttpPost post = new HttpPost(theHttpURI);
            post.setEntity(aBuilder.postBody());
            aRequest = post;
        }
        try {
            HttpClientImpl.maybeAssertBindings((HttpUriRequestBase)aRequest, theBindings, theRequest.hints(), "query", theQuery);
        }
        catch (URISyntaxException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
        return aRequest;
    }

    private URI uri(String endpoint, Optional<UUID> txId) {
        return URI.create(this.baseWithSlash + txId.map(id -> String.valueOf(id) + "/").orElse("") + endpoint);
    }

    private URI sizeURI(UUID txId) {
        return URI.create(txId == null ? this.baseWithSlash + "size" : this.baseWithSlash + txId.toString() + "/size");
    }

    private void closeQuietly(Closer theCloser) {
        try {
            theCloser.close();
        }
        catch (IOException e) {
            LOGGER.error("There was an error closing the streams", (Throwable)e);
        }
    }

    private static void maybeAssertBindings(HttpUriRequestBase theRequest, Map<String, Value> theBindings, Map<String, String> theHints, String theOriginalQueryParam, String theOriginalQueryValue) throws URISyntaxException {
        URIBuilder aBuilder = null;
        if (theBindings != null && !theBindings.isEmpty()) {
            TurtleValueWriter tvw = new TurtleValueWriter((Iterable)Namespaces.EXTENDED);
            URIBuilder finalBuilder = new URIBuilder(theRequest.getUri());
            theBindings.entrySet().stream().filter(aEntry -> aEntry.getValue() != null).forEach(aEntry -> finalBuilder.addParameter("$" + (String)aEntry.getKey(), tvw.write((Value)aEntry.getValue())));
            aBuilder = finalBuilder;
        }
        if (!theHints.isEmpty()) {
            URIBuilder finalBuilder = aBuilder != null ? aBuilder : new URIBuilder(theRequest.getUri());
            theHints.forEach((hint, value) -> finalBuilder.addParameter("pragma." + hint, value));
            aBuilder = finalBuilder;
        }
        if (aBuilder != null) {
            aBuilder.setParameter(theOriginalQueryParam, theOriginalQueryValue);
            try {
                theRequest.setUri(aBuilder.build());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error parsing URI", (Throwable)e);
                throw e;
            }
        }
    }

    private void appendSourceToRequest(HttpUriRequestBase theBase, StatementSource theSource) throws StardogException {
        HttpEntity aEntity = ApacheHttp.Entities.create(theSource, this.mDefaultFormat);
        if (theSource.getContext() != null) {
            ApacheHttp.HttpRequests.appendURIParameter((HttpMessage)theBase, "graph-uri", theSource.getContext().toString());
        }
        theBase.setEntity(aEntity);
    }

    @Override
    public Map<String, Object> status() throws StardogException {
        Map<String, Object> map;
        block8: {
            HttpGet get = new HttpGet(this.url("status"));
            get.addHeader(ACCEPT_JSON_HEADER);
            CloseableHttpResponse response = this.execute((ClassicHttpRequest)get);
            try {
                map = HttpAdminClientImpl.toMap(HttpClientImpl.parseResponseAsJsonObject(response));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StardogException("Error while getting db status", (Throwable)e);
                }
            }
            response.close();
        }
        return map;
    }

    private StatementIterator statements(StatementSource source) throws StardogException {
        try {
            return source.statements();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
            throw new StardogException((Throwable)e);
        }
    }

    @Override
    public Collection<TxInfo> transactions(String theDb) {
        Collection collection;
        block8: {
            HttpGet get = new HttpGet(this.url("transaction"));
            get.addHeader(ACCEPT_JSON_HEADER);
            CloseableHttpResponse response = this.execute((ClassicHttpRequest)get);
            try {
                JsonSerializableOptions<TxInfoOptions> aResult = HttpClientImpl.parseResponseAsJson(response, TxInfoOptions.class);
                collection = ((TxInfoOptions)aResult.getObject()).getTransactions();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StardogException("Error while getting transactions", (Throwable)e);
                }
            }
            response.close();
        }
        return collection;
    }

    static {
        Stream.concat(Stream.of(DatabaseOptions.NAMESPACES, DatabaseOptions.ARCHETYPES, DatabaseOptions.CONNECTION_TIMEOUT, DatabaseOptions.ONLINE, DatabaseOptions.QUERY_ALL_GRAPHS, DatabaseOptions.QUERY_PLAN_REUSE, DatabaseOptions.QUERY_TIMEOUT, DatabaseOptions.NAME, DatabaseOptions.CREATION_TIME, DatabaseOptions.STRICT_PARSING, DatabaseOptions.PRESERVE_BNODE_IDS, DatabaseOptions.MODIFICATION_TIME, DatabaseOptions.TRANSACTION_LOGGING), Streams.stream((Iterator)DatabaseOptions.defaults((String)"").iterator())).map(mp -> Option.create((String)mp.getName(), (Object)mp.getDefaultValue())).forEach(aOpt -> OPTS.put(aOpt.toString(), (Option)aOpt));
    }
}

