/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.complexible.stardog.ImmutableStoredFunction;
import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredFunction;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.StoredQueryIO;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.process.ProcessInfo;
import com.complexible.stardog.process.ProcessManager;
import com.complexible.stardog.protocols.http.UrlUtil;
import com.complexible.stardog.protocols.http.admin.CheckpointOptions;
import com.complexible.stardog.protocols.http.admin.CreateDBOptions;
import com.complexible.stardog.protocols.http.admin.CreateRoleOptions;
import com.complexible.stardog.protocols.http.admin.CreateUserOptions;
import com.complexible.stardog.protocols.http.admin.EnabledOptions;
import com.complexible.stardog.protocols.http.admin.JsonSerializableOptions;
import com.complexible.stardog.protocols.http.admin.MetadataOptions;
import com.complexible.stardog.protocols.http.admin.NameOptions;
import com.complexible.stardog.protocols.http.admin.PermissionList;
import com.complexible.stardog.protocols.http.admin.PermissionsOptions;
import com.complexible.stardog.protocols.http.admin.QueryInfoOptions;
import com.complexible.stardog.protocols.http.admin.QueryListingOptions;
import com.complexible.stardog.protocols.http.admin.RoleListingOptions;
import com.complexible.stardog.protocols.http.admin.SetOfflineOptions;
import com.complexible.stardog.protocols.http.admin.SetUserPasswordOptions;
import com.complexible.stardog.protocols.http.admin.SuperUserOptions;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.HttpAdminClient;
import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.JwtIssuerResponse;
import com.complexible.stardog.security.Permission;
import com.complexible.stardog.security.StardogSecurityException;
import com.complexible.stardog.server.UnknownTransactionException;
import com.complexible.stardog.util.report.DiagnosticsReport;
import com.complexible.stardog.util.report.LogRetriever;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpAdminClientImpl
extends BaseHttpClient
implements HttpAdminClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAdminClientImpl.class);
    private static final Header ACCEPT_TURTLE = new BasicHeader("Accept", (Object)"text/turtle");
    private static final Header ACCEPT_ALL = new BasicHeader("Accept", (Object)"*");
    private String mUser = (String)ConnectionConfiguration.USERNAME.getDefaultValue();

    HttpAdminClientImpl(URL theURL, Options theOptions) {
        super(theURL, theOptions);
    }

    HttpAdminClientImpl(URL theURL, Options theOptions, Credentials theCredentials) {
        super(theURL, theOptions, theCredentials);
    }

    @Override
    public Options connect(String theUser, char[] thePW) throws StardogException {
        Options aResult = super.connect(theUser, thePW);
        this.mUser = theUser;
        return aResult;
    }

    @Override
    protected Options connect() {
        Options aOptions = super.connect();
        HttpAdminClientImpl.consumeResponse(this.executeHttpGet("users/valid"));
        return aOptions;
    }

    @Override
    public Collection<String> list() throws StardogException {
        Collection<String> collection;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("databases");
            try {
                JsonArray aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("databases");
                collection = HttpAdminClientImpl.convertToStringCollection(aResult);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public void addRole(String theRole) throws StardogException {
        CreateRoleOptions aRoleOptions = new CreateRoleOptions();
        aRoleOptions.setRolename(theRole);
        try (CloseableHttpResponse aResponse = this.executeHttpPost("roles", aRoleOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(aResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void addRolePerm(Permission thePermission) throws StardogException {
        PermissionsOptions aPermOptions = new PermissionsOptions();
        aPermOptions.setAction(thePermission.getActionType().name());
        aPermOptions.setResourceType(thePermission.getResourceType().id());
        aPermOptions.setResources(thePermission.getResourceNames());
        String aEncodedRole = UrlUtil.encodeUrl((String)thePermission.getSubject());
        try (CloseableHttpResponse theResponse = this.executeHttpPut("permissions/role/" + aEncodedRole, aPermOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void addUser(String theUsername, boolean theSuperuser, char[] thePassword) throws StardogException {
        CreateUserOptions aUserOptions = new CreateUserOptions();
        aUserOptions.setSuperuser(theSuperuser);
        aUserOptions.setUsername(theUsername);
        aUserOptions.setPassword(thePassword);
        try (CloseableHttpResponse theResponse = this.executeHttpPost("users", aUserOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void addUserPerm(Permission thePermission) throws StardogException {
        PermissionsOptions aPermOptions = new PermissionsOptions();
        aPermOptions.setAction(thePermission.getActionType().name());
        aPermOptions.setResourceType(thePermission.getResourceType().id());
        aPermOptions.setResources(thePermission.getResourceNames());
        String aEncodedUser = UrlUtil.encodeUrl((String)thePermission.getSubject());
        try (CloseableHttpResponse theResponse = this.executeHttpPut("permissions/user/" + aEncodedUser, aPermOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void changePassword(String theUsername, char[] theCurrentPassword, char[] theNewPassword) throws StardogException {
        SetUserPasswordOptions aOptions = new SetUserPasswordOptions();
        aOptions.setCurrentPassword(new String(theCurrentPassword));
        aOptions.setPassword(new String(theNewPassword));
        String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
        try (CloseableHttpResponse theResponse = this.executeHttpPut("users/" + aEncodedUser + "/pwd", aOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
        if (this.mUser.equals(theUsername)) {
            this.resetContext(theUsername, theNewPassword);
        }
    }

    @Override
    public String create(String theName, Metadata theDbOptions, Map<Path, Resource> toFilesToBulkLoad, boolean theCopyToServer) throws StardogException {
        String string;
        block10: {
            ArrayList aFileList = Lists.newArrayList();
            ArrayList aFiles = Lists.newArrayList();
            for (Map.Entry<Path, Resource> anEntry : toFilesToBulkLoad.entrySet()) {
                HashMap aFileMap = Maps.newHashMap();
                aFileMap.put(theCopyToServer ? anEntry.getKey().getFileName().toString() : anEntry.getKey().toAbsolutePath().toString(), anEntry.getValue() != null ? anEntry.getValue().toString() : null);
                aFileList.add(aFileMap);
                aFiles.add(anEntry.getKey().toFile());
            }
            CreateDBOptions aOptions = new CreateDBOptions(new MetadataOptions(theDbOptions), (List)aFileList, theCopyToServer);
            aOptions.setDBName(theName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending json: {}", (Object)aOptions.toJsonString());
            }
            CloseableHttpResponse theResponse = this.executeHttpPostMultipart("databases", aOptions.toJsonObject(), theCopyToServer ? aFiles.toArray(new File[aFiles.size()]) : new File[]{});
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public void renameDatabase(String theOldName, String theNewName) throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpPost("databases/" + theOldName + "/rename", theNewName, "text/plain");){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void deleteRole(String theRole, boolean isForce) throws StardogException {
        String aEncodedRole = UrlUtil.encodeUrl((String)theRole);
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("roles/" + aEncodedRole + "?force=" + isForce);){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void deleteRolePerm(Permission thePermission) throws StardogException {
        PermissionsOptions aPermOptions = new PermissionsOptions();
        aPermOptions.setAction(thePermission.getActionType().name());
        aPermOptions.setResourceType(thePermission.getResourceType().id());
        aPermOptions.setResources(thePermission.getResourceNames());
        String aEncodedRole = UrlUtil.encodeUrl((String)thePermission.getSubject());
        try (CloseableHttpResponse theResponse = this.executeHttpPost("permissions/role/" + aEncodedRole + "/delete", aPermOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void deleteUser(String theUsername) throws StardogException {
        String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("users/" + aEncodedUser);){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void deleteUserPerm(Permission thePermission) throws StardogException {
        PermissionsOptions aPermOptions = new PermissionsOptions();
        aPermOptions.setAction(thePermission.getActionType().name());
        aPermOptions.setResourceType(thePermission.getResourceType().id());
        aPermOptions.setResources(thePermission.getResourceNames());
        String aEncodedUser = UrlUtil.encodeUrl((String)thePermission.getSubject());
        try (CloseableHttpResponse theResponse = this.executeHttpPost("permissions/user/" + aEncodedUser + "/delete", aPermOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public String drop(String theDb) throws StardogException {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpDelete("databases/" + theDb);
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public Metadata get(String theDb, Collection<String> theOptionNames) throws StardogException {
        Metadata metadata;
        block9: {
            HashMap aOptionsMap = Maps.newHashMap();
            for (String anOption : theOptionNames) {
                aOptionsMap.put(anOption, "");
            }
            CloseableHttpResponse theResponse = this.executeHttpPut("databases/" + theDb + "/options", (JsonObject)new GsonBuilder().create().toJsonTree((Object)aOptionsMap));
            try {
                JsonSerializableOptions<MetadataOptions> aResult = HttpAdminClientImpl.parseResponseAsJson(theResponse, MetadataOptions.class);
                metadata = ((MetadataOptions)aResult.getObject()).getMetadata();
                if (theResponse == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return metadata;
    }

    @Override
    public Collection<String> getAllRoles() throws StardogException {
        Collection<String> collection;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("roles");
            try {
                JsonArray aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("roles");
                collection = HttpAdminClientImpl.convertToStringCollection(aResult);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public Collection<String> getAllUsers() throws StardogException {
        Collection<String> collection;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("users");
            try {
                JsonArray aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("users");
                collection = HttpAdminClientImpl.convertToStringCollection(aResult);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public Collection<Permission> getEffectiveUserPerms(String theUsername) throws StardogException {
        Collection collection;
        block8: {
            String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
            CloseableHttpResponse theResponse = this.executeHttpGet("permissions/effective/user/" + aEncodedUser);
            try {
                collection = PermissionList.toPermissions((String)theUsername, (PermissionList)((PermissionList)HttpAdminClientImpl.parseResponseAsJson(theResponse, PermissionList.class).getObject()));
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public Collection<Permission> getRolePerms(String theRoleName) throws StardogException {
        Collection collection;
        block8: {
            String aEncodedRole = UrlUtil.encodeUrl((String)theRoleName);
            CloseableHttpResponse theResponse = this.executeHttpGet("permissions/role/" + aEncodedRole);
            try {
                collection = PermissionList.toPermissions((String)theRoleName, (PermissionList)((PermissionList)HttpAdminClientImpl.parseResponseAsJson(theResponse, PermissionList.class).getObject()));
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    public Pattern getValidResourceNamePattern() throws StardogSecurityException {
        throw new UnsupportedOperationException();
    }

    public boolean checkUserPerm(ActionType theAction, String theResourceType, String theResourceName) throws StardogSecurityException {
        boolean bl;
        block8: {
            String aEncodedAction = UrlUtil.encodeUrl((String)theAction.name());
            String aEncodedResourceType = UrlUtil.encodeUrl((String)theResourceType);
            String aEncodedResourceName = UrlUtil.encodeUrl((String)theResourceName);
            String aUrl = "permissions/check?action=" + aEncodedAction + "&resource_type=" + aEncodedResourceType + "&resource=" + aEncodedResourceName;
            CloseableHttpResponse theResponse = this.executeHttpGet(aUrl);
            try {
                JsonObject aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse);
                bl = aResult.get("hasPermission").getAsBoolean();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return bl;
    }

    @Override
    public Collection<Permission> getUserPerms(String theUsername) throws StardogException {
        Collection collection;
        block8: {
            String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
            CloseableHttpResponse theResponse = this.executeHttpGet("permissions/user/" + aEncodedUser);
            try {
                collection = PermissionList.toPermissions((String)theUsername, (PermissionList)((PermissionList)HttpAdminClientImpl.parseResponseAsJson(theResponse, PermissionList.class).getObject()));
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public Collection<String> getUserRoles(String theUsername) throws StardogException {
        Collection<String> collection;
        block8: {
            String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
            CloseableHttpResponse theResponse = this.executeHttpGet("users/" + aEncodedUser + "/roles");
            try {
                JsonArray aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("roles");
                collection = HttpAdminClientImpl.convertToStringCollection(aResult);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public Collection<String> getUsersWithRole(String theRole) throws StardogException {
        Collection<String> collection;
        block8: {
            String aEncodedRole = UrlUtil.encodeUrl((String)theRole);
            CloseableHttpResponse theResponse = this.executeHttpGet("roles/" + aEncodedRole + "/users");
            try {
                JsonArray aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("users");
                collection = HttpAdminClientImpl.convertToStringCollection(aResult);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return collection;
    }

    @Override
    public boolean isSuperUser(String theUsername) throws StardogException {
        boolean bl;
        block8: {
            String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
            CloseableHttpResponse theResponse = this.executeHttpGet("users/" + aEncodedUser + "/superuser");
            try {
                JsonSerializableOptions<SuperUserOptions> aSuperUserBox = HttpAdminClientImpl.parseResponseAsJson(theResponse, SuperUserOptions.class);
                bl = ((SuperUserOptions)aSuperUserBox.getObject()).isSuperuser();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return bl;
    }

    @Override
    public boolean isUserEnabled(String theUsername) throws StardogException {
        boolean bl;
        block8: {
            String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
            CloseableHttpResponse theResponse = this.executeHttpGet("users/" + aEncodedUser + "/enabled");
            try {
                JsonSerializableOptions<EnabledOptions> aEnabledBox = HttpAdminClientImpl.parseResponseAsJson(theResponse, EnabledOptions.class);
                bl = ((EnabledOptions)aEnabledBox.getObject()).isEnabled();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return bl;
    }

    @Override
    public String repair(String theDb) throws StardogException {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpPost("databases/" + theDb + "/repair");
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String verify(String theDb) throws StardogException {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpPost("databases/" + theDb + "/verify");
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String backup(String theDb, Optional<String> theBackupUrl, Options theOptions) throws StardogException {
        String string;
        block8: {
            ApacheHttp.Parameters.ParameterListBuilder aParams = ApacheHttp.Parameters.builder();
            theBackupUrl.ifPresent(theUrl -> aParams.parameter("to", UrlUtil.encodeUrl((String)theUrl)));
            theOptions.forEach(theOption -> aParams.parameter(theOption.getName(), theOptions.get(theOption).toString()));
            CloseableHttpResponse theResponse = this.executeHttpPut(aParams.uri("databases/" + theDb + "/backup").toString());
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String backupAll(Options theOptions) throws StardogException {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpPut("databases/backup_all", theOptions.toJsonString(), "application/json");
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String restore(File theBackup, boolean theOverwrite, String theName) throws StardogException {
        String string;
        block9: {
            ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
            aBuilder.parameter("from", theBackup.getAbsolutePath());
            aBuilder.parameter("force", theOverwrite);
            if (theName != null) {
                aBuilder.parameter("name", theName);
            }
            CloseableHttpResponse theResponse = this.executeHttpPut("restore?" + ApacheHttp.Parameters.format(aBuilder.build()));
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String restore(String theBackup, boolean theOverwrite, String theName) throws StardogException {
        String string;
        block9: {
            ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
            String aEncodedUrl = UrlUtil.encodeUrl((String)theBackup);
            aBuilder.parameter("from", aEncodedUrl);
            aBuilder.parameter("force", theOverwrite);
            if (theName != null) {
                aBuilder.parameter("name", theName);
            }
            CloseableHttpResponse theResponse = this.executeHttpPut("restore?" + ApacheHttp.Parameters.format(aBuilder.build()));
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public Collection<String> checkpoint(String theDb, Options theOptions) throws StardogException {
        JsonArray aResult = new JsonArray();
        if (theOptions.contains(CheckpointOptions.CHECKPOINT_OPERATION)) {
            String operation;
            switch (operation = (String)theOptions.get(CheckpointOptions.CHECKPOINT_OPERATION)) {
                case "list": {
                    try (CloseableHttpResponse theResponse = this.executeHttpGet("checkpoint/" + theDb);){
                        aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("checkpoints");
                        break;
                    }
                    catch (IOException e) {
                        throw Client.toStardogException(e);
                    }
                }
                case "restore": {
                    if (theOptions.contains(CheckpointOptions.CHECKPOINT_RESTORE_CHECKPOINT)) {
                        String checkpointName = (String)theOptions.get(CheckpointOptions.CHECKPOINT_RESTORE_CHECKPOINT);
                        try (CloseableHttpResponse theResponse = this.executeHttpPut("checkpoint/" + theDb + "/" + checkpointName, (JsonObject)new GsonBuilder().create().toJsonTree((Object)theOptions));){
                            aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("checkpoint");
                            break;
                        }
                        catch (IOException e) {
                            throw Client.toStardogException(e);
                        }
                    }
                    throw new StardogException("Checkpoint restore requires name of checkpoint.");
                }
                case "create": {
                    Options messageOnly = Options.create();
                    if (theOptions.contains(CheckpointOptions.CHECKPOINT_CREATE_MESSAGE)) {
                        messageOnly.set(CheckpointOptions.CHECKPOINT_CREATE_MESSAGE, (Object)((String)theOptions.get(CheckpointOptions.CHECKPOINT_CREATE_MESSAGE)));
                    }
                    CloseableHttpResponse theResponse = this.executeHttpPost("checkpoint/" + theDb, (JsonObject)new GsonBuilder().create().toJsonTree((Object)messageOnly));
                    aResult = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("checkpoint");
                    break;
                }
                default: {
                    throw new StardogException("Checkpoint called with unknown operation.");
                }
            }
        } else {
            throw new StardogException("Checkpoint called without operation.");
        }
        return HttpAdminClientImpl.convertToStringCollection(aResult);
    }

    @Override
    public String setProperty(String thePropertyName, String theNewValue) throws StardogException {
        String string;
        block8: {
            HashMap aOptionsMap = Maps.newHashMap();
            aOptionsMap.put(thePropertyName, theNewValue);
            CloseableHttpResponse theResponse = this.executeHttpPost("properties", (JsonObject)new GsonBuilder().create().toJsonTree((Object)aOptionsMap));
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public Map<String, String> getConfiguration(Collection<String> thePropertyNames) throws StardogException {
        HashMap<String, String> hashMap;
        block11: {
            ApacheHttp.Parameters.ParameterListBuilder params = ApacheHttp.Parameters.builder();
            for (String aPropertyName : thePropertyNames) {
                params.parameter("name", aPropertyName);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            CloseableHttpResponse theResponse = this.executeHttpGet(params.uri("properties").toString());
            try {
                String aResult = EntityUtils.toString((HttpEntity)theResponse.getEntity());
                JsonElement aElement = JsonParser.parseString((String)aResult);
                if (aElement != null && aElement.isJsonObject()) {
                    JsonObject aJsonObject = aElement.getAsJsonObject();
                    for (Map.Entry aProp : aJsonObject.entrySet()) {
                        map.put((String)aProp.getKey(), ((JsonElement)aProp.getValue()).getAsString());
                    }
                }
                hashMap = map;
                if (theResponse == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException theE) {
                    throw new StardogException(theE);
                }
            }
            theResponse.close();
        }
        return hashMap;
    }

    @Override
    public String offline(String theDb, long theTimeoutInMs) throws StardogException {
        String string;
        block8: {
            Preconditions.checkArgument((theTimeoutInMs >= 0L ? 1 : 0) != 0, (Object)"Timeout cannot be a negative integer");
            SetOfflineOptions aOptions = new SetOfflineOptions();
            aOptions.setTimeout(theTimeoutInMs);
            CloseableHttpResponse theResponse = this.executeHttpPut("databases/" + theDb + "/offline", aOptions.toJsonObject());
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String online(String theDb) throws StardogException {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpPut("databases/" + theDb + "/online");
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String optimize(String theDb, Metadata theOptions) throws StardogException {
        String string;
        block8: {
            MetadataOptions aOptions = new MetadataOptions(theOptions);
            CloseableHttpResponse theResponse = this.executeHttpPut("databases/" + theDb + "/optimize", aOptions.toJsonObject());
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public String set(String theDb, String theOptionName, String theOptionValue) throws StardogException {
        String string;
        block8: {
            HashMap<String, String> aOptionsMap = new HashMap<String, String>();
            aOptionsMap.put(theOptionName, theOptionValue);
            CloseableHttpResponse theResponse = this.executeHttpPost("databases/" + theDb + "/options", (JsonObject)new GsonBuilder().create().toJsonTree(aOptionsMap));
            try {
                string = HttpAdminClientImpl.returnStringResponseFromMessage(theResponse);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    @Override
    public void setUserEnabled(String theUsername, boolean theEnabled) throws StardogException {
        EnabledOptions aOptions = new EnabledOptions();
        aOptions.setEnabled(theEnabled);
        String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
        try (CloseableHttpResponse theResponse = this.executeHttpPut("users/" + aEncodedUser + "/enabled", aOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    public boolean isUserAutoCreated(String theUsername) {
        boolean bl;
        block8: {
            String aEncodedUser = UrlUtil.encodeUrl((String)theUsername);
            CloseableHttpResponse theResponse = this.executeHttpGet("users/" + aEncodedUser + "/auto_created");
            try {
                JsonSerializableOptions<EnabledOptions> aEnabledBox = HttpAdminClientImpl.parseResponseAsJson(theResponse, EnabledOptions.class);
                bl = ((EnabledOptions)aEnabledBox.getObject()).isEnabled();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return bl;
    }

    @Override
    public void setUserRoles(String theUserName, Collection<String> theRoles) throws StardogException {
        ArrayList<String> theRolesList = new ArrayList<String>(theRoles);
        RoleListingOptions aOptions = new RoleListingOptions();
        aOptions.setRoles(theRolesList);
        String aEncodedUser = UrlUtil.encodeUrl((String)theUserName);
        try (CloseableHttpResponse theResponse = this.executeHttpPut("users/" + aEncodedUser + "/roles", aOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    public Collection<QueryInfo> getAllQueries() throws StardogException {
        List list;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("queries");
            try {
                JsonSerializableOptions<QueryListingOptions> aResult = HttpAdminClientImpl.parseResponseAsJson(theResponse, QueryListingOptions.class);
                list = ((QueryListingOptions)aResult.getObject()).toQueryInfos();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return list;
    }

    public QueryInfo getQuery(String theID) throws StardogException {
        return this.getQuery(theID, false);
    }

    public QueryInfo getQuery(String theQueryID, boolean verbose) throws StardogException {
        QueryInfo queryInfo;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("queries/" + theQueryID + "?plan=true&verbose=" + verbose);
            try {
                JsonSerializableOptions<QueryInfoOptions> aResult = HttpAdminClientImpl.parseResponseAsJson(theResponse, QueryInfoOptions.class);
                queryInfo = ((QueryInfoOptions)aResult.getObject()).toQueryInfo();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return queryInfo;
    }

    public void killQuery(String theQueryID) throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("queries/" + theQueryID);){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Nonnull
    public Collection<ProcessInfo> getAllProcesses(Options theOptions) throws StardogException {
        Collection collection;
        block9: {
            Object path = "processes";
            if (((Boolean)theOptions.get(ProcessManager.SHOW_ALL)).booleanValue()) {
                path = (String)path + "?all=true";
            }
            CloseableHttpResponse aResponse = this.executeHttpGet((String)path);
            try {
                Type processListType = new TypeToken<ArrayList<ProcessInfo>>(this){}.getType();
                collection = (Collection)ApacheHttp.HttpResponses.toObject(aResponse, processListType);
                if (aResponse == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (aResponse != null) {
                        try {
                            aResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            aResponse.close();
        }
        return collection;
    }

    public void filterProcesses(Predicate<ProcessInfo> filter, Consumer<ProcessInfo> sink) {
        this.getAllProcesses(Options.of((Option)ProcessManager.SHOW_ALL, (Object)true)).stream().filter(filter).forEach(sink);
    }

    @Nonnull
    public ProcessInfo getProcess(String theID) throws StardogException {
        ProcessInfo processInfo;
        block8: {
            CloseableHttpResponse aResponse = this.executeHttpGet("processes/" + theID);
            try {
                processInfo = ApacheHttp.HttpResponses.toObject(aResponse, ProcessInfo.class);
                if (aResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (aResponse != null) {
                        try {
                            aResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            aResponse.close();
        }
        return processInfo;
    }

    public void cancelProcess(String theID) throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("processes/" + theID);){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public Collection<StoredQuery> getStoredQueries(Optional<String> db) throws StardogException {
        List list;
        block8: {
            ApacheHttp.Parameters.ParameterListBuilder params = ApacheHttp.Parameters.builder();
            db.ifPresent(value -> params.parameter("db", (String)value));
            URI uri = params.uri("queries/stored");
            CloseableHttpResponse theResponse = this.executeHttpGet(uri.toString(), ACCEPT_TURTLE);
            try {
                List aStatements = HttpAdminClientImpl.parseResponseAsRDF(theResponse, Lists.newArrayList());
                list = StoredQueryIO.fromRDF((Iterable)aStatements);
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return list;
    }

    @Override
    public StoredQuery getStoredQuery(String theQueryName) throws StardogException {
        StoredQuery storedQuery;
        block8: {
            String aEncodedName = UrlUtil.encodeUrl((String)theQueryName);
            CloseableHttpResponse theResponse = this.executeHttpGet("queries/stored/" + aEncodedName, ACCEPT_TURTLE);
            try {
                List aStatements = HttpAdminClientImpl.parseResponseAsRDF(theResponse, Lists.newArrayList());
                storedQuery = (StoredQuery)Iterables.getOnlyElement((Iterable)StoredQueryIO.fromRDF((Iterable)aStatements));
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return storedQuery;
    }

    private String toTurtleString(StoredQuery theQuery) {
        return RDFWriters.toString((Iterable)StoredQueryIO.toRDF((StoredQuery)theQuery), (RDFFormat)RDFFormats.TURTLE);
    }

    @Override
    public void addStoredQuery(StoredQuery theQuery, String id) throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpPost("queries/stored?id=" + id, this.toTurtleString(theQuery), RDFFormats.TURTLE.defaultMimeType());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void updateStoredQuery(StoredQuery theQuery) throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpPut("queries/stored", this.toTurtleString(theQuery), RDFFormats.TURTLE.defaultMimeType());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void removeStoredQuery(String theQueryName) throws StardogException {
        String aEncodedName = UrlUtil.encodeUrl((String)theQueryName);
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("queries/stored/" + aEncodedName);){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void renameStoredQuery(String theOldName, String theNewName) throws StardogException {
        this.renameOrMoveStoredQuery(theOldName, theNewName, false);
    }

    @Override
    public void moveStoredQuery(String theOldName, String theNewName) throws StardogException {
        this.renameOrMoveStoredQuery(theOldName, theNewName, true);
    }

    private void renameOrMoveStoredQuery(String theOldName, String theNewName, boolean move) throws StardogException {
        String aEncodedName = UrlUtil.encodeUrl((String)theOldName);
        NameOptions aOptions = new NameOptions();
        aOptions.setName(theNewName);
        try (CloseableHttpResponse theResponse = this.executeHttpPost("queries/stored/" + aEncodedName + "?move=" + move, aOptions.toJsonObject().toString(), "application/json");){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void clearStoredQueries() throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("queries/stored");){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public Collection<StoredFunction> getStoredFunctions() throws StardogException {
        List list;
        block8: {
            CloseableHttpResponse aResponse = this.executeHttpGet("functions/stored");
            try {
                String aFunctions = ApacheHttp.HttpResponses.toString(aResponse);
                List list2 = list = aFunctions.isEmpty() ? Lists.newArrayList() : ImmutableStoredFunction.parse((String)aFunctions);
                if (aResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (aResponse != null) {
                        try {
                            aResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                    throw Client.toStardogException(e);
                }
            }
            aResponse.close();
        }
        return list;
    }

    @Override
    public StoredFunction getStoredFunction(String theFunctionName) throws StardogException {
        ImmutableStoredFunction immutableStoredFunction;
        block8: {
            URI params = ApacheHttp.Parameters.builder().parameter("name", theFunctionName).uri("functions/stored");
            CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)new HttpGet(this.url(params.toString())));
            try {
                immutableStoredFunction = ImmutableStoredFunction.create((String)ApacheHttp.HttpResponses.toString(aResponse));
                if (aResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (aResponse != null) {
                        try {
                            aResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                    throw Client.toStardogException(e);
                }
            }
            aResponse.close();
        }
        return immutableStoredFunction;
    }

    @Override
    public void loadStoredFunctions(String theFunctions) throws StardogException {
        try (CloseableHttpResponse aResponse = this.executeHttpPost("functions/stored", theFunctions, "text/plain");){
            HttpAdminClientImpl.consumeResponse(aResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void removeStoredFunction(String theFunctionName) throws StardogException {
        URI params = ApacheHttp.Parameters.builder().parameter("name", theFunctionName).uri("functions/stored");
        try (CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)new HttpDelete(this.url(params.toString())));){
            HttpAdminClientImpl.consumeResponse(aResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void clearStoredFunctions() throws StardogException {
        try (CloseableHttpResponse aResponse = this.executeHttpDelete("functions/stored");){
            HttpAdminClientImpl.consumeResponse(aResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Object> currentStatus(Options theOptions) throws StardogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public File generateDiagnosticsReport(DiagnosticsReport theDiagnosticsReport, String thePath) throws StardogException {
        File file;
        block8: {
            String aURL = this.url(thePath);
            ObjectMapper mapper = new ObjectMapper();
            String jsonArgs = mapper.writeValueAsString((Object)theDiagnosticsReport);
            HttpPost post = new HttpPost(ApacheHttp.URIs.uri(aURL, new NameValuePair[0]));
            post.setEntity((HttpEntity)new StringEntity(jsonArgs, ContentType.APPLICATION_JSON));
            CloseableHttpResponse aResponse = this.execute((ClassicHttpRequest)post);
            try {
                InputStream aInputStream = aResponse.getEntity().getContent();
                File aFile = new File(Files.createTempFile(null, null, new FileAttribute[0]).toAbsolutePath().toString());
                aFile.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)aInputStream, (File)aFile);
                BaseHttpClient.checkResponseCode(aResponse);
                file = aFile;
                if (aResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (aResponse != null) {
                        try {
                            aResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
                    throw Client.toStardogException(e);
                }
            }
            aResponse.close();
        }
        return file;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Path getLogs(Options options) throws StardogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Path getOutputFile(String targetDir, Options options) {
        String outputFile = (String)options.get(LogRetriever.Options.OUTPUT_FILE);
        if (outputFile != null) {
            return Paths.get(outputFile, new String[0]);
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String filename = "stardog-logs-" + dateFmt.format(new Date()) + ".zip";
        return Paths.get(targetDir, filename);
    }

    private static Collection<Object> toCollection(JsonArray theArray) {
        ArrayList aList = Lists.newArrayListWithCapacity((int)theArray.size());
        StreamSupport.stream(theArray.spliterator(), false).map(HttpAdminClientImpl::toObject).forEach(aList::add);
        return aList;
    }

    private static Object toObject(JsonElement aElem) {
        if (aElem.isJsonObject()) {
            return HttpAdminClientImpl.toMap(aElem.getAsJsonObject());
        }
        if (aElem.isJsonPrimitive()) {
            return HttpAdminClientImpl.primitiveToObject("", aElem);
        }
        if (aElem.isJsonArray()) {
            return HttpAdminClientImpl.toCollection(aElem.getAsJsonArray());
        }
        return null;
    }

    public static Map<String, Object> toMap(JsonObject theObject) {
        HashMap aResult = Maps.newHashMapWithExpectedSize((int)theObject.entrySet().size());
        theObject.entrySet().forEach(e -> {
            JsonElement aValue = (JsonElement)e.getValue();
            if (aValue.isJsonPrimitive()) {
                aResult.put((String)e.getKey(), HttpAdminClientImpl.primitiveToObject((String)e.getKey(), aValue));
            } else if (aValue.isJsonArray()) {
                aResult.put((String)e.getKey(), HttpAdminClientImpl.toCollection(aValue.getAsJsonArray()));
            } else if (aValue.isJsonObject()) {
                JsonObject aObject = aValue.getAsJsonObject();
                if (aObject.entrySet().size() == 1 && (aObject.has("value") || aObject.has("count"))) {
                    aResult.put((String)e.getKey(), HttpAdminClientImpl.toObject(aObject.has("value") ? aObject.get("value") : aObject.get("count")));
                } else {
                    aResult.put((String)e.getKey(), HttpAdminClientImpl.toMap(aObject));
                }
            }
        });
        return aResult;
    }

    private static Object primitiveToObject(String theKey, JsonElement theValue) {
        if (theValue.getAsJsonPrimitive().isString()) {
            String aValue = theValue.getAsJsonPrimitive().getAsString();
            if ("NaN".equals(aValue)) {
                return Double.NaN;
            }
            return aValue;
        }
        if (theValue.getAsJsonPrimitive().isBoolean()) {
            return theValue.getAsBoolean();
        }
        switch (theKey) {
            case "system.cpu.usage": {
                return theValue.getAsNumber().doubleValue();
            }
        }
        try {
            return Long.parseLong(theValue.getAsNumber().toString());
        }
        catch (NumberFormatException e) {
            return theValue.getAsNumber().doubleValue();
        }
    }

    @Override
    public void shutdown() throws StardogException {
        try (CloseableHttpResponse theResponse = this.executeHttpPost("shutdown");){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void addUserRole(String theUserName, String theRole) throws StardogException {
        CreateRoleOptions aRoleOptions = new CreateRoleOptions();
        aRoleOptions.setRolename(theRole);
        String aEncodedUser = UrlUtil.encodeUrl((String)theUserName);
        try (CloseableHttpResponse theResponse = this.executeHttpPost("users/" + aEncodedUser + "/roles", aRoleOptions.toJsonObject());){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public void deleteUserRole(String theUserName, String theRole) throws StardogException {
        String aEncodedUser = UrlUtil.encodeUrl((String)theUserName);
        String aEncodedRole = UrlUtil.encodeUrl((String)theRole);
        try (CloseableHttpResponse theResponse = this.executeHttpDelete("users/" + aEncodedUser + "/roles/" + aEncodedRole);){
            HttpAdminClientImpl.consumeResponse(theResponse);
        }
        catch (IOException e) {
            throw Client.toStardogException(e);
        }
    }

    public String createNewToken() {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("token");
            try {
                string = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonPrimitive("token").getAsString();
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    public List<JwtIssuerResponse> getIssuers() {
        ArrayList<JwtIssuerResponse> arrayList;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("token/issuers");
            try {
                BaseHttpClient.checkResponseCode(theResponse);
                ArrayList<JwtIssuerResponse> aResponseList = new ArrayList<JwtIssuerResponse>();
                JsonArray aJsonList = HttpAdminClientImpl.parseResponseAsJsonObject(theResponse).getAsJsonArray("issuers");
                aJsonList.forEach(e -> {
                    JsonObject aJsonEnt = e.getAsJsonObject();
                    JwtIssuerResponse aIssuer = new JwtIssuerResponse(aJsonEnt.getAsJsonPrimitive("audience").getAsString(), aJsonEnt.getAsJsonPrimitive("issuerId").getAsString(), aJsonEnt.getAsJsonPrimitive("usernameField").getAsString());
                    aResponseList.add(aIssuer);
                });
                arrayList = aResponseList;
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    throw Client.toStardogException(e2);
                }
            }
            theResponse.close();
        }
        return arrayList;
    }

    @Override
    public String whoami() throws StardogException {
        String string;
        block8: {
            CloseableHttpResponse theResponse = this.executeHttpGet("status/whoami", ACCEPT_ALL);
            try {
                string = ApacheHttp.Entities.toString(theResponse.getEntity());
                if (theResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (theResponse != null) {
                        try {
                            theResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Client.toStardogException(e);
                }
            }
            theResponse.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionLog(String theDb, AdminConnection.TxLogRange range, AdminConnection.StreamConsumer theStreamConsumer) throws UnknownTransactionException {
        String path = "databases/" + theDb + "/txlog?";
        if (range.startTxId != null) {
            path = path + "stxid=" + String.valueOf(range.startTxId) + "&";
        }
        if (range.endTxId != null) {
            path = path + "etxid=" + String.valueOf(range.endTxId) + "&";
        }
        try (CloseableHttpResponse response = this.executeHttpGet(path, ACCEPT_ALL);){
            BaseHttpClient.checkResponseCode(response);
            Path file = Files.createTempFile("stardog-txlog-", ".log", new FileAttribute[0]);
            try {
                Files.copy(response.getEntity().getContent(), file, StandardCopyOption.REPLACE_EXISTING);
                try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                    theStreamConsumer.accept(inputStream);
                }
            }
            finally {
                Files.delete(file);
            }
        }
        catch (Exception e) {
            throw Client.toStardogException(e);
        }
    }

    @Override
    public String replayTransactionLog(String theDb, Path theInputLog, boolean validateLog) {
        String string;
        block9: {
            if (!Files.isReadable(theInputLog)) {
                throw new StardogException("Input log file is not readable: " + String.valueOf(theInputLog));
            }
            String path = "databases/" + theDb + "/txlog";
            path = path + "?validate=" + validateLog;
            HttpPost aPost = new HttpPost(this.url(path));
            aPost.setHeader("Content-Type", (Object)"application/octet-stream");
            aPost.setEntity((HttpEntity)new FileEntity(theInputLog.toFile(), ContentType.APPLICATION_OCTET_STREAM));
            CloseableHttpResponse response = this.execute((ClassicHttpRequest)aPost);
            try {
                BaseHttpClient.checkResponseCode(response);
                JsonObject body = HttpAdminClientImpl.parseResponseAsJsonObject(response);
                string = body.get("message").getAsString();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw Client.toStardogException(e);
                }
            }
            response.close();
        }
        return string;
    }

    private static /* synthetic */ BasicNameValuePair lambda$currentStatus$3(Options theOptions, Option theProp) {
        return new BasicNameValuePair(theProp.getName(), theOptions.get(theProp).toString());
    }
}

