/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Streams;
import com.complexible.common.net.ssl.SSLContextFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public final class ClientSSLEngineSupplier
implements Streams.CheckedSupplier<SSLEngine> {
    private final SSLContext mCxt;

    public ClientSSLEngineSupplier() throws SSLException {
        String aTrustStorePath = System.getProperty("javax.net.ssl.trustStore");
        char[] aTrustStorePwd = System.getProperties().getProperty("javax.net.ssl.trustStorePassword", "").toCharArray();
        String aTrustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
        String aKeyStorePath = System.getProperty("javax.net.ssl.keyStore");
        String aKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        char[] aKeyStorePwd = System.getProperties().getProperty("javax.net.ssl.keyStorePassword", "").toCharArray();
        this.mCxt = SSLContextFactory.createSSLContext((String)aKeyStoreType, (String)aKeyStorePath, (char[])aKeyStorePwd, (String)aTrustStoreType, (String)aTrustStorePath, (char[])aTrustStorePwd);
    }

    public SSLContext getCxt() {
        return this.mCxt;
    }

    public SSLEngine get() throws SSLException {
        return SSLContextFactory.clientEngine((SSLContext)this.mCxt);
    }
}

