/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.client;

import com.complexible.common.base.Options;
import com.complexible.common.base.Streams;
import com.complexible.common.view.Views;
import com.complexible.stardog.InternalStoredQueries;
import com.complexible.stardog.QueryManager;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredFunction;
import com.complexible.stardog.StoredFunctions;
import com.complexible.stardog.StoredQueries;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.admin.AbstractAdminConnection;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DatabaseBuilder;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.process.ProcessManager;
import com.complexible.stardog.protocols.http.client.HttpAdminClient;
import com.complexible.stardog.security.PermissionManager;
import com.complexible.stardog.security.RoleManager;
import com.complexible.stardog.security.StardogSecurityException;
import com.complexible.stardog.security.TokenManager;
import com.complexible.stardog.security.UserManager;
import com.complexible.stardog.util.report.DiagnosticsReport;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.stardog.stark.Resource;
import com.stardog.stark.io.RDFFormats;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdminConnectionImpl
extends AbstractAdminConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminConnectionImpl.class);
    private final HttpAdminClient mClient;
    private final String mServerURL;
    private final Options mConfigOptions;
    private final StoredQueries mQueryStore = new StoredQueriesImpl();
    private final StoredFunctions mFunctionStore = new StoredFunctionsImpl();

    public AdminConnectionImpl(String theServerURL, HttpAdminClient theClient, Views<AdminConnection> theViews, Options theConfig) {
        super(theViews);
        this.mClient = theClient;
        this.mServerURL = theServerURL;
        this.mConfigOptions = theConfig;
    }

    public HttpAdminClient getClient() {
        return this.mClient;
    }

    protected void _close() {
        try {
            this.mClient.close();
        }
        catch (StardogException e) {
            LOGGER.error("There was an error while closing the admin client", (Throwable)e);
        }
    }

    protected DatabaseBuilder newDatabaseBuilder() {
        return new RemoteDbBuilder();
    }

    public void renameDatabase(String theOldName, String theNewName) throws StardogException {
        this.mClient.renameDatabase(theOldName, theNewName);
    }

    public String drop(String theName) throws StardogException {
        return this.mClient.drop(theName);
    }

    protected <T> String _set(String theName, MetaProperty<T> theOption, T theValue) throws StardogException {
        String aStringValue;
        try {
            aStringValue = theOption.getTextIO().write(theValue);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, StardogException.class);
            throw Throwables.propagate((Throwable)e);
        }
        return this.mClient.set(theName, theOption.getName(), aStringValue);
    }

    protected Metadata _get(String theName, Iterable<? extends MetaProperty<?>> theOptions) throws StardogException {
        return this.mClient.get(theName, Streams.stream(theOptions).map(MetaProperty::getName).collect(Collectors.toSet()));
    }

    public String optimize(String theName, Metadata theOptions) throws StardogException {
        return this.mClient.optimize(theName, theOptions);
    }

    public String online(String theName) throws StardogException {
        return this.mClient.online(theName);
    }

    public Metadata getProperty(Collection<String> thePropertyNames) throws StardogException {
        Map<String, String> properties = this.mClient.getConfiguration(thePropertyNames);
        Metadata aMetadata = Metadata.create();
        properties.forEach((k, v) -> {
            MetaProperty aMetaProperty = MetaProperty.config((String)k, (Object)v).temporary().build();
            aMetadata.set(aMetaProperty, v);
        });
        return aMetadata;
    }

    public String setProperty(String thePropertyName, String theNewValue) throws StardogException {
        return this.mClient.setProperty(thePropertyName, theNewValue);
    }

    public String offline(String theName, long theTime, TimeUnit theTimeUnit) throws StardogException {
        Preconditions.checkNotNull((Object)theName, (Object)"The name of the database to offline must be specified");
        Preconditions.checkNotNull((Object)((Object)theTimeUnit), (Object)"Time unit cannot be null");
        Preconditions.checkArgument((theTime >= 0L ? 1 : 0) != 0, (Object)"Timeout duration must be a positive number");
        return this.mClient.offline(theName, theTimeUnit.toMillis(theTime));
    }

    public Collection<String> list() throws StardogException {
        return this.mClient.list();
    }

    public void shutdown() throws StardogSecurityException {
        this.mClient.shutdown();
    }

    public String backup(String theDatabase, Optional<String> theBackupUrl, Options theOptions) throws StardogException {
        return this.mClient.backup(theDatabase, theBackupUrl, theOptions);
    }

    public String backupAll(Options theOptions) throws StardogException {
        return this.mClient.backupAll(theOptions);
    }

    public String restore(File theBackup, boolean theOverwrite, String theName) throws StardogException {
        return this.mClient.restore(theBackup, theOverwrite, theName);
    }

    public String restore(String theBackup, boolean theOverwrite, String theName) throws StardogException {
        return this.mClient.restore(theBackup, theOverwrite, theName);
    }

    public String repair(String theName) throws StardogException {
        return this.mClient.repair(theName);
    }

    public Collection<String> checkpoint(String theDatabase, Options theOptions) throws StardogException {
        return this.mClient.checkpoint(theDatabase, theOptions);
    }

    public String verify(String theName) throws StardogException {
        return this.mClient.verify(theName);
    }

    public String whoami() {
        return this.mClient.whoami();
    }

    public File generateDiagnosticReport(DiagnosticsReport theDiagnosticsReport) {
        return this.mClient.generateDiagnosticsReport(theDiagnosticsReport, "diagnostics");
    }

    public Path getLogs(Options options) {
        return this.mClient.getLogs(options);
    }

    public UserManager getUserManager() {
        return this.mClient;
    }

    public RoleManager getRoleManager() {
        return this.mClient;
    }

    public PermissionManager getPermissionManager() {
        return this.mClient;
    }

    public QueryManager getQueryManager() {
        return this.mClient;
    }

    public ProcessManager getProcessManager() {
        return this.mClient;
    }

    public TokenManager getTokenManager() {
        return this.mClient;
    }

    public Map<String, Object> currentStatus(Options theOptions) throws StardogException {
        return this.mClient.currentStatus(theOptions);
    }

    public StoredQueries getStoredQueries() throws StardogException {
        this.assertOpen();
        return this.mQueryStore;
    }

    public StoredFunctions getStoredFunctions() throws StardogException {
        this.assertOpen();
        return this.mFunctionStore;
    }

    public void transactionLog(String theDb, AdminConnection.TxLogRange range, AdminConnection.StreamConsumer theStreamConsumer) {
        this.mClient.transactionLog(theDb, range, theStreamConsumer);
    }

    public String replayTransactionLog(String theDb, Path theInputLog, boolean validateLog) {
        return this.mClient.replayTransactionLog(theDb, theInputLog, validateLog);
    }

    private class StoredQueriesImpl
    implements InternalStoredQueries {
        private StoredQueriesImpl() {
        }

        public void clear() {
            AdminConnectionImpl.this.mClient.clearStoredQueries();
        }

        public StoredQuery get(String name) throws StardogException {
            return AdminConnectionImpl.this.mClient.getStoredQuery(name);
        }

        public void add(StoredQuery query, String id) throws StardogException {
            AdminConnectionImpl.this.mClient.addStoredQuery(query, id);
        }

        public void update(StoredQuery query) throws StardogException {
            AdminConnectionImpl.this.mClient.updateStoredQuery(query);
        }

        public void remove(String name) throws StardogException {
            AdminConnectionImpl.this.mClient.removeStoredQuery(name);
        }

        public void rename(String oldName, String newName) throws StardogException {
            AdminConnectionImpl.this.mClient.renameStoredQuery(oldName, newName);
        }

        public void move(String oldName, String newPath) throws StardogException {
            AdminConnectionImpl.this.mClient.moveStoredQuery(oldName, newPath);
        }

        public Iterator<StoredQuery> iterator() {
            return AdminConnectionImpl.this.mClient.getStoredQueries(Optional.empty()).iterator();
        }

        public Iterable<StoredQuery> list(Optional<String> db) {
            return AdminConnectionImpl.this.mClient.getStoredQueries(db);
        }
    }

    private class StoredFunctionsImpl
    implements StoredFunctions {
        private StoredFunctionsImpl() {
        }

        public void clear() {
            AdminConnectionImpl.this.mClient.clearStoredFunctions();
        }

        public StoredFunction get(String name) throws StardogException {
            return AdminConnectionImpl.this.mClient.getStoredFunction(name);
        }

        public void load(String functions) throws StardogException {
            AdminConnectionImpl.this.mClient.loadStoredFunctions(functions);
        }

        public void remove(String name) throws StardogException {
            AdminConnectionImpl.this.mClient.removeStoredFunction(name);
        }

        public Iterator<StoredFunction> iterator() {
            return AdminConnectionImpl.this.mClient.getStoredFunctions().iterator();
        }
    }

    private class RemoteDbBuilder
    implements DatabaseBuilder {
        private PrintStream mReporter = System.out;
        private final Metadata mOptions = Metadata.create();
        private boolean mCopyToServer = false;

        private RemoteDbBuilder() {
        }

        public DatabaseBuilder reporter(PrintStream theStream) {
            this.mReporter = theStream;
            return this;
        }

        public <V> DatabaseBuilder set(ConfigProperty<V> theOption, V theValue) {
            this.mOptions.set(theOption, theValue);
            return this;
        }

        public DatabaseBuilder setAll(Metadata theMeta) {
            this.mOptions.setAll(theMeta);
            return this;
        }

        public DatabaseBuilder copyServerSide() {
            this.mCopyToServer = true;
            return this;
        }

        public final ConnectionConfiguration create(Path ... theFiles) throws StardogException {
            return this.create((Path thePath) -> null, theFiles);
        }

        private void recursiveAddFiles(Map<Path, Resource> theMap, Resource theContext, Path theFileOrDirectory, boolean theIsInSubdirectory) {
            block10: {
                if (Files.isDirectory(theFileOrDirectory, new LinkOption[0])) {
                    try (Stream<Path> files = Files.list(theFileOrDirectory);){
                        files.forEach(aFile -> this.recursiveAddFiles(theMap, theContext, (Path)aFile, true));
                        break block10;
                    }
                    catch (IOException e) {
                        throw new StardogException(String.format("Error while walking file path for %s", theFileOrDirectory.toString()), (Throwable)e);
                    }
                }
                if (!theIsInSubdirectory || RDFFormats.forFile((Path)theFileOrDirectory).isPresent()) {
                    theMap.put(theFileOrDirectory, theContext);
                }
            }
        }

        public ConnectionConfiguration create(Function<Path, Resource> theContexts, Path ... theFiles) throws StardogException {
            Preconditions.checkNotNull((Object)theFiles, (Object)"Cannot provide a null list of files");
            HashMap aMap = Maps.newHashMap();
            for (Path aFile : theFiles) {
                Resource aContext = theContexts.apply(aFile);
                if (this.mCopyToServer) {
                    this.recursiveAddFiles(aMap, aContext, aFile, false);
                    continue;
                }
                aMap.put(aFile, aContext);
            }
            String aName = (String)this.mOptions.get((MetaProperty)DatabaseOptions.NAME);
            String aResult = AdminConnectionImpl.this.mClient.create(aName, this.mOptions, aMap, this.mCopyToServer);
            PrintStream aReporter = this.mReporter != null ? this.mReporter : System.out;
            aReporter.println(aResult);
            return ConnectionConfiguration.to((String)aName).server(AdminConnectionImpl.this.mServerURL).credentials((String)AdminConnectionImpl.this.mConfigOptions.get(ConnectionConfiguration.USERNAME), (String)AdminConnectionImpl.this.mConfigOptions.get(ConnectionConfiguration.PASSWORD));
        }
    }
}

